/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRealAndImaginaryToComplexImageFilter_h
#define sitkRealAndImaginaryToComplexImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class RealAndImaginaryToComplexImageFilter
\brief ComposeImageFilter combine several scalar images into a multicomponent image.

ComposeImageFilter combine several scalar images into an itk::Image of vector pixel (itk::Vector , itk::RGBPixel , ...), of std::complex pixel, or in an itk::VectorImage .

\par Inputs and Usage
\code
filter->SetInput( 0, image0 );

filter->SetInput( 1, image1 );

...

filter->Update();

itk::VectorImage< PixelType, dimension >::Pointer = filter->GetOutput();

\endcode
 All input images are expected to have the same template parameters and have the same size and origin.


\see VectorImage 


\see VectorIndexSelectionCastImageFilter
\sa itk::simple::RealAndImaginaryToComplex for the procedural interface
\sa itk::ComposeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RealAndImaginaryToComplexImageFilter : public ImageFilter {
    public:
      using Self = RealAndImaginaryToComplexImageFilter;

      /** Destructor */
      virtual ~RealAndImaginaryToComplexImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RealAndImaginaryToComplexImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("RealAndImaginaryToComplexImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */

      Image Execute ( const Image& image1, const Image& image2 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



    };

    /**\
     * \brief ComposeImageFilter combine several scalar images into a multicomponent image.
     *
     * This function directly calls the execute method of RealAndImaginaryToComplexImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RealAndImaginaryToComplexImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image RealAndImaginaryToComplex ( const Image& image1, const Image& image2 );

     /** @} */
}
#endif
