/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.HomePrintableComponent;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.PageSetupController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PageSetupPanel
extends JPanel
implements DialogView {
    private static final int DEFAULT_SCALE = 100;
    private final PageSetupController controller;
    private PageFormat pageFormat;
    private JButton pageFormatButton;
    private JCheckBox furniturePrintedCheckBox;
    private JCheckBox planPrintedCheckBox;
    private JRadioButton bestFitPlanScaleRadioButton;
    private JRadioButton userPlanScaleRadioButton;
    private JSpinner userPlanScaleSpinner;
    private JLabel printedLevelsLabel;
    private JRadioButton selectedLevelRadioButton;
    private JRadioButton printedLevelsRadioButton;
    private JList printedLevelsList;
    private JCheckBox view3DPrintedCheckBox;
    private JLabel headerFormatLabel;
    private JTextField headerFormatTextField;
    private JLabel footerFormatLabel;
    private JTextField footerFormatTextField;
    private JLabel variablesLabel;
    private JToolBar variableButtonsToolBar;
    private String dialogTitle;

    public PageSetupPanel(UserPreferences userPreferences, PageSetupController pageSetupController) {
        super(new GridBagLayout());
        this.controller = pageSetupController;
        this.createActions(userPreferences);
        this.createComponents(userPreferences, pageSetupController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createActions(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        for (final HomePrintableComponent.Variable variable : HomePrintableComponent.Variable.values()) {
            actionMap.put((Object)variable, new ResourceAction(this, userPreferences, PageSetupPanel.class, "INSERT_" + variable.name()){
                final /* synthetic */ PageSetupPanel this$0;
                {
                    this.this$0 = pageSetupPanel;
                    super(userPreferences, clazz, string);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.insertVariable(variable.getUserCode());
                }
            });
        }
    }

    private void insertVariable(String string) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.replaceSelection(string);
            int n = jTextField.getCaretPosition();
            int n2 = n - string.length();
            jTextField.select(n2, n);
        }
    }

    private void createComponents(UserPreferences userPreferences, final PageSetupController pageSetupController) {
        Object object;
        this.pageFormatButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "pageFormatButton.text", new Object[0]));
        this.furniturePrintedCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "furniturePrintedCheckBox.text", new Object[0]));
        this.planPrintedCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "planPrintedCheckBox.text", new Object[0]));
        this.bestFitPlanScaleRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "bestFitPlanScaleRadioButton.text", new Object[0]));
        this.userPlanScaleRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "userPlanScaleRadioButton.text", new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bestFitPlanScaleRadioButton);
        buttonGroup.add(this.userPlanScaleRadioButton);
        final NullableSpinner.NullableSpinnerNumberModel nullableSpinnerNumberModel = new NullableSpinner.NullableSpinnerNumberModel(10, 1, 10000, 10);
        this.userPlanScaleSpinner = new AutoCommitSpinner(nullableSpinnerNumberModel);
        this.printedLevelsLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "printedLevelsLabel.text", new Object[0]));
        this.selectedLevelRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "selectedLevelRadioButton.text", new Object[0]));
        this.printedLevelsRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "printedLevelsRadioButton.text", new Object[0]));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.selectedLevelRadioButton);
        buttonGroup2.add(this.printedLevelsRadioButton);
        List<Level> list = pageSetupController.getPrintableLevels();
        this.printedLevelsList = new JList<Object>(list.toArray());
        this.printedLevelsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, ((Level)object).getName(), n, bl, bl2);
            }
        });
        this.printedLevelsList.getSelectionModel().setSelectionMode(2);
        this.printedLevelsList.setVisibleRowCount(Math.min(list.size(), 5));
        this.view3DPrintedCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "view3DPrintedCheckBox.text", new Object[0]));
        this.headerFormatLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "headerFormatLabel.text", new Object[0]));
        this.headerFormatTextField = new JTextField(20);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.headerFormatTextField);
        }
        this.footerFormatLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PageSetupPanel.class, "footerFormatLabel.text", new Object[0]));
        this.footerFormatTextField = new JTextField(20);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(this.footerFormatTextField);
        }
        this.variablesLabel = new JLabel(userPreferences.getLocalizedString(PageSetupPanel.class, "variablesLabel.text", new Object[0]));
        this.variableButtonsToolBar = new JToolBar();
        this.variableButtonsToolBar.setFloatable(false);
        ActionMap actionMap = this.getActionMap();
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.PAGE_NUMBER));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.PAGE_COUNT));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.PLAN_SCALE));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.DATE));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.TIME));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.HOME_PRESENTATION_NAME));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.HOME_NAME));
        this.variableButtonsToolBar.add(actionMap.get((Object)HomePrintableComponent.Variable.LEVEL_NAME));
        int n = this.variableButtonsToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            object = (JComponent)this.variableButtonsToolBar.getComponentAtIndex(i);
            ((Component)object).setFocusable(false);
        }
        this.updateComponents(pageSetupController);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.this$0.updateComponents(pageSetupController);
            }
        };
        this.pageFormatButton.addActionListener(new ActionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                this.this$0.pageFormat = printerJob.pageDialog(this.this$0.pageFormat);
                this.this$0.updateController(pageSetupController);
            }
        });
        ItemListener itemListener = new ItemListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                this.this$0.updateController(pageSetupController);
            }
        };
        this.furniturePrintedCheckBox.addItemListener(itemListener);
        this.planPrintedCheckBox.addItemListener(itemListener);
        nullableSpinnerNumberModel.addChangeListener(new ChangeListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                this.this$0.updateController(pageSetupController);
            }
        });
        this.bestFitPlanScaleRadioButton.addActionListener(new ActionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.updateController(pageSetupController);
            }
        });
        this.userPlanScaleRadioButton.addActionListener(new ActionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.this$0.userPlanScaleRadioButton.isSelected() && nullableSpinnerNumberModel.getValue() == null) {
                    nullableSpinnerNumberModel.setValue(100);
                } else {
                    this.this$0.updateController(pageSetupController);
                }
            }
        });
        this.selectedLevelRadioButton.addActionListener(new ActionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.selectedLevelRadioButton.removeActionListener(this);
                this.this$0.updateController(pageSetupController);
                this.this$0.selectedLevelRadioButton.addActionListener(this);
            }
        });
        this.printedLevelsRadioButton.addActionListener(new ActionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.printedLevelsRadioButton.removeActionListener(this);
                this.this$0.updateController(pageSetupController);
                this.this$0.printedLevelsRadioButton.addActionListener(this);
            }
        });
        this.printedLevelsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.this$0.printedLevelsList.getSelectionModel().removeListSelectionListener(this);
                this.this$0.updateController(pageSetupController);
                this.this$0.printedLevelsList.getSelectionModel().addListSelectionListener(this);
            }
        });
        this.view3DPrintedCheckBox.addItemListener(itemListener);
        pageSetupController.addPropertyChangeListener(PageSetupController.Property.PRINT, propertyChangeListener);
        object = new DocumentListener(){
            final /* synthetic */ PageSetupPanel this$0;
            {
                this.this$0 = pageSetupPanel;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                pageSetupController.removePropertyChangeListener(PageSetupController.Property.PRINT, propertyChangeListener);
                this.this$0.updateController(pageSetupController);
                pageSetupController.addPropertyChangeListener(PageSetupController.Property.PRINT, propertyChangeListener);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
        this.headerFormatTextField.getDocument().addDocumentListener((DocumentListener)object);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ActionMap actionMap = PageSetupPanel.this.getActionMap();
                for (HomePrintableComponent.Variable variable : HomePrintableComponent.Variable.values()) {
                    actionMap.get((Object)variable).setEnabled(true);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ActionMap actionMap = PageSetupPanel.this.getActionMap();
                for (HomePrintableComponent.Variable variable : HomePrintableComponent.Variable.values()) {
                    actionMap.get((Object)variable).setEnabled(false);
                }
            }
        };
        this.headerFormatTextField.addFocusListener(focusListener);
        this.footerFormatTextField.getDocument().addDocumentListener((DocumentListener)object);
        this.footerFormatTextField.addFocusListener(focusListener);
        this.dialogTitle = userPreferences.getLocalizedString(PageSetupPanel.class, "pageSetup.title", new Object[0]);
    }

    private void updateComponents(PageSetupController pageSetupController) {
        boolean bl;
        HomePrint homePrint = pageSetupController.getPrint();
        this.pageFormat = HomePrintableComponent.getPageFormat(homePrint);
        try {
            bl = Boolean.getBoolean("com.eteks.sweethome3d.no3D");
        }
        catch (AccessControlException accessControlException) {
            bl = true;
        }
        boolean bl2 = bl ? false : Component3DManager.getInstance().isOffScreenImageSupported();
        NullableSpinner.NullableSpinnerNumberModel nullableSpinnerNumberModel = (NullableSpinner.NullableSpinnerNumberModel)this.userPlanScaleSpinner.getModel();
        List<Level> list = pageSetupController.getPrintableLevels();
        if (homePrint != null) {
            Object object;
            this.furniturePrintedCheckBox.setSelected(homePrint.isFurniturePrinted());
            this.planPrintedCheckBox.setSelected(homePrint.isPlanPrinted());
            this.bestFitPlanScaleRadioButton.setEnabled(homePrint.isPlanPrinted());
            this.userPlanScaleRadioButton.setEnabled(homePrint.isPlanPrinted());
            if (homePrint.getPlanScale() == null) {
                this.bestFitPlanScaleRadioButton.setSelected(true);
            } else {
                this.userPlanScaleRadioButton.setSelected(true);
            }
            this.userPlanScaleSpinner.setEnabled(homePrint.isPlanPrinted() && homePrint.getPlanScale() != null);
            List<Level> list2 = homePrint.getPrintedLevels();
            if (!this.selectedLevelRadioButton.isSelected() && !this.printedLevelsRadioButton.isSelected()) {
                this.selectedLevelRadioButton.setSelected(list2 == null);
                this.printedLevelsRadioButton.setSelected(list2 != null);
            }
            if (list2 != null) {
                object = new int[list2.size()];
                int n = 0;
                for (Level level : list2) {
                    object[n++] = list.indexOf(level);
                }
                this.printedLevelsList.setSelectedIndices((int[])object);
            }
            this.view3DPrintedCheckBox.setSelected(homePrint.isView3DPrinted() && bl2);
            nullableSpinnerNumberModel.setNullable(homePrint.getPlanScale() == null);
            nullableSpinnerNumberModel.setValue(homePrint.getPlanScale() != null ? new Integer(Math.round(1.0f / homePrint.getPlanScale().floatValue())) : null);
            object = homePrint.getHeaderFormat();
            this.headerFormatTextField.setText((String)((int[])(object != null ? object : (int[])"")));
            String string = homePrint.getFooterFormat();
            this.footerFormatTextField.setText(string != null ? string : "");
        } else {
            this.furniturePrintedCheckBox.setSelected(true);
            this.planPrintedCheckBox.setSelected(true);
            this.bestFitPlanScaleRadioButton.setEnabled(true);
            this.bestFitPlanScaleRadioButton.setSelected(true);
            this.userPlanScaleRadioButton.setEnabled(true);
            this.userPlanScaleSpinner.setEnabled(false);
            this.selectedLevelRadioButton.setSelected(true);
            this.printedLevelsList.setEnabled(false);
            this.view3DPrintedCheckBox.setSelected(bl2);
            nullableSpinnerNumberModel.setNullable(true);
            nullableSpinnerNumberModel.setValue(null);
            this.headerFormatTextField.setText("");
            this.footerFormatTextField.setText("");
        }
        this.selectedLevelRadioButton.setEnabled(this.planPrintedCheckBox.isSelected() && !list.isEmpty());
        this.printedLevelsRadioButton.setEnabled(this.planPrintedCheckBox.isSelected() && !list.isEmpty());
        this.printedLevelsList.setEnabled(this.printedLevelsRadioButton.isSelected());
        this.view3DPrintedCheckBox.setEnabled(bl2);
        this.view3DPrintedCheckBox.setVisible(!bl);
    }

    public void updateController(PageSetupController pageSetupController) {
        HomePrint.PaperOrientation paperOrientation;
        switch (this.pageFormat.getOrientation()) {
            case 0: {
                paperOrientation = HomePrint.PaperOrientation.LANDSCAPE;
                break;
            }
            case 2: {
                paperOrientation = HomePrint.PaperOrientation.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                paperOrientation = HomePrint.PaperOrientation.PORTRAIT;
            }
        }
        Paper paper = this.pageFormat.getPaper();
        ArrayList<Level> arrayList = new ArrayList<Level>();
        for (Object object : this.printedLevelsList.getSelectedValues()) {
            arrayList.add((Level)object);
        }
        HomePrint homePrint = new HomePrint(paperOrientation, (float)paper.getWidth(), (float)paper.getHeight(), (float)paper.getImageableY(), (float)paper.getImageableX(), (float)(paper.getHeight() - paper.getImageableHeight() - paper.getImageableY()), (float)(paper.getWidth() - paper.getImageableWidth() - paper.getImageableX()), this.furniturePrintedCheckBox.isSelected(), this.planPrintedCheckBox.isSelected(), this.printedLevelsRadioButton.isSelected() && !arrayList.isEmpty() ? arrayList : null, this.view3DPrintedCheckBox.isSelected(), this.userPlanScaleRadioButton.isSelected() && this.userPlanScaleSpinner.getValue() != null ? Float.valueOf(1.0f / (float)((Number)this.userPlanScaleSpinner.getValue()).intValue()) : null, this.headerFormatTextField.getText().trim(), this.footerFormatTextField.getText().trim());
        pageSetupController.setPrint(homePrint);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.pageFormatButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "pageFormatButton.mnemonic", new Object[0])).getKeyCode());
            this.furniturePrintedCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "furniturePrintedCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.planPrintedCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "planPrintedCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.selectedLevelRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "selectedLevelRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.printedLevelsRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "printedLevelsRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.view3DPrintedCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "view3DPrintedCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.bestFitPlanScaleRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "bestFitPlanScaleRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.userPlanScaleRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "userPlanScaleRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.headerFormatLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "headerFormatLabel.mnemonic", new Object[0])).getKeyCode());
            this.headerFormatLabel.setLabelFor(this.headerFormatTextField);
            this.footerFormatLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PageSetupPanel.class, "footerFormatLabel.mnemonic", new Object[0])).getKeyCode());
            this.footerFormatLabel.setLabelFor(this.footerFormatTextField);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.pageFormatButton, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        Insets insets = new Insets(0, 0, n2, 0);
        jPanel.add((Component)this.furniturePrintedCheckBox, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.planPrintedCheckBox, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)this.bestFitPlanScaleRadioButton, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 20, 2, 0), 0, 0));
        jPanel.add((Component)this.userPlanScaleRadioButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 20, n2, 0), 0, 0));
        jPanel.add((Component)this.userPlanScaleSpinner, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        if (this.printedLevelsList.getModel().getSize() > 1) {
            jPanel.add((Component)this.printedLevelsLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 25, n2, n2), 0, 0));
            jPanel.add((Component)this.selectedLevelRadioButton, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
            jPanel.add((Component)this.printedLevelsRadioButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, n2, 0), 0, 0));
            JScrollPane jScrollPane = new JScrollPane(this.printedLevelsList);
            Dimension dimension = jScrollPane.getPreferredSize();
            dimension.width = Math.min(dimension.width, Math.round(150.0f * SwingTools.getResolutionScale()));
            jScrollPane.setPreferredSize(dimension);
            jPanel.add((Component)jScrollPane, new GridBagConstraints(2, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, n2, n2, 0), 0, 0));
        }
        jPanel.add((Component)this.view3DPrintedCheckBox, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, n2, 0), -10, 0));
        this.add((Component)this.headerFormatLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        this.add((Component)this.headerFormatTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.footerFormatLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        this.add((Component)this.footerFormatTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.variablesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        this.add((Component)this.variableButtonsToolBar, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.pageFormatButton) == 0 && this.controller != null) {
            this.controller.modifyPageSetup();
        }
    }
}

