/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCookieInit.h"

#include "JSCookieSameSite.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CookieInit>> convertDictionary<CookieInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CookieInit result;
    JSValue domainValue;
    if (isNullOrUndefined)
        domainValue = jsUndefined();
    else {
        domainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "domain"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto domainConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(lexicalGlobalObject, domainValue, [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (UNLIKELY(domainConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.domain = domainConversionResult.releaseReturnValue();
    JSValue expiresValue;
    if (isNullOrUndefined)
        expiresValue = jsUndefined();
    else {
        expiresValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expires"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto expiresConversionResult = convertOptionalWithDefault<IDLNullable<IDLDouble>>(lexicalGlobalObject, expiresValue, [&]() -> ConversionResult<IDLNullable<IDLDouble>> { return typename Converter<IDLNullable<IDLDouble>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(expiresConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.expires = expiresConversionResult.releaseReturnValue();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "CookieInit"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLUSVString>(lexicalGlobalObject, nameValue);
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue pathValue;
    if (isNullOrUndefined)
        pathValue = jsUndefined();
    else {
        pathValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "path"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pathConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, pathValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { "/"_s }; });
    if (UNLIKELY(pathConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.path = pathConversionResult.releaseReturnValue();
    JSValue sameSiteValue;
    if (isNullOrUndefined)
        sameSiteValue = jsUndefined();
    else {
        sameSiteValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sameSite"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sameSiteConversionResult = convertOptionalWithDefault<IDLEnumeration<CookieSameSite>>(lexicalGlobalObject, sameSiteValue, [&]() -> ConversionResult<IDLEnumeration<CookieSameSite>> { return Converter<IDLEnumeration<CookieSameSite>>::ReturnType { CookieSameSite::Strict }; });
    if (UNLIKELY(sameSiteConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.sameSite = sameSiteConversionResult.releaseReturnValue();
    JSValue valueValue;
    if (isNullOrUndefined)
        valueValue = jsUndefined();
    else {
        valueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "value"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (valueValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "value"_s, "CookieInit"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto valueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, valueValue);
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.value = valueConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
