/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCommandEncoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBuffer.h"
#include "JSGPUCommandBuffer.h"
#include "JSGPUCommandBufferDescriptor.h"
#include "JSGPUComputePassDescriptor.h"
#include "JSGPUComputePassEncoder.h"
#include "JSGPUExtent3DDict.h"
#include "JSGPUImageCopyBuffer.h"
#include "JSGPUImageCopyTexture.h"
#include "JSGPUQuerySet.h"
#include "JSGPURenderPassDescriptor.h"
#include "JSGPURenderPassEncoder.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_beginRenderPass);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_beginComputePass);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyBufferToBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyBufferToTexture);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyTextureToBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyTextureToTexture);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_clearBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_resolveQuerySet);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_finish);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_pushDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_popDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_insertDebugMarker);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUCommandEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCommandEncoder_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUCommandEncoder_label);

class JSGPUCommandEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUCommandEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUCommandEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUCommandEncoderPrototype>(vm)) JSGPUCommandEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCommandEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUCommandEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCommandEncoderPrototype, JSGPUCommandEncoderPrototype::Base);

using JSGPUCommandEncoderDOMConstructor = JSDOMConstructorNotConstructable<JSGPUCommandEncoder>;

template<> const ClassInfo JSGPUCommandEncoderDOMConstructor::s_info = { "GPUCommandEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCommandEncoderDOMConstructor) };

template<> JSValue JSGPUCommandEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUCommandEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUCommandEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUCommandEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUCommandEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCommandEncoderConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCommandEncoder_label, setJSGPUCommandEncoder_label } },
    { "beginRenderPass"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_beginRenderPass, 1 } },
    { "beginComputePass"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_beginComputePass, 0 } },
    { "copyBufferToBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_copyBufferToBuffer, 5 } },
    { "copyBufferToTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_copyBufferToTexture, 3 } },
    { "copyTextureToBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_copyTextureToBuffer, 3 } },
    { "copyTextureToTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_copyTextureToTexture, 3 } },
    { "clearBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_clearBuffer, 1 } },
    { "resolveQuerySet"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_resolveQuerySet, 5 } },
    { "finish"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_finish, 0 } },
    { "pushDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_pushDebugGroup, 1 } },
    { "popDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_popDebugGroup, 0 } },
    { "insertDebugMarker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUCommandEncoderPrototypeFunction_insertDebugMarker, 1 } },
};

const ClassInfo JSGPUCommandEncoderPrototype::s_info = { "GPUCommandEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCommandEncoderPrototype) };

void JSGPUCommandEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUCommandEncoder::info(), JSGPUCommandEncoderPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pushDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "popDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "insertDebugMarker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUCommandEncoder::s_info = { "GPUCommandEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCommandEncoder) };

JSGPUCommandEncoder::JSGPUCommandEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUCommandEncoder>&& impl)
    : JSDOMWrapper<GPUCommandEncoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUCommandEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUCommandEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUCommandEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUCommandEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUCommandEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUCommandEncoder>(vm, globalObject);
}

JSValue JSGPUCommandEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUCommandEncoderDOMConstructor, DOMConstructorID::GPUCommandEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUCommandEncoder::destroy(JSC::JSCell* cell)
{
    JSGPUCommandEncoder* thisObject = static_cast<JSGPUCommandEncoder*>(cell);
    thisObject->JSGPUCommandEncoder::~JSGPUCommandEncoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCommandEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCommandEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUCommandEncoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUCommandEncoder_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCommandEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCommandEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCommandEncoder>::get<jsGPUCommandEncoder_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUCommandEncoder_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUCommandEncoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUCommandEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCommandEncoder>::set<setJSGPUCommandEncoder_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_beginRenderPassBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPURenderPassDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(descriptorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPURenderPassEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.beginRenderPass(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_beginRenderPass, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_beginRenderPassBody>(*lexicalGlobalObject, *callFrame, "beginRenderPass");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_beginComputePassBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUComputePassDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(descriptorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUComputePassEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.beginComputePass(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_beginComputePass, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_beginComputePassBody>(*lexicalGlobalObject, *callFrame, "beginComputePass");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_copyBufferToBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sourceConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source"_s, "GPUCommandEncoder"_s, "copyBufferToBuffer"_s, "GPUBuffer"_s); });
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sourceOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(sourceOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto destinationConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "destination"_s, "GPUCommandEncoder"_s, "copyBufferToBuffer"_s, "GPUBuffer"_s); });
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto destinationOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(destinationOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto sizeConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(sizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyBufferToBuffer(*sourceConversionResult.releaseReturnValue(), sourceOffsetConversionResult.releaseReturnValue(), *destinationConversionResult.releaseReturnValue(), destinationOffsetConversionResult.releaseReturnValue(), sizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyBufferToBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_copyBufferToBufferBody>(*lexicalGlobalObject, *callFrame, "copyBufferToBuffer");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_copyBufferToTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sourceConversionResult = convert<IDLDictionary<GPUImageCopyBuffer>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto destinationConversionResult = convert<IDLDictionary<GPUImageCopyTexture>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto copySizeConversionResult = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUExtent3DDict>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(copySizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyBufferToTexture(sourceConversionResult.releaseReturnValue(), destinationConversionResult.releaseReturnValue(), copySizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyBufferToTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_copyBufferToTextureBody>(*lexicalGlobalObject, *callFrame, "copyBufferToTexture");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_copyTextureToBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sourceConversionResult = convert<IDLDictionary<GPUImageCopyTexture>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto destinationConversionResult = convert<IDLDictionary<GPUImageCopyBuffer>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto copySizeConversionResult = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUExtent3DDict>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(copySizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTextureToBuffer(sourceConversionResult.releaseReturnValue(), destinationConversionResult.releaseReturnValue(), copySizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyTextureToBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_copyTextureToBufferBody>(*lexicalGlobalObject, *callFrame, "copyTextureToBuffer");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_copyTextureToTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sourceConversionResult = convert<IDLDictionary<GPUImageCopyTexture>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto destinationConversionResult = convert<IDLDictionary<GPUImageCopyTexture>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto copySizeConversionResult = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUExtent3DDict>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(copySizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTextureToTexture(sourceConversionResult.releaseReturnValue(), destinationConversionResult.releaseReturnValue(), copySizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_copyTextureToTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_copyTextureToTextureBody>(*lexicalGlobalObject, *callFrame, "copyTextureToTexture");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_clearBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufferConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer"_s, "GPUCommandEncoder"_s, "clearBuffer"_s, "GPUBuffer"_s); });
    if (UNLIKELY(bufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto offsetConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto sizeConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(sizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearBuffer(*bufferConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue(), sizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_clearBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_clearBufferBody>(*lexicalGlobalObject, *callFrame, "clearBuffer");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_resolveQuerySetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto querySetConversionResult = convert<IDLInterface<GPUQuerySet>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "querySet"_s, "GPUCommandEncoder"_s, "resolveQuerySet"_s, "GPUQuerySet"_s); });
    if (UNLIKELY(querySetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto firstQueryConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(firstQueryConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto queryCountConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(queryCountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto destinationConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument3.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "destination"_s, "GPUCommandEncoder"_s, "resolveQuerySet"_s, "GPUBuffer"_s); });
    if (UNLIKELY(destinationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto destinationOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(destinationOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.resolveQuerySet(*querySetConversionResult.releaseReturnValue(), firstQueryConversionResult.releaseReturnValue(), queryCountConversionResult.releaseReturnValue(), *destinationConversionResult.releaseReturnValue(), destinationOffsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_resolveQuerySet, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_resolveQuerySetBody>(*lexicalGlobalObject, *callFrame, "resolveQuerySet");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_finishBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUCommandBufferDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(descriptorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUCommandBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.finish(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_finish, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_finishBody>(*lexicalGlobalObject, *callFrame, "finish");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_pushDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto groupLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(groupLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushDebugGroup(groupLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_pushDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_pushDebugGroupBody>(*lexicalGlobalObject, *callFrame, "pushDebugGroup");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_popDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.popDebugGroup(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_popDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_popDebugGroupBody>(*lexicalGlobalObject, *callFrame, "popDebugGroup");
}

static inline JSC::EncodedJSValue jsGPUCommandEncoderPrototypeFunction_insertDebugMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCommandEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto markerLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(markerLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.insertDebugMarker(markerLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUCommandEncoderPrototypeFunction_insertDebugMarker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUCommandEncoder>::call<jsGPUCommandEncoderPrototypeFunction_insertDebugMarkerBody>(*lexicalGlobalObject, *callFrame, "insertDebugMarker");
}

JSC::GCClient::IsoSubspace* JSGPUCommandEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUCommandEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUCommandEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUCommandEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUCommandEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUCommandEncoder = std::forward<decltype(space)>(space); }
    );
}

void JSGPUCommandEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUCommandEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUCommandEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUCommandEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUCommandEncoder = static_cast<JSGPUCommandEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUCommandEncoder->protectedWrapped().ptr(), jsGPUCommandEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUCommandEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17GPUCommandEncoderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUCommandEncoder>, void>> static inline void verifyVTable(GPUCommandEncoder* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUCommandEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17GPUCommandEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUCommandEncoder has subclasses. If GPUCommandEncoder has subclasses that get passed
        // to toJS() we currently require GPUCommandEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUCommandEncoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUCommandEncoder>(impl.ptr());
#endif
    return createWrapper<GPUCommandEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUCommandEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUCommandEncoder* JSGPUCommandEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUCommandEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
