/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUImageCopyTexture.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUOrigin3DDict.h"
#include "JSGPUTexture.h"
#include "JSGPUTextureAspect.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUImageCopyTexture>> convertDictionary<GPUImageCopyTexture>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUImageCopyTexture result;
    JSValue aspectValue;
    if (isNullOrUndefined)
        aspectValue = jsUndefined();
    else {
        aspectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspect"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto aspectConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUTextureAspect>>(lexicalGlobalObject, aspectValue, [&]() -> ConversionResult<IDLEnumeration<GPUTextureAspect>> { return Converter<IDLEnumeration<GPUTextureAspect>>::ReturnType { GPUTextureAspect::All }; });
    if (UNLIKELY(aspectConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.aspect = aspectConversionResult.releaseReturnValue();
    JSValue mipLevelValue;
    if (isNullOrUndefined)
        mipLevelValue = jsUndefined();
    else {
        mipLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mipLevelConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (UNLIKELY(mipLevelConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.mipLevel = mipLevelConversionResult.releaseReturnValue();
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!originValue.isUndefined()) {
        auto originConversionResult = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUOrigin3DDict>>>(lexicalGlobalObject, originValue);
        if (UNLIKELY(originConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.origin = originConversionResult.releaseReturnValue();
    }
    JSValue textureValue;
    if (isNullOrUndefined)
        textureValue = jsUndefined();
    else {
        textureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "texture"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (textureValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "texture"_s, "GPUImageCopyTexture"_s, "GPUTexture"_s);
        return ConversionResultException { };
    }
    auto textureConversionResult = convert<IDLInterface<GPUTexture>>(lexicalGlobalObject, textureValue);
    if (UNLIKELY(textureConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.texture = textureConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
