/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassEncoder.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroup.h"
#include "JSGPUBuffer.h"
#include "JSGPUColorDict.h"
#include "JSGPUIndexFormat.h"
#include "JSGPURenderBundle.h"
#include "JSGPURenderPipeline.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setViewport);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setScissorRect);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setBlendConstant);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setStencilReference);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_beginOcclusionQuery);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_endOcclusionQuery);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_executeBundles);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_end);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_pushDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_popDebugGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_insertDebugMarker);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setBindGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setPipeline);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setIndexBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setVertexBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_draw);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndexed);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndirect);
static JSC_DECLARE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndexedIndirect);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderPassEncoderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPURenderPassEncoder_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPURenderPassEncoder_label);

class JSGPURenderPassEncoderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPURenderPassEncoderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPURenderPassEncoderPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPURenderPassEncoderPrototype>(vm)) JSGPURenderPassEncoderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderPassEncoderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPURenderPassEncoderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPURenderPassEncoderPrototype, JSGPURenderPassEncoderPrototype::Base);

using JSGPURenderPassEncoderDOMConstructor = JSDOMConstructorNotConstructable<JSGPURenderPassEncoder>;

template<> const ClassInfo JSGPURenderPassEncoderDOMConstructor::s_info = { "GPURenderPassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPassEncoderDOMConstructor) };

template<> JSValue JSGPURenderPassEncoderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPURenderPassEncoderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPURenderPassEncoder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPURenderPassEncoder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPURenderPassEncoderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderPassEncoderConstructor, 0 } },
    { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPURenderPassEncoder_label, setJSGPURenderPassEncoder_label } },
    { "setViewport"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setViewport, 6 } },
    { "setScissorRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setScissorRect, 4 } },
    { "setBlendConstant"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setBlendConstant, 1 } },
    { "setStencilReference"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setStencilReference, 1 } },
    { "beginOcclusionQuery"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_beginOcclusionQuery, 1 } },
    { "endOcclusionQuery"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_endOcclusionQuery, 0 } },
    { "executeBundles"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_executeBundles, 1 } },
    { "end"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_end, 0 } },
    { "pushDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_pushDebugGroup, 1 } },
    { "popDebugGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_popDebugGroup, 0 } },
    { "insertDebugMarker"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_insertDebugMarker, 1 } },
    { "setBindGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setBindGroup, 2 } },
    { "setPipeline"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setPipeline, 1 } },
    { "setIndexBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setIndexBuffer, 2 } },
    { "setVertexBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_setVertexBuffer, 2 } },
    { "draw"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_draw, 1 } },
    { "drawIndexed"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_drawIndexed, 1 } },
    { "drawIndirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_drawIndirect, 2 } },
    { "drawIndexedIndirect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPURenderPassEncoderPrototypeFunction_drawIndexedIndirect, 2 } },
};

const ClassInfo JSGPURenderPassEncoderPrototype::s_info = { "GPURenderPassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPassEncoderPrototype) };

void JSGPURenderPassEncoderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPURenderPassEncoder::info(), JSGPURenderPassEncoderPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "pushDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "popDebugGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "insertDebugMarker"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setBindGroup"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setPipeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setIndexBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setVertexBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "draw"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndexed"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndirect"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "drawIndexedIndirect"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPURenderPassEncoder::s_info = { "GPURenderPassEncoder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPURenderPassEncoder) };

JSGPURenderPassEncoder::JSGPURenderPassEncoder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPURenderPassEncoder>&& impl)
    : JSDOMWrapper<GPURenderPassEncoder>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPURenderPassEncoder>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPURenderPassEncoder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPURenderPassEncoderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPURenderPassEncoderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPURenderPassEncoder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPURenderPassEncoder>(vm, globalObject);
}

JSValue JSGPURenderPassEncoder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPURenderPassEncoderDOMConstructor, DOMConstructorID::GPURenderPassEncoder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPURenderPassEncoder::destroy(JSC::JSCell* cell)
{
    JSGPURenderPassEncoder* thisObject = static_cast<JSGPURenderPassEncoder*>(cell);
    thisObject->JSGPURenderPassEncoder::~JSGPURenderPassEncoder();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderPassEncoderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPURenderPassEncoderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPURenderPassEncoder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPURenderPassEncoder_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderPassEncoder& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPURenderPassEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderPassEncoder>::get<jsGPURenderPassEncoder_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPURenderPassEncoder_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPURenderPassEncoder& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPURenderPassEncoder_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPURenderPassEncoder>::set<setJSGPURenderPassEncoder_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setViewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto widthConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto heightConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto minDepthConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(minDepthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto maxDepthConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(maxDepthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setViewport(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue(), minDepthConversionResult.releaseReturnValue(), maxDepthConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setViewport, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setViewportBody>(*lexicalGlobalObject, *callFrame, "setViewport");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setScissorRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(xConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(yConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto widthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(widthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto heightConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(heightConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setScissorRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setScissorRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setScissorRectBody>(*lexicalGlobalObject, *callFrame, "setScissorRect");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setBlendConstantBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto colorConversionResult = convert<IDLUnion<IDLSequence<IDLDouble>, IDLDictionary<GPUColorDict>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(colorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBlendConstant(colorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setBlendConstant, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setBlendConstantBody>(*lexicalGlobalObject, *callFrame, "setBlendConstant");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setStencilReferenceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto referenceConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(referenceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setStencilReference(referenceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setStencilReference, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setStencilReferenceBody>(*lexicalGlobalObject, *callFrame, "setStencilReference");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_beginOcclusionQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryIndexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(queryIndexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginOcclusionQuery(queryIndexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_beginOcclusionQuery, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_beginOcclusionQueryBody>(*lexicalGlobalObject, *callFrame, "beginOcclusionQuery");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_endOcclusionQueryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endOcclusionQuery(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_endOcclusionQuery, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_endOcclusionQueryBody>(*lexicalGlobalObject, *callFrame, "endOcclusionQuery");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_executeBundlesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bundlesConversionResult = convert<IDLSequence<IDLInterface<GPURenderBundle>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(bundlesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.executeBundles(bundlesConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_executeBundles, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_executeBundlesBody>(*lexicalGlobalObject, *callFrame, "executeBundles");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_endBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.end(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_end, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_endBody>(*lexicalGlobalObject, *callFrame, "end");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_pushDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto groupLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(groupLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushDebugGroup(groupLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_pushDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_pushDebugGroupBody>(*lexicalGlobalObject, *callFrame, "pushDebugGroup");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_popDebugGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.popDebugGroup(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_popDebugGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_popDebugGroupBody>(*lexicalGlobalObject, *callFrame, "popDebugGroup");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_insertDebugMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto markerLabelConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(markerLabelConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.insertDebugMarker(markerLabelConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_insertDebugMarker, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_insertDebugMarkerBody>(*lexicalGlobalObject, *callFrame, "insertDebugMarker");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setBindGroup1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroupConversionResult = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup"_s, "GPURenderPassEncoder"_s, "setBindGroup"_s, "GPUBindGroup"_s); });
    if (UNLIKELY(bindGroupConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto dynamicOffsetsConversionResult = convertOptionalWithDefault<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>> { return Converter<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>::ReturnType { }; });
    if (UNLIKELY(dynamicOffsetsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(indexConversionResult.releaseReturnValue(), *bindGroupConversionResult.releaseReturnValue(), dynamicOffsetsConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setBindGroup2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bindGroupConversionResult = convert<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "bindGroup"_s, "GPURenderPassEncoder"_s, "setBindGroup"_s, "GPUBindGroup"_s); });
    if (UNLIKELY(bindGroupConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dynamicOffsetsDataConversionResult = convert<IDLUint32Array>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "dynamicOffsetsData"_s, "GPURenderPassEncoder"_s, "setBindGroup"_s, "Uint32Array"_s); });
    if (UNLIKELY(dynamicOffsetsDataConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dynamicOffsetsDataStartConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(dynamicOffsetsDataStartConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dynamicOffsetsDataLengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(dynamicOffsetsDataLengthConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setBindGroup(indexConversionResult.releaseReturnValue(), *bindGroupConversionResult.releaseReturnValue(), dynamicOffsetsDataConversionResult.releaseReturnValue(), dynamicOffsetsDataStartConversionResult.releaseReturnValue(), dynamicOffsetsDataLengthConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setBindGroupOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderPassEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderPassEncoderPrototypeFunction_setBindGroup1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsGPURenderPassEncoderPrototypeFunction_setBindGroup2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setBindGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setBindGroupOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setBindGroup");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pipelineConversionResult = convert<IDLInterface<GPURenderPipeline>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "pipeline"_s, "GPURenderPassEncoder"_s, "setPipeline"_s, "GPURenderPipeline"_s); });
    if (UNLIKELY(pipelineConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPipeline(*pipelineConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setPipeline, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setPipelineBody>(*lexicalGlobalObject, *callFrame, "setPipeline");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setIndexBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto bufferConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer"_s, "GPURenderPassEncoder"_s, "setIndexBuffer"_s, "GPUBuffer"_s); });
    if (UNLIKELY(bufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexFormatConversionResult = convert<IDLEnumeration<GPUIndexFormat>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "indexFormat"_s, "GPURenderPassEncoder"_s, "setIndexBuffer"_s, expectedEnumerationValues<GPUIndexFormat>()); });
    if (UNLIKELY(indexFormatConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto offsetConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto sizeConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(sizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setIndexBuffer(*bufferConversionResult.releaseReturnValue(), indexFormatConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue(), sizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setIndexBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setIndexBufferBody>(*lexicalGlobalObject, *callFrame, "setIndexBuffer");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_setVertexBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto slotConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(slotConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bufferConversionResult = convert<IDLNullable<IDLInterface<GPUBuffer>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "buffer"_s, "GPURenderPassEncoder"_s, "setVertexBuffer"_s, "GPUBuffer"_s); });
    if (UNLIKELY(bufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto offsetConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto sizeConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(sizeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setVertexBuffer(slotConversionResult.releaseReturnValue(), bufferConversionResult.releaseReturnValue(), offsetConversionResult.releaseReturnValue(), sizeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_setVertexBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_setVertexBufferBody>(*lexicalGlobalObject, *callFrame, "setVertexBuffer");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_drawBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto vertexCountConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(vertexCountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto instanceCountConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(instanceCountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto firstVertexConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(firstVertexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto firstInstanceConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(firstInstanceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.draw(vertexCountConversionResult.releaseReturnValue(), instanceCountConversionResult.releaseReturnValue(), firstVertexConversionResult.releaseReturnValue(), firstInstanceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_draw, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_drawBody>(*lexicalGlobalObject, *callFrame, "draw");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_drawIndexedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexCountConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexCountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto instanceCountConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(instanceCountConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto firstIndexConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(firstIndexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto baseVertexConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLLong>>>(*lexicalGlobalObject, argument3.value());
    if (UNLIKELY(baseVertexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto firstInstanceConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLong>>>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(firstInstanceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndexed(indexCountConversionResult.releaseReturnValue(), instanceCountConversionResult.releaseReturnValue(), firstIndexConversionResult.releaseReturnValue(), baseVertexConversionResult.releaseReturnValue(), firstInstanceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndexed, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_drawIndexedBody>(*lexicalGlobalObject, *callFrame, "drawIndexed");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_drawIndirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indirectBufferConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "indirectBuffer"_s, "GPURenderPassEncoder"_s, "drawIndirect"_s, "GPUBuffer"_s); });
    if (UNLIKELY(indirectBufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indirectOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indirectOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndirect(*indirectBufferConversionResult.releaseReturnValue(), indirectOffsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_drawIndirectBody>(*lexicalGlobalObject, *callFrame, "drawIndirect");
}

static inline JSC::EncodedJSValue jsGPURenderPassEncoderPrototypeFunction_drawIndexedIndirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPURenderPassEncoder>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indirectBufferConversionResult = convert<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "indirectBuffer"_s, "GPURenderPassEncoder"_s, "drawIndexedIndirect"_s, "GPUBuffer"_s); });
    if (UNLIKELY(indirectBufferConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indirectOffsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indirectOffsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawIndexedIndirect(*indirectBufferConversionResult.releaseReturnValue(), indirectOffsetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPURenderPassEncoderPrototypeFunction_drawIndexedIndirect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPURenderPassEncoder>::call<jsGPURenderPassEncoderPrototypeFunction_drawIndexedIndirectBody>(*lexicalGlobalObject, *callFrame, "drawIndexedIndirect");
}

JSC::GCClient::IsoSubspace* JSGPURenderPassEncoder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPURenderPassEncoder, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPURenderPassEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPURenderPassEncoder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPURenderPassEncoder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPURenderPassEncoder = std::forward<decltype(space)>(space); }
    );
}

void JSGPURenderPassEncoder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPURenderPassEncoder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPURenderPassEncoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPURenderPassEncoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPURenderPassEncoder = static_cast<JSGPURenderPassEncoder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPURenderPassEncoder->protectedWrapped().ptr(), jsGPURenderPassEncoder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPURenderPassEncoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20GPURenderPassEncoderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPURenderPassEncoder>, void>> static inline void verifyVTable(GPURenderPassEncoder* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPURenderPassEncoder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20GPURenderPassEncoderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPURenderPassEncoder has subclasses. If GPURenderPassEncoder has subclasses that get passed
        // to toJS() we currently require GPURenderPassEncoder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPURenderPassEncoder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPURenderPassEncoder>(impl.ptr());
#endif
    return createWrapper<GPURenderPassEncoder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPURenderPassEncoder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPURenderPassEncoder* JSGPURenderPassEncoder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPURenderPassEncoder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
