/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUShaderModuleDescriptor.h"

#include "JSDOMConvertObject.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUShaderModuleCompilationHint.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUShaderModuleDescriptor>> convertDictionary<GPUShaderModuleDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUShaderModuleDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (UNLIKELY(labelConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue codeValue;
    if (isNullOrUndefined)
        codeValue = jsUndefined();
    else {
        codeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "code"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (codeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "code"_s, "GPUShaderModuleDescriptor"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto codeConversionResult = convert<IDLUSVString>(lexicalGlobalObject, codeValue);
    if (UNLIKELY(codeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.code = codeConversionResult.releaseReturnValue();
    JSValue hintsValue;
    if (isNullOrUndefined)
        hintsValue = jsUndefined();
    else {
        hintsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hints"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!hintsValue.isUndefined()) {
        auto hintsConversionResult = convert<IDLRecord<IDLUSVString, IDLDictionary<GPUShaderModuleCompilationHint>>>(lexicalGlobalObject, hintsValue);
        if (UNLIKELY(hintsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.hints = hintsConversionResult.releaseReturnValue();
    }
    JSValue sourceMapValue;
    if (isNullOrUndefined)
        sourceMapValue = jsUndefined();
    else {
        sourceMapValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sourceMap"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sourceMapValue.isUndefined()) {
        auto sourceMapConversionResult = convert<IDLObject>(lexicalGlobalObject, sourceMapValue);
        if (UNLIKELY(sourceMapConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.sourceMap = sourceMapConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
