/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaDevices.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSInputDeviceInfo.h"
#include "JSMediaDeviceInfo.h"
#include "JSMediaStream.h"
#include "JSMediaTrackConstraints.h"
#include "JSMediaTrackSupportedConstraints.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

String convertEnumerationToString(MediaDevices::DisplayCaptureSurfaceType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("monitor"),
        MAKE_STATIC_STRING_IMPL("window"),
        MAKE_STATIC_STRING_IMPL("application"),
        MAKE_STATIC_STRING_IMPL("browser"),
    };
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Monitor) == 0, "MediaDevices::DisplayCaptureSurfaceType::Monitor is not 0 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Window) == 1, "MediaDevices::DisplayCaptureSurfaceType::Window is not 1 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Application) == 2, "MediaDevices::DisplayCaptureSurfaceType::Application is not 2 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Browser) == 3, "MediaDevices::DisplayCaptureSurfaceType::Browser is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaDevices::DisplayCaptureSurfaceType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaDevices::DisplayCaptureSurfaceType> parseEnumerationFromString<MediaDevices::DisplayCaptureSurfaceType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaDevices::DisplayCaptureSurfaceType> mappings[] = {
        { "application", MediaDevices::DisplayCaptureSurfaceType::Application },
        { "browser", MediaDevices::DisplayCaptureSurfaceType::Browser },
        { "monitor", MediaDevices::DisplayCaptureSurfaceType::Monitor },
        { "window", MediaDevices::DisplayCaptureSurfaceType::Window },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaDevices::DisplayCaptureSurfaceType> parseEnumeration<MediaDevices::DisplayCaptureSurfaceType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaDevices::DisplayCaptureSurfaceType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaDevices::DisplayCaptureSurfaceType>()
{
    return "\"monitor\", \"window\", \"application\", \"browser\""_s;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<MediaDevices::DisplayMediaStreamConstraints>> convertDictionary<MediaDevices::DisplayMediaStreamConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaDevices::DisplayMediaStreamConstraints result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto audioConversionResult = convertOptionalWithDefault<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, audioValue, [&]() -> ConversionResult<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>> { return Converter<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>::ReturnType { false }; });
    if (UNLIKELY(audioConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.audio = audioConversionResult.releaseReturnValue();
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto videoConversionResult = convertOptionalWithDefault<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, videoValue, [&]() -> ConversionResult<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>> { return Converter<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>::ReturnType { true }; });
    if (UNLIKELY(videoConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.video = videoConversionResult.releaseReturnValue();
    return result;
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> ConversionResult<IDLDictionary<MediaDevices::StreamConstraints>> convertDictionary<MediaDevices::StreamConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaDevices::StreamConstraints result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto audioConversionResult = convertOptionalWithDefault<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, audioValue, [&]() -> ConversionResult<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>> { return Converter<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>::ReturnType { false }; });
    if (UNLIKELY(audioConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.audio = audioConversionResult.releaseReturnValue();
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto videoConversionResult = convertOptionalWithDefault<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, videoValue, [&]() -> ConversionResult<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>> { return Converter<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>::ReturnType { false }; });
    if (UNLIKELY(videoConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.video = videoConversionResult.releaseReturnValue();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_enumerateDevices);
static JSC_DECLARE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getSupportedConstraints);
static JSC_DECLARE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getUserMedia);
static JSC_DECLARE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getDisplayMedia);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaDevicesConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaDevices_ondevicechange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaDevices_ondevicechange);

class JSMediaDevicesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaDevicesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaDevicesPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaDevicesPrototype>(vm)) JSMediaDevicesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDevicesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaDevicesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDevicesPrototype, JSMediaDevicesPrototype::Base);

using JSMediaDevicesDOMConstructor = JSDOMConstructorNotConstructable<JSMediaDevices>;

template<> const ClassInfo JSMediaDevicesDOMConstructor::s_info = { "MediaDevices"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevicesDOMConstructor) };

template<> JSValue JSMediaDevicesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaDevicesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaDevices"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaDevices::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMediaDevicesPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDevicesConstructor, 0 } },
    { "ondevicechange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDevices_ondevicechange, setJSMediaDevices_ondevicechange } },
    { "enumerateDevices"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaDevicesPrototypeFunction_enumerateDevices, 0 } },
    { "getSupportedConstraints"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaDevicesPrototypeFunction_getSupportedConstraints, 0 } },
    { "getUserMedia"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaDevicesPrototypeFunction_getUserMedia, 0 } },
    { "getDisplayMedia"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaDevicesPrototypeFunction_getDisplayMedia, 0 } },
};

const ClassInfo JSMediaDevicesPrototype::s_info = { "MediaDevices"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevicesPrototype) };

void JSMediaDevicesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaDevices::info(), JSMediaDevicesPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().screenCaptureEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getDisplayMedia"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    putDirect(vm, builtinNames(vm).getUserMediaPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsMediaDevicesPrototypeFunction_getUserMedia, ImplementationVisibility::Public), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaDevices::s_info = { "MediaDevices"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevices) };

JSMediaDevices::JSMediaDevices(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaDevices>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaDevices> JSMediaDevices::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, MediaDevices>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaDevices::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaDevicesPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaDevicesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaDevices::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaDevices>(vm, globalObject);
}

JSValue JSMediaDevices::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaDevicesDOMConstructor, DOMConstructorID::MediaDevices>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDevicesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDevicesPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaDevices::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaDevices_ondevicechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDevices& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().devicechangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDevices_ondevicechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDevices>::get<jsMediaDevices_ondevicechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaDevices_ondevicechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMediaDevices& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().devicechangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaDevices_ondevicechange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDevices>::set<setJSMediaDevices_ondevicechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunction_enumerateDevicesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLUnion<IDLInterface<MediaDeviceInfo>, IDLInterface<InputDeviceInfo>>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.enumerateDevices(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_enumerateDevices, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunction_enumerateDevicesBody>(*lexicalGlobalObject, *callFrame, "enumerateDevices");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunction_getSupportedConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaDevices>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<MediaTrackSupportedConstraints>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSupportedConstraints())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getSupportedConstraints, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaDevices>::call<jsMediaDevicesPrototypeFunction_getSupportedConstraintsBody>(*lexicalGlobalObject, *callFrame, "getSupportedConstraints");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunction_getUserMediaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto constraintsConversionResult = convert<IDLDictionary<MediaDevices::StreamConstraints>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(constraintsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<MediaStream>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getUserMedia(constraintsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getUserMedia, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunction_getUserMediaBody>(*lexicalGlobalObject, *callFrame, "getUserMedia");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunction_getDisplayMediaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto constraintsConversionResult = convert<IDLDictionary<MediaDevices::DisplayMediaStreamConstraints>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(constraintsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<MediaStream>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getDisplayMedia(constraintsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaDevicesPrototypeFunction_getDisplayMedia, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunction_getDisplayMediaBody>(*lexicalGlobalObject, *callFrame, "getDisplayMedia");
}

JSC::GCClient::IsoSubspace* JSMediaDevices::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaDevices, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaDevices.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaDevices = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaDevices.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaDevices = std::forward<decltype(space)>(space); }
    );
}

void JSMediaDevices::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaDevices*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaDevicesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsMediaDevices = jsCast<JSMediaDevices*>(handle.slot()->asCell());
    auto& wrapped = jsMediaDevices->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaDevicesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaDevices = static_cast<JSMediaDevices*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaDevices->protectedWrapped().ptr(), jsMediaDevices);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaDevices@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12MediaDevicesE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, MediaDevices>, void>> static inline void verifyVTable(MediaDevices* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaDevices@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12MediaDevicesE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaDevices has subclasses. If MediaDevices has subclasses that get passed
        // to toJS() we currently require MediaDevices you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaDevices>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaDevices>(impl.ptr());
#endif
    return createWrapper<MediaDevices>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaDevices& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaDevices* JSMediaDevices::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaDevices*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
