/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGMaskElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGStringList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_maskUnits);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_maskContentUnits);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_height);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_requiredExtensions);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_systemLanguage);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGMaskElement_requiredFeatures);

class JSSVGMaskElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGMaskElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGMaskElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGMaskElementPrototype>(vm)) JSSVGMaskElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGMaskElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGMaskElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGMaskElementPrototype, JSSVGMaskElementPrototype::Base);

using JSSVGMaskElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGMaskElement>;

template<> const ClassInfo JSSVGMaskElementDOMConstructor::s_info = { "SVGMaskElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMaskElementDOMConstructor) };

template<> JSValue JSSVGMaskElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGMaskElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGMaskElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGMaskElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGMaskElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElementConstructor, 0 } },
    { "maskUnits"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_maskUnits, 0 } },
    { "maskContentUnits"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_maskContentUnits, 0 } },
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_y, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_height, 0 } },
    { "requiredExtensions"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_requiredExtensions, 0 } },
    { "systemLanguage"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_systemLanguage, 0 } },
    { "requiredFeatures"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGMaskElement_requiredFeatures, 0 } },
};

const ClassInfo JSSVGMaskElementPrototype::s_info = { "SVGMaskElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMaskElementPrototype) };

void JSSVGMaskElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGMaskElement::info(), JSSVGMaskElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGMaskElement::s_info = { "SVGMaskElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGMaskElement) };

JSSVGMaskElement::JSSVGMaskElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGMaskElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGMaskElement> JSSVGMaskElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGMaskElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGMaskElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGMaskElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGMaskElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGMaskElement>(vm, globalObject);
}

JSValue JSSVGMaskElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMaskElementDOMConstructor, DOMConstructorID::SVGMaskElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGMaskElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGMaskElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGMaskElement_maskUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.maskUnitsAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_maskUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_maskUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_maskContentUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedEnumeration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.maskContentUnitsAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_maskContentUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_maskContentUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_requiredExtensionsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.requiredExtensions())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_requiredExtensions, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_requiredExtensionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_systemLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.systemLanguage())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_systemLanguage, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_systemLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGMaskElement_requiredFeaturesGetter(JSGlobalObject& lexicalGlobalObject, JSSVGMaskElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.requiredFeatures())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGMaskElement_requiredFeatures, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGMaskElement>::get<jsSVGMaskElement_requiredFeaturesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGMaskElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGMaskElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGMaskElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGMaskElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGMaskElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGMaskElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGMaskElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGMaskElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
