/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSeg.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSeg_pathSegType);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSeg_pathSegTypeAsLetter);

class JSSVGPathSegPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegPrototype>(vm)) JSSVGPathSegPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegPrototype, JSSVGPathSegPrototype::Base);

using JSSVGPathSegDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathSeg>;

/* Hash table for constructor */

static const HashTableValue JSSVGPathSegConstructorTableValues[] =
{
    { "PATHSEG_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "PATHSEG_CLOSEPATH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "PATHSEG_MOVETO_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "PATHSEG_MOVETO_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "PATHSEG_LINETO_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "PATHSEG_LINETO_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "PATHSEG_CURVETO_CUBIC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "PATHSEG_CURVETO_CUBIC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "PATHSEG_CURVETO_QUADRATIC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "PATHSEG_ARC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "PATHSEG_ARC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "PATHSEG_LINETO_HORIZONTAL_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    { "PATHSEG_LINETO_VERTICAL_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    { "PATHSEG_LINETO_VERTICAL_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
};

static_assert(SVGPathSeg::PATHSEG_UNKNOWN == 0, "PATHSEG_UNKNOWN in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CLOSEPATH == 1, "PATHSEG_CLOSEPATH in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_MOVETO_ABS == 2, "PATHSEG_MOVETO_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_MOVETO_REL == 3, "PATHSEG_MOVETO_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_ABS == 4, "PATHSEG_LINETO_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_REL == 5, "PATHSEG_LINETO_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_ABS == 6, "PATHSEG_CURVETO_CUBIC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_REL == 7, "PATHSEG_CURVETO_CUBIC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_ABS == 8, "PATHSEG_CURVETO_QUADRATIC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_REL == 9, "PATHSEG_CURVETO_QUADRATIC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_ARC_ABS == 10, "PATHSEG_ARC_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_ARC_REL == 11, "PATHSEG_ARC_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_ABS == 12, "PATHSEG_LINETO_HORIZONTAL_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_REL == 13, "PATHSEG_LINETO_HORIZONTAL_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_VERTICAL_ABS == 14, "PATHSEG_LINETO_VERTICAL_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_LINETO_VERTICAL_REL == 15, "PATHSEG_LINETO_VERTICAL_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_ABS == 16, "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_REL == 17, "PATHSEG_CURVETO_CUBIC_SMOOTH_REL in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS == 18, "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS in SVGPathSeg does not match value from IDL");
static_assert(SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL == 19, "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL in SVGPathSeg does not match value from IDL");

template<> const ClassInfo JSSVGPathSegDOMConstructor::s_info = { "SVGPathSeg"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegDOMConstructor) };

template<> JSValue JSSVGPathSegDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPathSegDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathSeg"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSeg::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGPathSeg::info(), JSSVGPathSegConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegConstructor, 0 } },
    { "pathSegType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSeg_pathSegType, 0 } },
    { "pathSegTypeAsLetter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSeg_pathSegTypeAsLetter, 0 } },
    { "PATHSEG_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    { "PATHSEG_CLOSEPATH"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "PATHSEG_MOVETO_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "PATHSEG_MOVETO_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "PATHSEG_LINETO_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "PATHSEG_LINETO_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "PATHSEG_CURVETO_CUBIC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "PATHSEG_CURVETO_CUBIC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "PATHSEG_CURVETO_QUADRATIC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "PATHSEG_ARC_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "PATHSEG_ARC_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "PATHSEG_LINETO_HORIZONTAL_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 13 } },
    { "PATHSEG_LINETO_VERTICAL_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 14 } },
    { "PATHSEG_LINETO_VERTICAL_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 15 } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 16 } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 17 } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 18 } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 19 } },
};

const ClassInfo JSSVGPathSegPrototype::s_info = { "SVGPathSeg"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegPrototype) };

void JSSVGPathSegPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSeg::info(), JSSVGPathSegPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathSeg::s_info = { "SVGPathSeg"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSeg) };

JSSVGPathSeg::JSSVGPathSeg(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSeg>&& impl)
    : JSDOMWrapper<SVGPathSeg>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSeg>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPathSeg::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathSegPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGPathSegPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathSeg::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSeg>(vm, globalObject);
}

JSValue JSSVGPathSeg::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegDOMConstructor, DOMConstructorID::SVGPathSeg>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGPathSeg::destroy(JSC::JSCell* cell)
{
    JSSVGPathSeg* thisObject = static_cast<JSSVGPathSeg*>(cell);
    thisObject->JSSVGPathSeg::~JSSVGPathSeg();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSeg::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPathSeg_pathSegTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSeg& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.pathSegTypeForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSeg_pathSegType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSeg>::get<jsSVGPathSeg_pathSegTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGPathSeg_pathSegTypeAsLetterGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSeg& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pathSegTypeAsLetter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSeg_pathSegTypeAsLetter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSeg>::get<jsSVGPathSeg_pathSegTypeAsLetterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPathSeg::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathSeg, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathSeg.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathSeg = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathSeg.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathSeg = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathSeg::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSeg*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGPathSegOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGPathSegOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPathSeg = static_cast<JSSVGPathSeg*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPathSeg->protectedWrapped().ptr(), jsSVGPathSeg);
}

SVGPathSeg* JSSVGPathSeg::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPathSeg*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
