/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityStateFlags.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ValidityStateFlags>> convertDictionary<ValidityStateFlags>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ValidityStateFlags result;
    JSValue badInputValue;
    if (isNullOrUndefined)
        badInputValue = jsUndefined();
    else {
        badInputValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "badInput"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto badInputConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, badInputValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(badInputConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.badInput = badInputConversionResult.releaseReturnValue();
    JSValue customErrorValue;
    if (isNullOrUndefined)
        customErrorValue = jsUndefined();
    else {
        customErrorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "customError"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto customErrorConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, customErrorValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(customErrorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.customError = customErrorConversionResult.releaseReturnValue();
    JSValue patternMismatchValue;
    if (isNullOrUndefined)
        patternMismatchValue = jsUndefined();
    else {
        patternMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "patternMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto patternMismatchConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, patternMismatchValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(patternMismatchConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.patternMismatch = patternMismatchConversionResult.releaseReturnValue();
    JSValue rangeOverflowValue;
    if (isNullOrUndefined)
        rangeOverflowValue = jsUndefined();
    else {
        rangeOverflowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rangeOverflow"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto rangeOverflowConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, rangeOverflowValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(rangeOverflowConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.rangeOverflow = rangeOverflowConversionResult.releaseReturnValue();
    JSValue rangeUnderflowValue;
    if (isNullOrUndefined)
        rangeUnderflowValue = jsUndefined();
    else {
        rangeUnderflowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rangeUnderflow"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto rangeUnderflowConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, rangeUnderflowValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(rangeUnderflowConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.rangeUnderflow = rangeUnderflowConversionResult.releaseReturnValue();
    JSValue stepMismatchValue;
    if (isNullOrUndefined)
        stepMismatchValue = jsUndefined();
    else {
        stepMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stepMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stepMismatchConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, stepMismatchValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(stepMismatchConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.stepMismatch = stepMismatchConversionResult.releaseReturnValue();
    JSValue tooLongValue;
    if (isNullOrUndefined)
        tooLongValue = jsUndefined();
    else {
        tooLongValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tooLong"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tooLongConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, tooLongValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(tooLongConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tooLong = tooLongConversionResult.releaseReturnValue();
    JSValue tooShortValue;
    if (isNullOrUndefined)
        tooShortValue = jsUndefined();
    else {
        tooShortValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tooShort"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto tooShortConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, tooShortValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(tooShortConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.tooShort = tooShortConversionResult.releaseReturnValue();
    JSValue typeMismatchValue;
    if (isNullOrUndefined)
        typeMismatchValue = jsUndefined();
    else {
        typeMismatchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "typeMismatch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeMismatchConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, typeMismatchValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(typeMismatchConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.typeMismatch = typeMismatchConversionResult.releaseReturnValue();
    JSValue valueMissingValue;
    if (isNullOrUndefined)
        valueMissingValue = jsUndefined();
    else {
        valueMissingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "valueMissing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto valueMissingConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, valueMissingValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(valueMissingConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.valueMissing = valueMissingConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
