/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLFramebuffer.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLFramebufferConstructor);

class JSWebGLFramebufferPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLFramebufferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLFramebufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLFramebufferPrototype>(vm)) JSWebGLFramebufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLFramebufferPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLFramebufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLFramebufferPrototype, JSWebGLFramebufferPrototype::Base);

using JSWebGLFramebufferDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLFramebuffer>;

template<> const ClassInfo JSWebGLFramebufferDOMConstructor::s_info = { "WebGLFramebuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebufferDOMConstructor) };

template<> JSValue JSWebGLFramebufferDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLFramebufferDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLFramebuffer"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLFramebuffer::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLFramebufferPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLFramebufferConstructor, 0 } },
};

const ClassInfo JSWebGLFramebufferPrototype::s_info = { "WebGLFramebuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebufferPrototype) };

void JSWebGLFramebufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLFramebuffer::info(), JSWebGLFramebufferPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLFramebuffer::s_info = { "WebGLFramebuffer"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLFramebuffer) };

JSWebGLFramebuffer::JSWebGLFramebuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLFramebuffer>&& impl)
    : JSDOMWrapper<WebGLFramebuffer>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLFramebuffer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLFramebuffer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLFramebufferPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLFramebufferPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLFramebuffer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLFramebuffer>(vm, globalObject);
}

JSValue JSWebGLFramebuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLFramebufferDOMConstructor, DOMConstructorID::WebGLFramebuffer>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLFramebuffer::destroy(JSC::JSCell* cell)
{
    JSWebGLFramebuffer* thisObject = static_cast<JSWebGLFramebuffer*>(cell);
    thisObject->JSWebGLFramebuffer::~JSWebGLFramebuffer();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLFramebufferConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLFramebufferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLFramebuffer::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebGLFramebuffer::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLFramebuffer, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLFramebuffer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLFramebuffer = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLFramebuffer.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLFramebuffer = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLFramebuffer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLFramebuffer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLFramebufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLFramebuffer = jsCast<JSWebGLFramebuffer*>(handle.slot()->asCell());
    WebGLFramebuffer* owner = &jsWebGLFramebuffer->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLFramebuffer"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLFramebufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLFramebuffer = static_cast<JSWebGLFramebuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLFramebuffer->protectedWrapped().ptr(), jsWebGLFramebuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLFramebuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLFramebufferE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLFramebuffer>, void>> static inline void verifyVTable(WebGLFramebuffer* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLFramebuffer@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16WebGLFramebufferE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLFramebuffer has subclasses. If WebGLFramebuffer has subclasses that get passed
        // to toJS() we currently require WebGLFramebuffer you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLFramebuffer>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLFramebuffer>(impl.ptr());
#endif
    return createWrapper<WebGLFramebuffer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLFramebuffer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLFramebuffer* JSWebGLFramebuffer::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLFramebuffer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
