/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLShaderPrecisionFormat.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormatConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_rangeMin);
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_rangeMax);
static JSC_DECLARE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_precision);

class JSWebGLShaderPrecisionFormatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLShaderPrecisionFormatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLShaderPrecisionFormatPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLShaderPrecisionFormatPrototype>(vm)) JSWebGLShaderPrecisionFormatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLShaderPrecisionFormatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLShaderPrecisionFormatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLShaderPrecisionFormatPrototype, JSWebGLShaderPrecisionFormatPrototype::Base);

using JSWebGLShaderPrecisionFormatDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLShaderPrecisionFormat>;

template<> const ClassInfo JSWebGLShaderPrecisionFormatDOMConstructor::s_info = { "WebGLShaderPrecisionFormat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatDOMConstructor) };

template<> JSValue JSWebGLShaderPrecisionFormatDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLShaderPrecisionFormatDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLShaderPrecisionFormat"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLShaderPrecisionFormat::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLShaderPrecisionFormatPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLShaderPrecisionFormatConstructor, 0 } },
    { "rangeMin"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLShaderPrecisionFormat_rangeMin, 0 } },
    { "rangeMax"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLShaderPrecisionFormat_rangeMax, 0 } },
    { "precision"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLShaderPrecisionFormat_precision, 0 } },
};

const ClassInfo JSWebGLShaderPrecisionFormatPrototype::s_info = { "WebGLShaderPrecisionFormat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormatPrototype) };

void JSWebGLShaderPrecisionFormatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLShaderPrecisionFormat::info(), JSWebGLShaderPrecisionFormatPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLShaderPrecisionFormat::s_info = { "WebGLShaderPrecisionFormat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLShaderPrecisionFormat) };

JSWebGLShaderPrecisionFormat::JSWebGLShaderPrecisionFormat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLShaderPrecisionFormat>&& impl)
    : JSDOMWrapper<WebGLShaderPrecisionFormat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLShaderPrecisionFormat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLShaderPrecisionFormat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLShaderPrecisionFormatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLShaderPrecisionFormatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLShaderPrecisionFormat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLShaderPrecisionFormat>(vm, globalObject);
}

JSValue JSWebGLShaderPrecisionFormat::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLShaderPrecisionFormatDOMConstructor, DOMConstructorID::WebGLShaderPrecisionFormat>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLShaderPrecisionFormat::destroy(JSC::JSCell* cell)
{
    JSWebGLShaderPrecisionFormat* thisObject = static_cast<JSWebGLShaderPrecisionFormat*>(cell);
    thisObject->JSWebGLShaderPrecisionFormat::~JSWebGLShaderPrecisionFormat();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormatConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLShaderPrecisionFormatPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLShaderPrecisionFormat::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebGLShaderPrecisionFormat_rangeMinGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rangeMin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_rangeMin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormat_rangeMinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebGLShaderPrecisionFormat_rangeMaxGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rangeMax())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_rangeMax, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormat_rangeMaxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebGLShaderPrecisionFormat_precisionGetter(JSGlobalObject& lexicalGlobalObject, JSWebGLShaderPrecisionFormat& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.precision())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLShaderPrecisionFormat_precision, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebGLShaderPrecisionFormat>::get<jsWebGLShaderPrecisionFormat_precisionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSWebGLShaderPrecisionFormat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLShaderPrecisionFormat, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLShaderPrecisionFormat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLShaderPrecisionFormat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLShaderPrecisionFormat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLShaderPrecisionFormat = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLShaderPrecisionFormat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLShaderPrecisionFormat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLShaderPrecisionFormatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLShaderPrecisionFormatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLShaderPrecisionFormat = static_cast<JSWebGLShaderPrecisionFormat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLShaderPrecisionFormat->protectedWrapped().ptr(), jsWebGLShaderPrecisionFormat);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLShaderPrecisionFormat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebGLShaderPrecisionFormatE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLShaderPrecisionFormat>, void>> static inline void verifyVTable(WebGLShaderPrecisionFormat* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLShaderPrecisionFormat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26WebGLShaderPrecisionFormatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLShaderPrecisionFormat has subclasses. If WebGLShaderPrecisionFormat has subclasses that get passed
        // to toJS() we currently require WebGLShaderPrecisionFormat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLShaderPrecisionFormat>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLShaderPrecisionFormat>(impl.ptr());
#endif
    return createWrapper<WebGLShaderPrecisionFormat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLShaderPrecisionFormat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLShaderPrecisionFormat* JSWebGLShaderPrecisionFormat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLShaderPrecisionFormat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
