/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestProgressEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestProgressEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestProgressEvent_position);
static JSC_DECLARE_CUSTOM_GETTER(jsXMLHttpRequestProgressEvent_totalSize);

class JSXMLHttpRequestProgressEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXMLHttpRequestProgressEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestProgressEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestProgressEventPrototype>(vm)) JSXMLHttpRequestProgressEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestProgressEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestProgressEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXMLHttpRequestProgressEventPrototype, JSXMLHttpRequestProgressEventPrototype::Base);

using JSXMLHttpRequestProgressEventDOMConstructor = JSDOMConstructorNotConstructable<JSXMLHttpRequestProgressEvent>;

template<> const ClassInfo JSXMLHttpRequestProgressEventDOMConstructor::s_info = { "XMLHttpRequestProgressEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEventDOMConstructor) };

template<> JSValue JSXMLHttpRequestProgressEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSProgressEvent::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestProgressEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XMLHttpRequestProgressEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestProgressEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestProgressEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestProgressEventConstructor, 0 } },
    { "position"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestProgressEvent_position, 0 } },
    { "totalSize"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsXMLHttpRequestProgressEvent_totalSize, 0 } },
};

const ClassInfo JSXMLHttpRequestProgressEventPrototype::s_info = { "XMLHttpRequestProgressEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEventPrototype) };

void JSXMLHttpRequestProgressEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestProgressEvent::info(), JSXMLHttpRequestProgressEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXMLHttpRequestProgressEvent::s_info = { "XMLHttpRequestProgressEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXMLHttpRequestProgressEvent) };

JSXMLHttpRequestProgressEvent::JSXMLHttpRequestProgressEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestProgressEvent>&& impl)
    : JSProgressEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<XMLHttpRequestProgressEvent> JSXMLHttpRequestProgressEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, XMLHttpRequestProgressEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXMLHttpRequestProgressEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXMLHttpRequestProgressEventPrototype::createStructure(vm, &globalObject, JSProgressEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSXMLHttpRequestProgressEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXMLHttpRequestProgressEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestProgressEvent>(vm, globalObject);
}

JSValue JSXMLHttpRequestProgressEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestProgressEventDOMConstructor, DOMConstructorID::XMLHttpRequestProgressEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestProgressEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXMLHttpRequestProgressEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXMLHttpRequestProgressEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsXMLHttpRequestProgressEvent_positionGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestProgressEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.position())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestProgressEvent_position, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestProgressEvent>::get<jsXMLHttpRequestProgressEvent_positionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsXMLHttpRequestProgressEvent_totalSizeGetter(JSGlobalObject& lexicalGlobalObject, JSXMLHttpRequestProgressEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.totalSize())));
}

JSC_DEFINE_CUSTOM_GETTER(jsXMLHttpRequestProgressEvent_totalSize, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSXMLHttpRequestProgressEvent>::get<jsXMLHttpRequestProgressEvent_totalSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSXMLHttpRequestProgressEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXMLHttpRequestProgressEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXMLHttpRequestProgressEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXMLHttpRequestProgressEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXMLHttpRequestProgressEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXMLHttpRequestProgressEvent = std::forward<decltype(space)>(space); }
    );
}

void JSXMLHttpRequestProgressEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXMLHttpRequestProgressEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
