/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Debug;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.PacketTooBigException;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.RowDataDynamic;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Security;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.UpdatableResultSet;
import com.mysql.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MysqlIO {
    static final int NULL_LENGTH = -1;
    static final int COMP_HEADER_LENGTH = 3;
    static final int MIN_COMPRESS_LEN = 50;
    static final int HEADER_LENGTH = 4;
    private static int maxBufferSize;
    private static final int CLIENT_COMPRESS = 32;
    private static final int CLIENT_CONNECT_WITH_DB = 8;
    private static final int CLIENT_FOUND_ROWS = 2;
    private static final int CLIENT_IGNORE_SPACE = 256;
    private static final int CLIENT_LOCAL_FILES = 128;
    private static final int CLIENT_LONG_FLAG = 4;
    private static final int CLIENT_LONG_PASSWORD = 1;
    private static final int CLIENT_PROTOCOL_41 = 512;
    private static final int CLIENT_INTERACTIVE = 1024;
    private static final int CLIENT_SSL = 2048;
    private static final int CLIENT_RESERVED = 16384;
    private static final int CLIENT_SECURE_CONNECTION = 32768;
    private static final String FALSE_SCRAMBLE = "xxxxxxxx";
    private Buffer reusablePacket = null;
    private Buffer sendPacket = null;
    private Buffer sharedSendPacket = null;
    private BufferedOutputStream mysqlOutput = null;
    private Connection connection;
    private Deflater deflater = null;
    private Inflater inflater = null;
    private InputStream mysqlInput = null;
    private RowData streamingData = null;
    private SQLWarning warningChain = null;
    private Socket mysqlConnection = null;
    private SocketFactory socketFactory = null;
    private SoftReference loadFileBufRef;
    private SoftReference splitBufRef;
    private String host = null;
    private String seed;
    private String serverVersion = null;
    private String socketFactoryClassName = null;
    private boolean colDecimalNeedsBump = false;
    private boolean has41NewNewProt = false;
    private boolean hasLongColumnInfo = false;
    private boolean isInteractiveClient = false;
    private boolean platformDbCharsetMatches = true;
    private boolean profileSql = false;
    private boolean use41Extensions = false;
    private boolean useCompression = false;
    private boolean useNewLargePackets = false;
    private boolean useNewUpdateCounts = false;
    private byte packetSequence = 0;
    private byte protocolVersion = 0;
    private int clientParam = 0;
    private int maxAllowedPacket = 0x100000;
    private int maxThreeBytes = 16581375;
    private int port = 3306;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int serverSubMinorVersion = 0;

    protected MysqlIO(String host, int port, String socketFactoryClassName, Properties props, Connection conn, int socketTimeout) throws IOException, SQLException {
        this.connection = conn;
        this.reusablePacket = new Buffer(this.connection.getNetBufferLength());
        this.port = port;
        this.host = host;
        this.socketFactoryClassName = socketFactoryClassName;
        this.socketFactory = this.createSocketFactory();
        this.mysqlConnection = this.socketFactory.connect(this.host, props);
        if (socketTimeout != 0) {
            try {
                this.mysqlConnection.setSoTimeout(socketTimeout);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.mysqlConnection = this.socketFactory.beforeHandshake();
        this.mysqlInput = new BufferedInputStream(this.mysqlConnection.getInputStream(), 16384);
        this.mysqlOutput = new BufferedOutputStream(this.mysqlConnection.getOutputStream(), 16384);
        this.isInteractiveClient = this.connection.isInteractiveClient();
    }

    protected void setProfileSql(boolean flag) {
        this.profileSql = flag;
    }

    protected ResultSet getResultSet(long columnCount, int maxRows, int resultSetType, boolean streamResults, String catalog) throws Exception {
        Buffer packet;
        Field[] fields = new Field[(int)columnCount];
        int i = 0;
        while ((long)i < columnCount) {
            packet = this.readPacket();
            fields[i] = this.unpackField(packet, false);
            ++i;
        }
        packet = this.reuseAndReadPacket(this.reusablePacket);
        RowData rowData = null;
        if (!streamResults) {
            ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
            byte[][] rowBytes = this.nextRow((int)columnCount);
            int rowCount = 0;
            if (rowBytes != null) {
                rows.add(rowBytes);
                rowCount = 1;
            }
            while (rowBytes != null && rowCount < maxRows) {
                rowBytes = this.nextRow((int)columnCount);
                if (rowBytes == null) continue;
                rows.add(rowBytes);
                ++rowCount;
            }
            rowData = new RowDataStatic(rows);
            this.reclaimLargeReusablePacket();
        } else {
            rowData = new RowDataDynamic(this, (int)columnCount);
            this.streamingData = rowData;
        }
        return this.buildResultSetWithRows(catalog, fields, rowData, resultSetType);
    }

    protected final void forceClose() {
        try {
            if (this.mysqlInput != null) {
                this.mysqlInput.close();
            }
        }
        catch (IOException ioEx) {
            this.mysqlInput = null;
        }
        try {
            if (this.mysqlOutput != null) {
                this.mysqlOutput.close();
            }
        }
        catch (IOException ioEx) {
            this.mysqlOutput = null;
        }
        try {
            if (this.mysqlConnection != null) {
                this.mysqlConnection.close();
            }
        }
        catch (IOException ioEx) {
            this.mysqlConnection = null;
        }
    }

    protected boolean hasLongColumnInfo() {
        return this.hasLongColumnInfo;
    }

    protected final Field unpackField(Buffer packet, boolean extractDefaultValues) {
        if (this.use41Extensions) {
            if (this.has41NewNewProt) {
                int catalogNameStart = packet.getPosition() + 1;
                int catalogNameLength = packet.fastSkipLenString();
            }
            int databaseNameStart = packet.getPosition() + 1;
            int databaseNameLength = packet.fastSkipLenString();
            int tableNameStart = packet.getPosition() + 1;
            int tableNameLength = packet.fastSkipLenString();
            int originalTableNameStart = packet.getPosition() + 1;
            int originalTableNameLength = packet.fastSkipLenString();
            int nameStart = packet.getPosition() + 1;
            int nameLength = packet.fastSkipLenString();
            int originalColumnNameStart = packet.getPosition() + 1;
            int originalColumnNameLength = packet.fastSkipLenString();
            packet.readByte();
            int charSetNumber = packet.readInt();
            int colLength = 0;
            colLength = this.has41NewNewProt ? (int)packet.readLong() : packet.readLongInt();
            int colType = packet.readByte() & 0xFF;
            short colFlag = 0;
            colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
            int colDecimals = packet.readByte() & 0xFF;
            int defaultValueStart = -1;
            int defaultValueLength = -1;
            if (extractDefaultValues) {
                defaultValueStart = packet.getPosition() + 1;
                defaultValueLength = packet.fastSkipLenString();
            }
            Field field = new Field(this.connection, packet.getByteBuffer(), databaseNameStart, databaseNameLength, tableNameStart, tableNameLength, originalTableNameStart, originalTableNameLength, nameStart, nameLength, originalColumnNameStart, originalColumnNameLength, colLength, colType, colFlag, colDecimals, defaultValueStart, defaultValueLength, charSetNumber);
            return field;
        }
        int tableNameStart = packet.getPosition() + 1;
        int tableNameLength = packet.fastSkipLenString();
        int nameStart = packet.getPosition() + 1;
        int nameLength = packet.fastSkipLenString();
        int colLength = packet.readnBytes();
        int colType = packet.readnBytes();
        packet.readByte();
        short colFlag = 0;
        colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
        int colDecimals = packet.readByte() & 0xFF;
        if (this.colDecimalNeedsBump) {
            ++colDecimals;
        }
        Field field = new Field(this.connection, packet.getBufferSource(), nameStart, nameLength, tableNameStart, tableNameLength, colLength, colType, colFlag, colDecimals);
        return field;
    }

    protected void checkForCharsetMismatch() {
        if (this.connection.useUnicode() && this.connection.getEncoding() != null) {
            this.platformDbCharsetMatches = System.getProperty("file.encoding").equals(this.connection.getEncoding());
        }
    }

    static int getMaxBuf() {
        return maxBufferSize;
    }

    final int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    final int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    final int getServerSubMinorVersion() {
        return this.serverSubMinorVersion;
    }

    String getServerVersion() {
        return this.serverVersion;
    }

    void doHandshake(String user, String password, String database) throws SQLException {
        Buffer buf = this.readPacket();
        this.protocolVersion = buf.readByte();
        if (this.protocolVersion == -1) {
            try {
                this.mysqlConnection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SQLException("Server configuration denies access to data source", "08001", 0);
        }
        this.serverVersion = buf.readString();
        int point = this.serverVersion.indexOf(".");
        if (point != -1) {
            try {
                int n;
                this.serverMajorVersion = n = Integer.parseInt(this.serverVersion.substring(0, point));
            }
            catch (NumberFormatException NFE1) {
                // empty catch block
            }
            String remaining = this.serverVersion.substring(point + 1, this.serverVersion.length());
            point = remaining.indexOf(".");
            if (point != -1) {
                try {
                    int n;
                    this.serverMinorVersion = n = Integer.parseInt(remaining.substring(0, point));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                remaining = remaining.substring(point + 1, remaining.length());
                int pos = 0;
                while (pos < remaining.length()) {
                    if (remaining.charAt(pos) < '0' || remaining.charAt(pos) > '9') break;
                    ++pos;
                }
                try {
                    int n;
                    this.serverSubMinorVersion = n = Integer.parseInt(remaining.substring(0, pos));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (this.versionMeetsMinimum(4, 0, 8)) {
            this.maxThreeBytes = 0xFFFFFF;
            this.useNewLargePackets = true;
        } else {
            this.maxThreeBytes = 16581375;
            this.useNewLargePackets = false;
        }
        this.colDecimalNeedsBump = this.versionMeetsMinimum(3, 23, 0);
        this.colDecimalNeedsBump = !this.versionMeetsMinimum(3, 23, 15);
        this.useNewUpdateCounts = this.versionMeetsMinimum(3, 22, 5);
        long threadId = buf.readLong();
        this.seed = buf.readString();
        int serverCapabilities = 0;
        if (buf.getPosition() < buf.getBufLength()) {
            serverCapabilities = buf.readInt();
        }
        if (this.versionMeetsMinimum(4, 1, 1)) {
            int position = buf.getPosition();
            int serverLanguage = buf.readInt();
            buf.readInt();
            buf.setPosition(position + 16);
            String seedPart2 = buf.readString();
            StringBuffer newSeed = new StringBuffer(20);
            newSeed.append(this.seed);
            newSeed.append(seedPart2);
            this.seed = newSeed.toString();
        }
        if ((serverCapabilities & 0x20) != 0 && this.connection.useCompression()) {
            this.deflater = new Deflater();
            this.inflater = new Inflater();
            this.clientParam |= 0x20;
            this.useCompression = true;
        }
        if (database != null && database.length() > 0) {
            this.clientParam |= 8;
        }
        if ((serverCapabilities & 0x800) == 0 && this.connection.useSSL()) {
            this.connection.setUseSSL(false);
        }
        if ((serverCapabilities & 4) != 0) {
            this.clientParam |= 4;
            this.hasLongColumnInfo = true;
        }
        this.clientParam |= 2;
        if (this.connection.allowLoadLocalInfile()) {
            this.clientParam |= 0x80;
        }
        if (this.isInteractiveClient) {
            this.clientParam |= 0x400;
        }
        this.clientParam = this.protocolVersion > 9 ? (this.clientParam |= 1) : (this.clientParam &= 0xFFFFFFFE);
        if (this.versionMeetsMinimum(4, 1, 0)) {
            if (this.versionMeetsMinimum(4, 1, 1)) {
                this.clientParam |= 0x200;
                this.has41NewNewProt = true;
            } else {
                this.clientParam |= 0x4000;
                this.has41NewNewProt = false;
            }
            this.use41Extensions = true;
        }
        int passwordLength = 16;
        int userLength = 0;
        int databaseLength = 0;
        if (user != null) {
            userLength = user.length();
        }
        if (database != null) {
            databaseLength = database.length();
        }
        int packLength = userLength + passwordLength + databaseLength + 7 + 4;
        Buffer packet = null;
        if (!this.connection.useSSL()) {
            if ((serverCapabilities & 0x8000) != 0) {
                this.clientParam |= 0x8000;
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    this.secureAuth411(packLength, serverCapabilities, this.clientParam, user, password, database);
                } else {
                    this.secureAuth(packLength, serverCapabilities, this.clientParam, user, password, database);
                }
            } else {
                packet = new Buffer(packLength);
                if ((this.clientParam & 0x4000) != 0) {
                    if (this.versionMeetsMinimum(4, 1, 1)) {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                        packet.writeByte((byte)8);
                        packet.writeBytesNoNull(new byte[23]);
                    } else {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                    }
                } else {
                    packet.writeInt(this.clientParam);
                    packet.writeLongInt(this.maxThreeBytes);
                }
                packet.writeString(user);
                if (this.protocolVersion > 9) {
                    packet.writeString(Util.newCrypt(password, this.seed));
                } else {
                    packet.writeString(Util.oldCrypt(password, this.seed));
                }
                if ((serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
                    packet.writeString(database);
                }
                this.send(packet);
            }
        } else {
            boolean doSecureAuth = false;
            if ((serverCapabilities & 0x8000) != 0) {
                this.clientParam |= 0x8000;
                doSecureAuth = true;
            }
            this.clientParam |= 0x800;
            packet = new Buffer(packLength);
            if ((this.clientParam & 0x4000) != 0) {
                packet.writeLong(this.clientParam);
            } else {
                packet.writeInt(this.clientParam);
            }
            this.send(packet);
            SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            try {
                this.mysqlConnection = sslFact.createSocket(this.mysqlConnection, this.host, this.port, true);
                ((SSLSocket)this.mysqlConnection).setEnabledProtocols(new String[]{"TLSv1"});
                ((SSLSocket)this.mysqlConnection).startHandshake();
                this.mysqlInput = new BufferedInputStream(this.mysqlConnection.getInputStream(), 16384);
                this.mysqlOutput = new BufferedOutputStream(this.mysqlConnection.getOutputStream(), 16384);
                this.mysqlOutput.flush();
            }
            catch (IOException ioEx) {
                StringBuffer message = new StringBuffer(SQLError.get("08S01"));
                message.append(": ");
                message.append(ioEx.getClass().getName());
                message.append(", underlying cause: ");
                message.append(ioEx.getMessage());
                if (!this.connection.useParanoidErrorMessages()) {
                    message.append(Util.stackTraceToString(ioEx));
                }
                throw new SQLException(message.toString(), "08S01", 0);
            }
            packet.clear();
            if (doSecureAuth) {
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    this.secureAuth411(packLength, serverCapabilities, this.clientParam, user, password, database);
                } else {
                    this.secureAuth(packLength, serverCapabilities, this.clientParam, user, password, database);
                }
            } else {
                if ((this.clientParam & 0x4000) != 0) {
                    packet.writeLong(this.clientParam);
                    packet.writeLong(this.maxThreeBytes);
                } else {
                    packet.writeInt(this.clientParam);
                    packet.writeLongInt(this.maxThreeBytes);
                }
                packet.writeString(user);
                if (this.protocolVersion > 9) {
                    packet.writeString(Util.newCrypt(password, this.seed));
                } else {
                    packet.writeString(Util.oldCrypt(password, this.seed));
                }
                if ((serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
                    packet.writeString(database);
                }
                this.send(packet);
            }
        }
        if (!this.versionMeetsMinimum(4, 1, 1)) {
            this.checkErrorPacket();
        }
    }

    final byte[][] nextRow(int columnCount) throws Exception {
        Buffer rowPacket = this.checkErrorPacket();
        int offset = 0;
        if (rowPacket.wasMultiPacket()) {
            offset = this.useNewLargePackets ? 4 : 5;
        }
        rowPacket.setPosition(rowPacket.getPosition() - 1);
        byte[][] rowData = new byte[columnCount][];
        if (!rowPacket.isLastDataPacket()) {
            int i = 0;
            while (i < columnCount) {
                rowData[i] = rowPacket.readLenByteArray(offset);
                ++i;
            }
            return rowData;
        }
        return null;
    }

    final void quit() throws SQLException {
        Buffer packet = new Buffer(6);
        this.packetSequence = (byte)-1;
        packet.writeByte((byte)1);
        this.send(packet);
        this.forceClose();
    }

    Buffer getSharedSendPacket() {
        if (this.sharedSendPacket == null) {
            this.sharedSendPacket = new Buffer(this.connection.getNetBufferLength());
        }
        return this.sharedSendPacket;
    }

    void closeStreamer(RowData streamer) throws SQLException {
        if (this.streamingData == null) {
            throw new SQLException("Attempt to close streaming result set " + streamer + " when no streaming  result set was registered. This is an internal error.");
        }
        if (streamer != this.streamingData) {
            throw new SQLException("Attempt to close streaming result set " + streamer + " that was not registered." + " Only one streaming result set may be open and in use per-connection. Ensure that you have called .close() on " + " any active result sets before attempting more queries.");
        }
        this.streamingData = null;
    }

    void resetMaxBuf() {
        this.maxAllowedPacket = this.connection.getMaxAllowedPacket();
    }

    final Buffer sendCommand(int command, String extraData, Buffer queryPacket) throws Exception {
        this.checkForOutstandingStreamingData();
        try {
            if (queryPacket == null) {
                int packLength = 8 + (extraData != null ? extraData.length() : 0) + 2;
                if (this.sendPacket == null) {
                    this.sendPacket = new Buffer(packLength);
                }
                this.packetSequence = (byte)-1;
                this.sendPacket.clear();
                if (this.useCompression) {
                    this.sendPacket.setPosition(this.sendPacket.getPosition() + 3);
                }
                this.sendPacket.writeByte((byte)command);
                if (command == 2 || command == 5 || command == 6 || command == 3) {
                    this.sendPacket.writeStringNoNull(extraData);
                } else if (command == 12) {
                    long id = new Long(extraData);
                    this.sendPacket.writeLong(id);
                } else if (command == 7 && this.protocolVersion > 9) {
                    Debug.msg(this, "Reload");
                }
                this.send(this.sendPacket);
            } else {
                this.packetSequence = (byte)-1;
                this.send(queryPacket);
            }
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            String underlyingMessage = ex.getMessage();
            throw new SQLException(SQLError.get("08S01") + ": " + ex.getClass().getName() + ", " + (underlyingMessage != null ? underlyingMessage : "no message given by JVM"), "08S01", 0);
        }
        return this.checkErrorPacket(command);
    }

    final ResultSet sqlQuery(String query, int maxRows, String characterEncoding, Connection conn, int resultSetType, boolean streamResults, String catalog) throws Exception {
        int packLength = 5 + query.length() * 2 + 2;
        if (this.sendPacket == null) {
            this.sendPacket = new Buffer(packLength);
        } else {
            this.sendPacket.clear();
        }
        this.sendPacket.writeByte((byte)3);
        if (characterEncoding != null) {
            if (this.platformDbCharsetMatches) {
                this.sendPacket.writeStringNoNull(query, characterEncoding);
            } else if (StringUtils.startsWithIgnoreCaseAndWs(query, "LOAD DATA")) {
                this.sendPacket.writeBytesNoNull(query.getBytes());
            } else {
                this.sendPacket.writeStringNoNull(query, characterEncoding);
            }
        } else {
            this.sendPacket.writeStringNoNull(query);
        }
        return this.sqlQueryDirect(this.sendPacket, maxRows, conn, resultSetType, streamResults, catalog);
    }

    final ResultSet sqlQueryDirect(Buffer queryPacket, int maxRows, Connection conn, int resultSetType, boolean streamResults, String catalog) throws Exception {
        StringBuffer profileMsgBuf = null;
        long queryStartTime = 0L;
        if (this.profileSql) {
            profileMsgBuf = new StringBuffer();
            queryStartTime = System.currentTimeMillis();
            byte[] queryBuf = queryPacket.getByteBuffer();
            String query = new String(queryBuf, 5, queryPacket.getPosition() - 5);
            profileMsgBuf.append("Query\t\"");
            profileMsgBuf.append(query);
            profileMsgBuf.append("\"\texecution time:\t");
        }
        Buffer resultPacket = this.sendCommand(3, null, queryPacket);
        if (this.profileSql) {
            long executionTime = System.currentTimeMillis() - queryStartTime;
            profileMsgBuf.append(executionTime);
            profileMsgBuf.append("\t");
        }
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        long columnCount = resultPacket.readFieldLength();
        if (columnCount == 0L) {
            if (this.profileSql) {
                System.err.println(profileMsgBuf.toString());
            }
            return this.buildResultSetWithUpdates(resultPacket);
        }
        if (columnCount == -1L) {
            String charEncoding = null;
            if (this.connection.useUnicode()) {
                charEncoding = this.connection.getEncoding();
            }
            String fileName = null;
            fileName = this.platformDbCharsetMatches ? (charEncoding != null ? resultPacket.readString(charEncoding) : resultPacket.readString()) : resultPacket.readString();
            return this.sendFileToServer(fileName);
        }
        long fetchStartTime = 0L;
        if (this.profileSql) {
            fetchStartTime = System.currentTimeMillis();
        }
        ResultSet results = this.getResultSet(columnCount, maxRows, resultSetType, streamResults, catalog);
        if (this.profileSql) {
            long fetchElapsedTime = System.currentTimeMillis() - fetchStartTime;
            profileMsgBuf.append("result set fetch time:\t");
            profileMsgBuf.append(fetchElapsedTime);
            System.err.println(profileMsgBuf.toString());
        }
        return results;
    }

    String getHost() {
        return this.host;
    }

    boolean versionMeetsMinimum(int major, int minor, int subminor) {
        if (this.getServerMajorVersion() >= major) {
            if (this.getServerMajorVersion() == major) {
                if (this.getServerMinorVersion() >= minor) {
                    if (this.getServerMinorVersion() == minor) {
                        return this.getServerSubMinorVersion() >= subminor;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private final void clearReceive() throws SQLException {
    }

    private final int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return n;
    }

    private final Buffer readPacket() throws SQLException {
        try {
            int packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
            if (packetLength == -65793) {
                this.forceClose();
                throw new IOException("Unexpected end of input stream");
            }
            this.mysqlInput.read();
            byte[] buffer = new byte[packetLength + 1];
            this.readFully(this.mysqlInput, buffer, 0, packetLength);
            buffer[packetLength] = 0;
            Buffer packet = new Buffer(buffer);
            return packet;
        }
        catch (IOException ioEx) {
            StringBuffer message = new StringBuffer(SQLError.get("08S01"));
            message.append(": ");
            message.append(ioEx.getClass().getName());
            message.append(", underlying cause: ");
            message.append(ioEx.getMessage());
            if (!this.connection.useParanoidErrorMessages()) {
                message.append(Util.stackTraceToString(ioEx));
            }
            throw new SQLException(message.toString(), "08S01", 0);
        }
    }

    private ResultSet buildResultSetWithRows(String catalog, Field[] fields, RowData rows, int resultSetConcurrency) throws SQLException {
        switch (resultSetConcurrency) {
            case 1007: {
                return new ResultSet(catalog, fields, rows, this.connection);
            }
            case 1008: {
                return new UpdatableResultSet(catalog, fields, rows, this.connection);
            }
        }
        return new ResultSet(catalog, fields, rows, this.connection);
    }

    private ResultSet buildResultSetWithUpdates(Buffer resultPacket) throws SQLException {
        long updateCount = -1L;
        long updateID = -1L;
        String info = null;
        try {
            if (this.useNewUpdateCounts) {
                updateCount = resultPacket.newReadLength();
                updateID = resultPacket.newReadLength();
            } else {
                updateCount = resultPacket.readLength();
                updateID = resultPacket.readLength();
            }
            if (this.connection.isReadInfoMsgEnabled()) {
                if (this.use41Extensions) {
                    int serverStatus = resultPacket.readInt();
                    int warningCount = resultPacket.readInt();
                    resultPacket.readByte();
                }
                info = resultPacket.readString();
            }
        }
        catch (Exception ex) {
            throw new SQLException(SQLError.get("S1000") + ": " + ex.getClass().getName(), "S1000", -1);
        }
        ResultSet updateRs = new ResultSet(updateCount, updateID);
        if (info != null) {
            updateRs.setServerInfo(info);
        }
        return updateRs;
    }

    private void reclaimLargeReusablePacket() {
        if (this.reusablePacket != null && this.reusablePacket.getBufLength() > 0x100000) {
            this.reusablePacket = new Buffer(this.connection.getNetBufferLength());
        }
    }

    private final Buffer reuseAndReadPacket(Buffer reuse) throws SQLException {
        try {
            if (reuse.wasMultiPacket()) {
                int bytesAvail = this.mysqlInput.available();
                if (bytesAvail <= 2) {
                    reuse.setBufLength(1);
                    reuse.setPosition(0);
                    reuse.writeByte((byte)-2);
                    this.mysqlInput.skip(bytesAvail);
                }
                reuse.setWasMultiPacket(false);
                return reuse;
            }
            reuse.setWasMultiPacket(false);
            int packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
            if (packetLength == -65793) {
                this.forceClose();
                throw new IOException("Unexpected end of input stream");
            }
            byte multiPacketSeq = (byte)this.mysqlInput.read();
            reuse.setPosition(0);
            reuse.setSendLength(0);
            if (reuse.getByteBuffer().length <= packetLength) {
                reuse.setByteBuffer(new byte[packetLength + 1]);
            }
            reuse.setBufLength(packetLength);
            this.readFully(this.mysqlInput, reuse.getByteBuffer(), 0, packetLength);
            boolean isMultiPacket = false;
            if (packetLength == this.maxThreeBytes) {
                reuse.setPosition(this.maxThreeBytes);
                int packetEndPoint = packetLength;
                isMultiPacket = true;
                packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
                if (packetLength == -65793) {
                    this.forceClose();
                    throw new IOException("Unexpected end of input stream");
                }
                Buffer multiPacket = new Buffer(packetLength);
                boolean firstMultiPkt = true;
                while (true) {
                    if (!firstMultiPkt) {
                        packetLength = this.mysqlInput.read() + (this.mysqlInput.read() << 8) + (this.mysqlInput.read() << 16);
                        if (packetLength == -65793) {
                            this.forceClose();
                            throw new IOException("Unexpected end of input stream");
                        }
                    } else {
                        firstMultiPkt = false;
                    }
                    if (packetLength == 1 || this.useNewLargePackets && packetLength == 0) break;
                    byte newPacketSeq = (byte)this.mysqlInput.read();
                    if (newPacketSeq != multiPacketSeq + 1) {
                        throw new IOException("Packets received out of order");
                    }
                    multiPacketSeq = newPacketSeq;
                    multiPacket.setPosition(0);
                    multiPacket.setSendLength(0);
                    multiPacket.setBufLength(packetLength);
                    byte[] byteBuf = multiPacket.getByteBuffer();
                    int lengthToWrite = packetLength;
                    int bytesRead = this.readFully(this.mysqlInput, byteBuf, 0, packetLength);
                    if (bytesRead != lengthToWrite) {
                        throw new SQLException("Short read from server, expected " + lengthToWrite + " bytes, received only " + bytesRead + ".", "08S01");
                    }
                    reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
                    packetEndPoint += lengthToWrite;
                }
                reuse.writeByte((byte)0);
                reuse.setPosition(0);
                reuse.setWasMultiPacket(true);
            }
            if (!isMultiPacket) {
                reuse.getByteBuffer()[packetLength] = 0;
            }
            return reuse;
        }
        catch (IOException ioEx) {
            StringBuffer message = new StringBuffer(SQLError.get("08S01"));
            message.append(": ");
            message.append(ioEx.getClass().getName());
            message.append(", underlying cause: ");
            message.append(ioEx.getMessage());
            if (!this.connection.useParanoidErrorMessages()) {
                message.append(Util.stackTraceToString(ioEx));
            }
            throw new SQLException(message.toString(), "08S01", 0);
        }
    }

    private final void send(Buffer packet) throws SQLException {
        int l = packet.getPosition();
        this.send(packet, l);
        if (packet == this.sharedSendPacket) {
            this.reclaimLargeSharedSendPacket();
        }
    }

    private final void send(Buffer packet, int packetLen) throws SQLException {
        try {
            if (packetLen > this.maxAllowedPacket) {
                throw new PacketTooBigException(packetLen, this.maxAllowedPacket);
            }
            if (this.serverMajorVersion >= 4 && packetLen >= this.maxThreeBytes) {
                this.sendSplitPackets(packet);
            } else {
                int headerLength = 4;
                this.packetSequence = (byte)(this.packetSequence + 1);
                packet.setPosition(0);
                if (this.useCompression) {
                    packet.writeLongInt(packetLen - headerLength);
                    packet.writeByte(this.packetSequence);
                    if (packetLen < 50) {
                        Buffer compressedPacket = new Buffer(packetLen + (headerLength += 3));
                        compressedPacket.setPosition(0);
                        compressedPacket.writeLongInt(0);
                        compressedPacket.writeLongInt(packetLen - 4);
                        compressedPacket.writeByte(this.packetSequence);
                        int i = 5;
                        while (i < packetLen) {
                            compressedPacket.writeByte(packet.getByteBuffer()[i]);
                            ++i;
                        }
                        this.mysqlOutput.write(compressedPacket.getByteBuffer(), 0, compressedPacket.getPosition());
                        this.mysqlOutput.flush();
                    } else {
                        Buffer compressedPacket = new Buffer(packetLen + (headerLength += 3));
                        byte[] compressedBytes = compressedPacket.getByteBuffer();
                        this.deflater.setInput(packet.getByteBuffer(), 4, packetLen);
                        int compLen = this.deflater.deflate(compressedBytes, headerLength, packetLen);
                        compressedPacket.setPosition(0);
                        compressedPacket.writeLongInt(compLen);
                        compressedPacket.writeLongInt(packetLen - headerLength);
                        compressedPacket.writeByte(this.packetSequence);
                        this.mysqlOutput.write(compressedPacket.getByteBuffer(), 0, compLen);
                        this.mysqlOutput.flush();
                    }
                } else {
                    packet.writeLongInt(packetLen - headerLength);
                    packet.writeByte(this.packetSequence);
                    this.mysqlOutput.write(packet.getByteBuffer(), 0, packetLen);
                    this.mysqlOutput.flush();
                }
            }
            if (packet == this.sharedSendPacket) {
                this.reclaimLargeSharedSendPacket();
            }
        }
        catch (IOException ioEx) {
            StringBuffer message = new StringBuffer(SQLError.get("08S01"));
            message.append(": ");
            message.append(ioEx.getClass().getName());
            message.append(", underlying cause: ");
            message.append(ioEx.getMessage());
            if (!this.connection.useParanoidErrorMessages()) {
                message.append(Util.stackTraceToString(ioEx));
            }
            throw new SQLException(message.toString(), "08S01", 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ResultSet sendFileToServer(String fileName) throws SQLException {
        Buffer filePacket;
        block16: {
            block14: {
                filePacket = this.loadFileBufRef == null ? null : (Buffer)this.loadFileBufRef.get();
                int packetLength = Math.min(this.connection.getMaxAllowedPacket() - 12, this.alignPacketSize(this.connection.getMaxAllowedPacket() - 16, 4096) - 12);
                try {
                    if (filePacket == null) {
                        filePacket = new Buffer(packetLength + 4);
                        this.loadFileBufRef = new SoftReference<Buffer>(filePacket);
                    }
                }
                catch (OutOfMemoryError oom) {
                    this.reusablePacket.clear();
                    this.send(this.reusablePacket);
                    throw new SQLException("Unable to allocate packet of size '" + (packetLength + 4) + "' for LOAD DATA LOCAL INFILE. Either increase heap space available to your JVM, or adjust the MySQL server variable 'max_allowed_packet'", "S1001");
                }
                filePacket.clear();
                this.send(filePacket, 0);
                byte[] fileBuf = new byte[packetLength];
                BufferedInputStream fileIn = null;
                try {
                    try {
                        fileIn = new BufferedInputStream(new FileInputStream(fileName));
                        int bytesRead = 0;
                        while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                            filePacket.clear();
                            filePacket.writeBytesNoNull(fileBuf, 0, bytesRead);
                            this.send(filePacket);
                        }
                    }
                    catch (IOException ioEx) {
                        StringBuffer messageBuf = new StringBuffer("Unable to open file ");
                        if (!this.connection.useParanoidErrorMessages()) {
                            messageBuf.append("'");
                            if (fileName != null) {
                                messageBuf.append(fileName);
                            }
                            messageBuf.append("'");
                        }
                        messageBuf.append("for 'LOAD DATA LOCAL INFILE' command.");
                        if (this.connection.useParanoidErrorMessages()) throw new SQLException(messageBuf.toString(), "S1009");
                        messageBuf.append("Due to underlying IOException: ");
                        messageBuf.append(Util.stackTraceToString(ioEx));
                        throw new SQLException(messageBuf.toString(), "S1009");
                    }
                    Object var9_10 = null;
                    if (fileIn == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (fileIn == null) {
                        filePacket.clear();
                        this.send(filePacket);
                        throw throwable;
                    }
                    try {
                        fileIn.close();
                    }
                    catch (Exception ex) {
                        throw new SQLException("Unable to close local file during LOAD DATA LOCAL INFILE command", "S1000");
                    }
                    fileIn = null;
                    throw throwable;
                }
                try {}
                catch (Exception ex) {
                    throw new SQLException("Unable to close local file during LOAD DATA LOCAL INFILE command", "S1000");
                }
                fileIn.close();
                fileIn = null;
                break block16;
            }
            filePacket.clear();
            this.send(filePacket);
        }
        filePacket.clear();
        this.send(filePacket);
        Buffer resultPacket = this.checkErrorPacket();
        return this.buildResultSetWithUpdates(resultPacket);
    }

    private Buffer checkErrorPacket() throws SQLException {
        return this.checkErrorPacket(-1);
    }

    private Buffer checkErrorPacket(int command) throws SQLException {
        byte statusCode = 0;
        Buffer resultPacket = null;
        try {
            resultPacket = this.reuseAndReadPacket(this.reusablePacket);
            statusCode = resultPacket.readByte();
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception fallThru) {
            String underlyingMessage = fallThru.getMessage();
            throw new SQLException(SQLError.get("08S01") + ": " + fallThru.getClass().getName() + ", " + (underlyingMessage != null ? underlyingMessage : "no message given by JVM"), "08S01", 0);
        }
        if (statusCode == -1) {
            int errno = 2000;
            if (this.protocolVersion > 9) {
                errno = resultPacket.readInt();
                String xOpen = null;
                String serverErrorMessage = resultPacket.readString();
                if (serverErrorMessage.startsWith("#")) {
                    if (serverErrorMessage.length() > 6) {
                        xOpen = serverErrorMessage.substring(1, 6);
                        serverErrorMessage = serverErrorMessage.substring(6);
                        if (xOpen.equals("HY000")) {
                            xOpen = SQLError.mysqlToXOpen(errno);
                        }
                    } else {
                        xOpen = SQLError.mysqlToXOpen(errno);
                    }
                } else {
                    xOpen = SQLError.mysqlToXOpen(errno);
                }
                this.clearReceive();
                StringBuffer errorBuf = new StringBuffer(" message from server: \"");
                errorBuf.append(serverErrorMessage);
                errorBuf.append("\"");
                throw new SQLException(SQLError.get(xOpen) + ", " + errorBuf.toString(), xOpen, errno);
            }
            String serverErrorMessage = resultPacket.readString();
            this.clearReceive();
            if (serverErrorMessage.indexOf("Unknown column") != -1) {
                throw new SQLException(SQLError.get("S0022") + ", " + serverErrorMessage, "S0022", -1);
            }
            StringBuffer errorBuf = new StringBuffer(" message from server: \"");
            errorBuf.append(serverErrorMessage);
            errorBuf.append("\"");
            throw new SQLException(SQLError.get("S1000") + ", " + errorBuf.toString(), "S1000", -1);
        }
        return resultPacket;
    }

    private final void sendSplitPackets(Buffer packet) throws SQLException {
        try {
            Buffer headerPacket;
            Buffer buffer = headerPacket = this.splitBufRef == null ? null : (Buffer)this.splitBufRef.get();
            if (headerPacket == null) {
                headerPacket = new Buffer(this.maxThreeBytes + 4);
                this.splitBufRef = new SoftReference<Buffer>(headerPacket);
            }
            int len = packet.getPosition();
            int splitSize = this.maxThreeBytes;
            int originalPacketPos = 4;
            byte[] origPacketBytes = packet.getByteBuffer();
            byte[] headerPacketBytes = headerPacket.getByteBuffer();
            while (len >= this.maxThreeBytes) {
                headerPacket.setPosition(0);
                headerPacket.writeLongInt(splitSize);
                this.packetSequence = (byte)(this.packetSequence + 1);
                headerPacket.writeByte(this.packetSequence);
                System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, splitSize);
                this.mysqlOutput.write(headerPacketBytes, 0, splitSize + 4);
                this.mysqlOutput.flush();
                originalPacketPos += splitSize;
                len -= splitSize;
            }
            headerPacket.clear();
            headerPacket.setPosition(0);
            headerPacket.writeLongInt(len - 4);
            this.packetSequence = (byte)(this.packetSequence + 1);
            headerPacket.writeByte(this.packetSequence);
            if (len != 0) {
                System.arraycopy(origPacketBytes, originalPacketPos, headerPacketBytes, 4, len - 4);
            }
            this.mysqlOutput.write(headerPacket.getByteBuffer(), 0, len);
            this.mysqlOutput.flush();
        }
        catch (IOException ioEx) {
            StringBuffer message = new StringBuffer(SQLError.get("08S01"));
            message.append(": ");
            message.append(ioEx.getClass().getName());
            message.append(", underlying cause: ");
            message.append(ioEx.getMessage());
            if (!this.connection.useParanoidErrorMessages()) {
                message.append(Util.stackTraceToString(ioEx));
            }
            throw new SQLException(message.toString(), "08S01", 0);
        }
    }

    private int alignPacketSize(int a, int l) {
        return a + l - 1 & ~(l - 1);
    }

    private void checkForOutstandingStreamingData() throws SQLException {
        if (this.streamingData != null) {
            if (!this.connection.getClobberStreamingResults()) {
                throw new SQLException("Streaming result set " + this.streamingData + " is still active." + " Only one streaming result set may be open and in use per-connection. Ensure that you have called .close() on " + " any active result sets before attempting more queries.");
            }
            this.streamingData.getOwner().realClose(false);
            this.clearInputStream();
        }
    }

    private void clearInputStream() throws SQLException {
        try {
            int len = this.mysqlInput.available();
            while (len > 0) {
                this.mysqlInput.skip(len);
                len = this.mysqlInput.available();
            }
        }
        catch (IOException ioEx) {
            throw new SQLException("I/O error while clearing input stream of old results", "08S01");
        }
    }

    private SocketFactory createSocketFactory() throws SQLException {
        try {
            if (this.socketFactoryClassName == null) {
                throw new SQLException("No name specified for socket factory", "08001");
            }
            return (SocketFactory)Class.forName(this.socketFactoryClassName).newInstance();
        }
        catch (Exception ex) {
            throw new SQLException("Could not create socket factory '" + this.socketFactoryClassName + "' due to underlying exception: " + ex.toString(), "08001");
        }
    }

    private void reclaimLargeSharedSendPacket() {
        if (this.sharedSendPacket != null && this.sharedSendPacket.getBufLength() > 0x100000) {
            this.sharedSendPacket = new Buffer(this.connection.getNetBufferLength());
        }
    }

    private void secureAuth(int packLength, int serverCapabilities, long clientParam, String user, String password, String database) throws SQLException {
        Buffer packet = new Buffer(packLength);
        if (this.use41Extensions) {
            if (this.versionMeetsMinimum(4, 1, 1)) {
                packet.writeLong(clientParam);
                packet.writeLong(this.maxThreeBytes);
                packet.writeByte((byte)8);
                packet.writeBytesNoNull(new byte[23]);
            } else {
                packet.writeLong(clientParam);
                packet.writeLong(this.maxThreeBytes);
            }
        } else {
            packet.writeInt((int)clientParam);
            packet.writeLongInt(this.maxThreeBytes);
        }
        packet.writeString(user);
        if (password.length() != 0) {
            packet.writeString(FALSE_SCRAMBLE);
        } else {
            packet.writeString("");
        }
        if ((serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
            packet.writeString(database);
        }
        this.send(packet);
        if (password.length() > 0) {
            Buffer b = this.readPacket();
            b.setPosition(0);
            byte[] replyAsBytes = b.getByteBuffer();
            if (replyAsBytes.length == 25 && replyAsBytes[0] != 0) {
                if (replyAsBytes[0] != 42) {
                    try {
                        byte[] buff = Security.passwordHashStage1(password);
                        byte[] passwordHash = new byte[buff.length];
                        System.arraycopy(buff, 0, passwordHash, 0, buff.length);
                        passwordHash = Security.passwordHashStage2(passwordHash, replyAsBytes);
                        byte[] packetDataAfterSalt = new byte[replyAsBytes.length - 5];
                        System.arraycopy(replyAsBytes, 4, packetDataAfterSalt, 0, replyAsBytes.length - 5);
                        byte[] mysqlScrambleBuff = new byte[20];
                        Security.passwordCrypt(packetDataAfterSalt, mysqlScrambleBuff, passwordHash, 20);
                        Security.passwordCrypt(mysqlScrambleBuff, buff, buff, 20);
                        Buffer packet2 = new Buffer(25);
                        packet2.writeBytesNoNull(buff);
                        this.packetSequence = (byte)(this.packetSequence + 1);
                        this.send(packet2, 24);
                    }
                    catch (NoSuchAlgorithmException nse) {
                        throw new SQLException("Failed to create message digest 'SHA-1' for authentication.  You must use a JDK that supports JCE to be able to use secure connection authentication", "S1000");
                    }
                }
                try {
                    byte[] passwordHash = Security.createKeyFromOldPassword(password);
                    byte[] netReadPos4 = new byte[replyAsBytes.length - 5];
                    System.arraycopy(replyAsBytes, 4, netReadPos4, 0, replyAsBytes.length - 5);
                    byte[] mysqlScrambleBuff = new byte[20];
                    Security.passwordCrypt(netReadPos4, mysqlScrambleBuff, passwordHash, 20);
                    String scrambledPassword = Util.scramble(new String(mysqlScrambleBuff), password);
                    Buffer packet2 = new Buffer(packLength);
                    packet2.writeString(scrambledPassword);
                    this.packetSequence = (byte)(this.packetSequence + 1);
                    this.send(packet2, 24);
                }
                catch (NoSuchAlgorithmException nse) {
                    throw new SQLException("Failed to create message digest 'SHA-1' for authentication.  You must use a JDK that supports JCE to be able to use secure connection authentication", "S1000");
                }
            }
        }
    }

    private void secureAuth411(int packLength, int serverCapabilities, long clientParam, String user, String password, String database) throws SQLException {
        Buffer packet = new Buffer(packLength);
        if (this.use41Extensions) {
            if (this.versionMeetsMinimum(4, 1, 1)) {
                packet.writeLong(this.clientParam);
                packet.writeLong(this.maxThreeBytes);
                packet.writeByte((byte)8);
                packet.writeBytesNoNull(new byte[23]);
            } else {
                packet.writeLong(this.clientParam);
                packet.writeLong(this.maxThreeBytes);
            }
        } else {
            packet.writeInt(this.clientParam);
            packet.writeLongInt(this.maxThreeBytes);
        }
        packet.writeString(user);
        packet.writeByte((byte)20);
        if (password.length() != 0) {
            try {
                packet.writeBytesNoNull(Security.scramble411(password, this.seed));
            }
            catch (NoSuchAlgorithmException nse) {
                throw new SQLException("Failed to create message digest 'SHA-1' for authentication.  You must use a JDK that supports JCE to be able to use secure connection authentication", "S1000");
            }
        } else {
            packet.writeByte((byte)0);
        }
        if ((serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
            packet.writeString(database);
        }
        this.send(packet);
        byte by = this.packetSequence;
        this.packetSequence = (byte)(by + 1);
        byte savePacketSequence = by;
        Buffer reply = this.checkErrorPacket();
        if (reply.isLastDataPacket()) {
            this.packetSequence = savePacketSequence = (byte)(savePacketSequence + 1);
            packet.clear();
            String seed323 = this.seed.substring(0, 8);
            packet.writeString(Util.newCrypt(password, seed323));
            this.send(packet);
            this.checkErrorPacket();
        }
    }

    static {
        NULL_LENGTH = -1;
        COMP_HEADER_LENGTH = 3;
        MIN_COMPRESS_LEN = 50;
        HEADER_LENGTH = 4;
        maxBufferSize = 65535;
        CLIENT_COMPRESS = 32;
        CLIENT_CONNECT_WITH_DB = 8;
        CLIENT_FOUND_ROWS = 2;
        CLIENT_IGNORE_SPACE = 256;
        CLIENT_LOCAL_FILES = 128;
        CLIENT_LONG_FLAG = 4;
        CLIENT_LONG_PASSWORD = 1;
        CLIENT_PROTOCOL_41 = 512;
        CLIENT_INTERACTIVE = 1024;
        CLIENT_SSL = 2048;
        CLIENT_RESERVED = 16384;
        CLIENT_SECURE_CONNECTION = 32768;
        FALSE_SCRAMBLE = FALSE_SCRAMBLE;
    }
}

