'	Frank Lupo (Wolf) !! 
'	frank_lupo@email.it
'
'	This is a Create User command for Postgresql write in Visual Basic Script
'
'	main program
'
Option Explicit

'	Inclue a file in current script 
Public Function Include(FileInclude)
Dim Fso,Ifile
Const ForReading=1

	Set Fso = CreateObject("Scripting.FileSystemObject")
	If Fso.FileExists(FileInclude) Then
		'	read file
   		Set Ifile = Fso.OpenTextFile(FileInclude, ForReading)
       	Include = Ifile.ReadAll()
      	Set Fso = Nothing
	Else
		'	Error not exist file
       	Msgbox "Include Fallied !!" & vbcrlf & "File " & FileInclude & " Not exist !!",VbSystemModal + VbCritical
       	Include = "Wscript.Quit"
	End If
End Function

'////////////////////////////////
'Start initializon

'Include Path 
Dim szIncludePath
Const PATH_INCLUDE="Include"

szIncludePath=Mid(WScript.ScriptFullName,1,Len(WScript.ScriptFullName)-Len(WScript.ScriptName)) & PATH_INCLUDE & "\"

'Init Applications
Execute Include(szIncludePath & "App.vbs")
Dim App
Set App = New ClsApplications

'////////////////////////////////////
'Main Program

Sub Main()
Dim objArgs,szTemp,WshShell,szTemp1
Dim szPsqlVbsOpt,PsqlParm,bCanAddUser,bCanCreateDb,szSysId,szPassword,szUser,szGroup
Dim szQuery,bEncripted

	App.Title="Create User"
	App.ProductName="CreateUser"
	App.Revision=1
	App.Minor=0
	App.Major=0

	Set objArgs = WScript.Arguments
	Set WshShell = WScript.CreateObject("WScript.Shell")

	'Verify if program to start using cscript
	If App.ComplierType <> RUN_USING_CSCRIPT Then
		'Run program using Cscript
		szTemp=""
		For Each objArgs in WScript.Arguments
			szTemp = szTemp & " " & objArgs
		Next
		szTemp=Trim(szTemp)

		WshShell.Run "cmd /K " & CSCRIPT_PROGRAM & " //nologo " & WScript.ScriptFullName & " " & szTemp
		WScript.quit
	End If

	'Show Help
	If objArgs.Named.Exists("HELP") Then 
        wscript.echo App.ProductName & " creates a new PostgreSQL user." 
        wscript.echo ""
        wscript.echo "Usage:" 
        wscript.echo "  " & App.ProductName & " OPTION" 
        wscript.echo ""
        wscript.echo "Options:" 
        wscript.echo "  /ADDUSER              user can add new users" 
        wscript.echo "  /NOADDUSER            user cannot add new users" 
        wscript.echo "  /CREATEDB             user can create new databases" 
        wscript.echo "  /NOCREATEDB           user cannot create databases" 
        wscript.echo "  /NEWUSER:NAME         user name" 
        wscript.echo "  /PWDNEWUSER:PASSWORD  assign a password to new user" 
        wscript.echo "  /ENCRIPTED            encrypt stored password" 
        wscript.echo "  /UNENCRIPTED          do no encrypt stored password" 
        wscript.echo "  /SYSID:SYSID          select sysid for new user"      
        wscript.echo "  /GROUP:NAME           select group for new user"
        wscript.echo "  /ECHOQ                show the query being sent to the backend" 
'        wscript.echo "  -q, --quiet               don't write any messages" 
        wscript.echo "  /HELP                 show this help, then exit" 
        wscript.echo ""
        wscript.echo "Connection options:" 
        wscript.echo "  /HOST:NAME            database server host" 
        wscript.echo "  /PORT:PORT            database server port" 
        wscript.echo "  /USER:NAME            user name to connect as (not the one to create)" 
        wscript.echo "  /PWD:PASSWORD         prompt for password to connect" 
        wscript.echo ""
        wscript.echo "If one of /ADDUSER, /NOADDUSER, /CREATEDB, /NOCREATEDB, and /NEWUSER" 
        wscript.echo "is not specified, you will be prompted interactively." 
        wscript.echo ""
        wscript.echo "Report bugs to <frank_lupo@email.it>." 
        wscript.echo ""
		wscript.quit
	end if

	'Read parameter 
	szPsqlVbsOpt=""
    PsqlParm=Array("HOST","PORT","USER","PWD","ECHOQ")
	For Each szTemp1 in PsqlParm
		If objArgs.Named.Exists(szTemp1) Then 
			szPsqlVbsOpt=szPsqlVbsOpt & " /" & szTemp1 
			szTemp=objArgs.Named.Item(szTemp1)
			if len(trim(szTemp)) > 0 then szPsqlVbsOpt=szPsqlVbsOpt & ":" & szTemp
		End if
	Next

	'Sys id
	szSysId=""
	If objArgs.Named.Exists("SYSID") Then 
		szTemp=objArgs.Named.Item("SYSID")
		if len(trim(szTemp)) > 0 then 
			szSysId=szTemp
			on error resume next
			if Int(szSysId) <= 0 then
		        wscript.echo App.ProductName & ": user sysid must be a positive number"
				wscript.quit
			end if
			on error goto 0
		end if
	End if

	'Password New user
	szPassword=""
	If objArgs.Named.Exists("PWDNEWUSER") Then 
		szTemp=objArgs.Named.Item("PWDNEWUSER")
		if len(trim(szTemp)) > 0 then szPassword=szTemp
	End if

	'User name for new user
	szUser=""
	If objArgs.Named.Exists("NEWUSER") Then 
		szTemp=objArgs.Named.Item("NEWUSER")
		if len(trim(szTemp)) > 0 then szUser=szTemp
	End if

	'Require User Name
	if len(trim(szUser)) =0 then
		WScript.StdOut.Write "Enter name of user to add: "
		szUser = WScript.StdIn.ReadLine
		if len(trim(szUser)) =0 then Wscript.Quit
	end if

	'Require Password User
	If objArgs.Named.Exists("PWDNEWUSER") and len(trim(szPassword)) =0 Then 
		WScript.StdOut.Write "Enter password for user " & szUser & ": "
		szTemp = WScript.StdIn.ReadLine

		WScript.StdOut.Write "Enter it again: "
		szTemp1 = WScript.StdIn.ReadLine

		if szTemp <> szTemp1 Then
            WScript.echo "Passwords didn't match."
			Wscript.Quit
		else
			szPassword=szTemp
		end if
	end if

	'Create Database
	bCanCreateDb=False
	If objArgs.Named.Exists("CREATEDB") Then 
		bCanCreateDb=True
	elseIf objArgs.Named.Exists("NOCREATEDB") Then 
		bCanCreateDb=False
	else
		WScript.StdOut.Write "Shall the new user be allowed to create databases? (y/n) "
		if ucase(trim(WScript.StdIn.ReadLine))="Y" then bCanCreateDb=True
	end if

	'Add user
	bCanAddUser=False
	If objArgs.Named.Exists("ADDUSER") Then 
		bCanAddUser=True
	elseIf objArgs.Named.Exists("NOADDUSER") Then 
		bCanAddUser=False
	else
		WScript.StdOut.Write "Shall the new user be allowed to create more new users? (y/n) "
		if ucase(trim(WScript.StdIn.ReadLine))="Y" then bCanAddUser=True
	end if

	'Group
	szGroup=""
	If objArgs.Named.Exists("GROUP") Then 
		szTemp=trim(objArgs.Named.Item("GROUP"))
		if len(szTemp) > 0 then szGroup=szTemp	
	End if
	if len(szGroup) =0 then
		WScript.StdOut.Write "Enter group(s) for user " & szUser & " (e.g group1,group2) : "
		szGroup = trim(WScript.StdIn.ReadLine)
	end if

	'encrypt
    bEncripted=False
	If objArgs.Named.Exists("ENCRIPTED") Then 
		bEncripted=True
	elseIf objArgs.Named.Exists("UNENCRIPTED") Then 
		bCanAddUser=False
	end if

	'build SQL command
	szQuery="CREATE USER " & szUser
	if len(szSysID) > 0 then szQuery=szQuery & "SYSID " & szSysId

	szQuery=szQuery & " WITH "

	if len(szPassword) > 0 then 
		if bCanAddUser then
			szQuery=szQuery & " ENCRYPTED "
		else
			szQuery=szQuery & " UNENCRYPTED "
		end if
		szQuery=szQuery & " PASSWORD '" & szPassword & "'"
	end if

  	if bCanCreateDb then 
		szQuery=szQuery & " CREATEDB "
	else
		szQuery=szQuery & " NOCREATEDB "
	end if

  	if bCanAddUser then 
		szQuery=szQuery & " CREATEUSER "
	else
		szQuery=szQuery & " NOCREATEUSER "
	end if

	if len(szGroup) > 0 then szQuery=szQuery & "IN GROUP " & szGroup

	szTemp="CMD /K " & CSCRIPT_PROGRAM & " //nologo " & App.path & "psql.vbs /DB:template1 "
    szTemp=szTemp & " /CMD:""" & szQuery & ";""" & " " & szPsqlVbsOpt

	'Run command
	WshShell.Run szTemp
End Sub

'////////////////////////////
'Main Program
Main
