
/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import MaterialLibrary
import QtQuick3D.Effects
import QtQuick.Layouts
import QtQuick.Studio.Components
import QtQuick3D.Helpers
import ComponentBundles.MaterialBundle

Rectangle {
    id: root

    width: Constants.width
    height: Constants.height
    color: "#000000"
    border.color: "#ffffff"
    state: "loading"
    property int stateVal: 0
    property int meshSelection: 0

    property string matNameOuter: "Car Paint"
    property string matNameInner: "Silver"
    property int selectedCategory: 0

    transformOrigin: Item.Top

    Timer {
        // switches to nighttime to load it so that next time it is switched is fast
        running: true
        repeat: true
        id: timer

        property int step: 0
    }

    Connections {
        target: timer

        onTriggered: {
            lightingToggle.checked = timer.step++ > 0
            if (timer.step > 1) {
                timer.stop()
                root.state = ""
            }
        }
    }

    property var materialCategories: [qsTr("Metals"), qsTr(
            "Architectural"), qsTr("Synthetic"), qsTr("Other")]

    property var materials: [[carpaint, glitteryCarPaint, aluminium, chrome, steel, steelBrushed, steelFloor, copper, silver, gold, mirror], [asphalt, brick, ceramic, concrete, glass, tintedGlass, wood, woodPlanks, woodParquet, stone], [acrylicpaint, carbonfiber, shinyPlastic, mattePlastic, texturedPlastic, rubber, wax], [fabric, fabricRough, fabricSatin, leather, paper]]

    MaterialNames {
        id: materialNames
        currentCategory: root.selectedCategory
    }

    View3D {
        id: view3D

        width: 1455
        height: 1080
        anchors.right: parent.right
        anchors.rightMargin: 0
        environment: lightingToggle.checked ? daytime : nighttime
        layer.mipmap: false
        camera: sceneCamera2

        Node {
            id: environments

            SceneEnvironment {
                id: daytime
                specularAAEnabled: true
                temporalAAStrength: 2
                lightProbe: dayTex
                probeHorizon: 0.9
                aoSoftness: 0
                aoDistance: 5
                aoStrength: 0
                tonemapMode: SceneEnvironment.TonemapModeLinear
                effects: [colorMaster]
                clearColor: "#000000"
                antialiasingQuality: SceneEnvironment.VeryHigh
                temporalAAEnabled: false
                depthTestEnabled: true

                ColorMaster {
                    id: colorMaster
                    saturation: 0
                    greenStrength: 1
                }

                backgroundMode: SceneEnvironment.SkyBox
                antialiasingMode: SceneEnvironment.MSAA
                depthPrePassEnabled: false
            }

            SceneEnvironment {
                id: nighttime
                specularAAEnabled: true
                lightProbe: nightTex

                ColorMaster {
                    id: colorMaster1
                    saturation: 0
                    greenStrength: 1
                }

                aoSoftness: 0
                clearColor: "#000000"
                backgroundMode: SceneEnvironment.SkyBox
                temporalAAEnabled: false
                effects: [colorMaster1]
                aoDistance: 0
                antialiasingQuality: SceneEnvironment.VeryHigh
                antialiasingMode: SceneEnvironment.MSAA
                tonemapMode: SceneEnvironment.TonemapModeLinear
                depthPrePassEnabled: false
                aoStrength: 0
                depthTestEnabled: true
                probeHorizon: 0.45
            }
        }

        Node {
            id: scene2

            Node {
                id: sceneObjects1
                y: -500
                z: -1000
                Node {
                    id: camOverride
                    x: 10
                    y: -800
                    eulerRotation.y: 0
                    z: -10
                    Node {
                        id: cameraRoot
                        x: -0
                        y: 231.809
                        z: 1009.0816
                        scale.z: 2.5
                        scale.y: 2.5
                        scale.x: 2.5

                        eulerRotation.y: 44.03395
                        eulerRotation.z: -0.00001
                        PerspectiveCamera {
                            id: sceneCamera2
                            x: 0
                            y: 150
                            frustumCullingEnabled: true
                            clipFar: 5000
                            clipNear: 100
                            eulerRotation.z: 0
                            eulerRotation.y: 0
                            z: 500
                            eulerRotation.x: -18
                            fieldOfView: 100
                            fieldOfViewOrientation: PerspectiveCamera.Horizontal
                        }
                        eulerRotation.x: 0
                    }
                }

                Node {
                    id: matBallRoot

                    y: -976.768
                    z: 1007.69037
                    scale.x: 500
                    scale.y: 500
                    scale.z: 500

                    Model {
                        id: floor
                        source: "meshes/floor.mesh"
                        materials: [rectMaterial2]
                    }

                    Model {
                        id: materialBall_Qt
                        source: "meshes/materialBall.mesh"
                        materials: [carpaint, silver]
                    }

                    DirectionalLight {
                        id: lightDirectional_day
                        visible: lightingToggle.checked
                        shadowMapQuality: Light.ShadowMapQualityMedium
                        castsShadow: true
                        eulerRotation.z: -23.70391
                        eulerRotation.y: 49.94215
                        eulerRotation.x: -42.16164
                    }

                    DirectionalLight {
                        id: lightDirectional_night_1
                        visible: !lightingToggle.checked
                        brightness: 0.12
                        eulerRotation.x: -5
                        shadowMapQuality: Light.ShadowMapQualityLow
                        eulerRotation.y: -90
                        eulerRotation.z: 0
                        castsShadow: true
                    }

                    DirectionalLight {
                        id: lightDirectional_night_2
                        visible: !lightingToggle.checked
                        brightness: 0.12
                        eulerRotation.x: -5
                        shadowMapQuality: Light.ShadowMapQualityLow
                        eulerRotation.z: 0
                        eulerRotation.y: 90
                        castsShadow: true
                    }
                }
            }
        }
    }

    MouseRotator {
        id: mouseRotator

        controlledObject: cameraRoot

        xInvert: false
        yInvert: true

        x: mainMatControls.width
        width: root.width - mainMatControls.width
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        preventStealing: false
        cursorShape: Qt.SizeAllCursor
        drag.axis: Drag.YAxis
        drag.target: sceneCamera2

        Connections {
            target: mouseArea

            onWheel: sceneCamera2.fieldOfView += wheel.angleDelta.y * 0.04
                     * (sceneCamera2.fieldOfView + wheel.angleDelta.y * 0.04 > 0.0)
                     * (sceneCamera2.fieldOfView + wheel.angleDelta.y * 0.04 < 120.0)
        }

        PinchArea {
            id: pinchArea
            anchors.fill: parent

            Connections {
                target: pinchArea
                onPinchUpdated: if (pinch.previousScale - pinch.scale > 0.008
                                        || pinch.previousScale - pinch.scale < -0.008) {
                                    let velocity = (pinch.previousScale
                                                    - pinch.scale) > 0 ? 1.25 : -1.25
                                    sceneCamera2.fieldOfView += velocity
                                            * (sceneCamera2.fieldOfView + velocity > 0.0)
                                            * (sceneCamera2.fieldOfView + velocity < 120.0)
                                }
            }
        }
    }

    Rectangle {
        id: mainMatControls

        width: 465
        color: "#212121"
        border.color: "#212121"
        border.width: 0
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom

        GroupItem {
            id: mainMatCatBtns

            Row {
                spacing: 5
                x: 20
                y: 355

                Repeater {
                    model: root.materialCategories

                    RoundButton {
                        width: 102
                        height: 54
                        radius: 8
                        text: ""
                        bottomPadding: 8
                        spacing: 6
                        font.pointSize: 12
                        rightPadding: 9
                        highlighted: false
                        Layout.maximumHeight: 54
                        Layout.maximumWidth: 426
                        flat: true

                        onClicked: root.selectedCategory = index

                        Rectangle {
                            id: rectangle17
                            color: root.selectedCategory === index ? "#5c5c5d" : "#212121"
                            radius: 8
                            border.color: "#5c5c5d"
                            border.width: parent.hovered ? 1 : 0
                            anchors.fill: parent
                        }

                        Text {
                            id: text18
                            color: "#ffffff"
                            text: modelData
                            anchors.left: parent.left
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom
                            font.pixelSize: 16
                            horizontalAlignment: Text.AlignHCenter
                            verticalAlignment: Text.AlignVCenter
                            anchors.horizontalCenter: parent.horizontalCenter
                            anchors.bottomMargin: 2
                        }
                    }
                }
            }
        }

        GroupItem {
            id: main_MetalMats

            anchors.horizontalCenter: parent.horizontalCenter

            Column {
                id: col

                y: 448
                spacing: 5

                Repeater {
                    model: materialNames.model

                    //model: ["test", "test2"]
                    CustomRoundButton {}
                }
            }
        }

        anchors.topMargin: 0
        anchors.bottomMargin: 0
        anchors.leftMargin: 0
    }

    Image {
        id: qtlogo
        anchors.left: parent.left
        anchors.top: parent.top
        source: "images/qtlogo.png"
        anchors.leftMargin: 394
        anchors.topMargin: 27
        fillMode: Image.PreserveAspectFit
    }

    Text {
        id: title
        color: "#ffffff"
        text: qsTr("Material Bundle")
        anchors.left: parent.left
        anchors.top: parent.top
        font.pixelSize: 20
        font.bold: true
        anchors.leftMargin: 21
        anchors.topMargin: 31
    }

    ButtonGroup {
        id: meshSelectionGroup
        buttons: meshSelect.children
        checkedButton: outerMesh
    }

    GroupItem {
        id: meshSelect
        width: 465
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom

        RoundButton {
            id: outerMesh
            property int activeMaterial: 1
            x: 72
            y: 128
            width: 205
            height: 128
            radius: 24
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.leftMargin: 20
            anchors.topMargin: 150
            checkable: true

            Rectangle {
                id: rectangle1
                color: "#212121"
                radius: 6
                border.color: "#707070"
                border.width: outerMesh.checked ? 2 : (parent.hovered ? 1 : 0)
                anchors.fill: parent

                Image {
                    id: outerMesh1
                    anchors.verticalCenter: parent.verticalCenter
                    source: "images/UI/outerMesh.png"
                    anchors.verticalCenterOffset: -16
                    anchors.horizontalCenter: parent.horizontalCenter
                    fillMode: Image.PreserveAspectFit
                }

                Text {
                    id: text16
                    color: "#ffffff"
                    text: qsTr("Outer mesh")
                    anchors.bottom: parent.bottom
                    font.pixelSize: 16
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.bottomMargin: 16
                }
            }

            Connections {
                target: outerMesh
                onClicked: root.meshSelection = 0
            }
        }

        RoundButton {
            id: innerMesh
            property int activeMaterial: 1
            x: 66
            y: 119
            width: 205
            height: 128
            radius: 24
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.rightMargin: 20
            Rectangle {
                id: rectangle2
                color: "#212121"
                radius: 6
                border.color: "#707070"
                border.width: innerMesh.checked ? 2 : (parent.hovered ? 1 : 0)
                anchors.fill: parent

                Image {
                    id: innerMesh1
                    anchors.verticalCenter: parent.verticalCenter
                    source: "images/UI/innerMesh.png"
                    anchors.verticalCenterOffset: -16
                    anchors.horizontalCenter: parent.horizontalCenter
                    fillMode: Image.PreserveAspectFit
                }

                Text {
                    id: text17
                    color: "#ffffff"
                    text: qsTr("Inner mesh")
                    anchors.bottom: parent.bottom
                    font.pixelSize: 16
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.bottomMargin: 16
                }
            }
            checkable: true
            anchors.topMargin: 150
            Connections {
                target: innerMesh
                onClicked: root.meshSelection = 1
            }
        }
    }

    RoundButton {
        id: lightingToggle
        width: 120
        height: 52
        radius: 24
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        checked: true
        anchors.rightMargin: 48
        anchors.bottomMargin: 48
        checkable: true

        Rectangle {
            id: background
            color: "#212121"
            radius: 6
            anchors.fill: parent
        }

        Rectangle {
            id: selector
            width: 60
            color: "#575757"
            radius: 6
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.horizontalCenterOffset: lightingToggle.checked ? -30 : 30
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Image {
            id: lightToggle
            x: 0
            y: 0
            source: "images/UI/lightToggle.png"
            fillMode: Image.PreserveAspectFit
        }

        Text {
            id: text1
            color: "#d9d9d9"
            text: qsTr("Environment")
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            font.pixelSize: 16
            anchors.rightMargin: 160
        }
    }

    Text {
        id: meshSelHint
        color: "#aaaaaa"
        text: qsTr("Select the mesh you want to change material of:")
        anchors.left: parent.left
        anchors.top: parent.top
        font.pixelSize: 16
        anchors.leftMargin: 21
        font.bold: false
        anchors.topMargin: 112
    }

    Text {
        id: matSelHint
        color: "#aaaaaa"
        text: qsTr("Select the material you want to apply to the mesh:")
        anchors.left: parent.left
        anchors.top: parent.top
        font.pixelSize: 16
        font.bold: false
        anchors.leftMargin: 21
        anchors.topMargin: 316
    }

    Rectangle {
        id: loadingRect
        width: Constants.width
        height: Constants.height
        visible: false
        color: "#ffffff"
    }

    Item {
        id: __materialLibrary__

        Texture {
            id: dayTex
            source: "images/HDR/day_mode.png"
            generateMipmaps: true
            mipFilter: Texture.Linear
        }
        Texture {
            id: nightTex
            source: "images/HDR/dark_mode.png"
            generateMipmaps: true
            mipFilter: Texture.Linear
        }
        Texture {
            id: shadow
            source: "images/shadow.png"
        }
        Texture {
            id: vlkhcah_2K_Albedo
            source: "images/vlkhcah_2K_Albedo.jpg"
            scaleV: 1
            scaleU: 1
            mipFilter: Texture.Linear
            generateMipmaps: true
        }

        Texture {
            id: vlkhcah_2K_AO
            source: "images/vlkhcah_2K_AO.jpg"
            scaleV: 4
            scaleU: 4
            mipFilter: Texture.Linear
            generateMipmaps: true
        }

        Texture {
            id: vlkhcah_2K_Normal
            source: "images/vlkhcah_2K_Normal.jpg"
            scaleV: 4
            scaleU: 4
            mipFilter: Texture.Linear
            generateMipmaps: true
        }

        Texture {
            id: vlkhcah_2K_Roughness
            source: "images/vlkhcah_2K_Roughness.jpg"
            scaleV: 4
            scaleU: 4
            mipFilter: Texture.Linear
            generateMipmaps: true
        }

        Texture {
            id: vlkhcah_2K_Albedo2
            source: "images/vlkhcah_2K_Albedo.jpg"
            scaleV: 4
            scaleU: 4
            generateMipmaps: true
            mipFilter: Texture.Linear
        }

        Texture {
            id: groundAlpha
            source: "images/groundAlpha.png"
            mipFilter: Texture.Linear
            generateMipmaps: true
        }

        Texture {
            id: ground_ShadowMap
            source: "images/Ground_ShadowMap.png"
            generateMipmaps: true
            mipFilter: Texture.Linear
        }

        PrincipledMaterial {
            id: rectMaterial3
            cullMode: Material.NoCulling
            depthDrawMode: Material.OpaquePrePassDepthDraw
            baseColorMap: shadow
            specularTint: 1
            opacityChannel: Material.A
            metalness: 0
            specularAmount: 0
            baseColor: "#000000"
            opacityMap: shadow
            objectName: "rectMaterial3"
            emissiveFactor.z: 0
            emissiveFactor.y: 0
            emissiveFactor.x: 0
        }

        PrincipledMaterial {
            id: rectMaterial2
            opacity: 1
            specularMap: vlkhcah_2K_Albedo
            alphaMode: PrincipledMaterial.Mask
            opacityChannel: Material.R
            metalness: 0
            cullMode: Material.BackFaceCulling
            occlusionAmount: 1
            emissiveFactor.x: 0
            objectName: "rectMaterial2"
            specularTint: 0
            specularAmount: 0.24
            clearcoatAmount: 0
            roughnessMap: vlkhcah_2K_Roughness
            normalMap: vlkhcah_2K_Normal
            occlusionMap: ground_ShadowMap
            baseColorMap: vlkhcah_2K_Albedo
            depthDrawMode: Material.OpaquePrePassDepthDraw
            baseColor: "#ffffff"
            roughness: 0.5
        }

        CarPaintMaterial {
            id: carpaint
            objectName: "Car Paint"
        }

        CarPaintGlitterMaterial {
            id: glitteryCarPaint
            objectName: "Glittery Car Paint"
        }

        AluminiumMaterial {
            id: aluminium
            objectName: "Aluminium"
        }

        ChromeMaterial {
            id: chrome
            objectName: "Chrome"
        }

        CopperMaterial {
            id: copper
            objectName: "Copper"
        }

        SilverMaterial {
            id: silver
            objectName: "Silver"
        }

        SteelMaterial {
            id: steel
            objectName: "Steel"
        }

        GoldMaterial {
            id: gold
            objectName: "Gold"
        }

        MirrorMaterial {
            id: mirror
            objectName: "Mirror"
        }

        ConcreteMaterial {
            id: concrete
            objectName: "Concrete"
        }

        CeramicMaterial {
            id: ceramic
            objectName: "Ceramic"
        }

        AsphaltMaterial {
            id: asphalt
            objectName: "Asphalt"
        }

        PaperMaterial {
            id: paper
            objectName: "Paper"
        }

        StoneMaterial {
            id: stone
            objectName: "Stone"
        }

        WoodMaterial {
            id: wood
            objectName: "Wood"
        }

        RubberMaterial {
            id: rubber
            objectName: "Rubber"
        }

        GlassMaterial {
            id: glass
            objectName: "Glass"
        }

        GlassTintedMaterial {
            id: tintedGlass
            objectName: "Glass Tinted"
        }

        WoodParquetMaterial {
            id: woodParquet
            objectName: "Wood Parquet"
        }

        WoodPlanksMaterial {
            id: woodPlanks
            objectName: "Wood Planks"
        }

        BrickMaterial {
            id: brick
            objectName: "Brick"
        }

        SteelBrushedMaterial {
            id: steelBrushed
            objectName: "Steel Brushed"
        }

        SteelFloorMaterial {
            id: steelFloor
            objectName: "Steel Floor"
        }

        FabricMaterial {
            id: fabric
            objectName: "Fabric"
        }

        FabricRoughMaterial {
            id: fabricRough
            objectName: "Fabric Rough"
        }

        FabricSatinMaterial {
            id: fabricSatin
            objectName: "Fabric Satin"
        }

        LeatherMaterial {
            id: leather
            objectName: "Leather"
        }

        AcrylicPaintMaterial {
            id: acrylicpaint
            objectName: "Acrylic Paint"
        }

        CarbonFiberMaterial {
            id: carbonfiber
            objectName: "Carbon Fiber"
        }

        PlasticMatteMaterial {
            id: mattePlastic
            objectName: "Plastic Matte"
        }

        PlasticShinyMaterial {
            id: shinyPlastic
            objectName: "Plastic Shiny"
        }

        PlasticTexturedMaterial {
            id: texturedPlastic
            objectName: "Plastic Textured"
        }

        WaxMaterial {
            id: wax
            objectName: "Wax"
        }
    }
    states: [
        State {
            name: "loading"

            PropertyChanges {
                target: loadingRect
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.75;matPrevEnv:"SkyBox";matPrevEnvValue:"preview_landscape";matPrevModel:"#Sphere"}
D{i:59;invisible:true}
}
##^##*/

