import QtQuick
import QtQuick3D
Node {
    id: armature
    property real end:0
    property real lane:1
    property real start:0
    property bool on: true
    readonly property real transparency: bendplane_material.opacity
    Model {
        id: bendplane2
        skeleton: qmlskeleton
        x: start
        inverseBindPoses: [
            Qt.matrix4x4(0, 1, -7.54979e-08, 0, -1, 0, 0, 6, 0, 7.54979e-08, 1, 0, 0, 0, 0, 1),
            Qt.matrix4x4(0, 1, -7.54979e-08, 0, -1, 0, 0, -5, 0, 7.54979e-08, 1, 0, 0, 0, 0, 1)
        ]
        source: "meshes/bendplane2.mesh"

        DefaultMaterial {
            id: bendplane_material
            lighting: DefaultMaterial.NoLighting
            diffuseMap: laneblender
            diffuseColor: "#ffa3a3a3"

            Texture {
                id: laneblender
                source: "../../../images/laneblender.png"
            }
        }
        materials: [
            bendplane_material
        ]
    }
    Skeleton {
        id: qmlskeleton
        Joint {
            id: bone
            x: 7.589
            y: 0
            z: 0

            rotation: Qt.quaternion(0.707107, -2.66925e-08, 2.66925e-08, 0.707107)
            scale.x: 1
            scale.y: 1
            index: 0
            skeletonRoot: qmlskeleton
        }
        Joint {
            id: bone_001
            x: end
            y: 0
            z: -lane
            rotation: Qt.quaternion(0.707107, -2.66925e-08, 2.66925e-08, 0.707107)
            scale.x: 1
            scale.y: 1
            index: 1
            skeletonRoot: qmlskeleton
        }
    }
    states: [
            State {
                name: "On"
                when: on
            },
            State {
                name: "Off"
                when: !on

                PropertyChanges {
                    target: bendplane_material
                    opacity: 0
                }
            }
        ]
        transitions: [
            Transition {
                id: transition
                ParallelAnimation {
                    SequentialAnimation {
                        PauseAnimation {
                            duration: 50
                        }

                        PropertyAnimation {
                            target: bendplane_material
                            property: "opacity"
                            duration: 150
                        }
                    }
                }
                to: "*"
                from: "*"
            }
        ]
}
