/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick.Timeline
import UiTour

Slide {
    id: slide2
    caption: ""
    title: qsTr("Studio Components: Border and Arc")
    state: "State1"

    Image {
        id: _01_Take_a_new_empty_project
        visible: false
        source: "images/01_Take_a_new_empty_project.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight
            visible: false
        }
    }

    Image {
        id: _02_Add_design_studio_components
        visible: false
        source: "images/02_Add_design_studio_components.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight1
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _03_Studio_components_in_components_view
        visible: false
        source: "images/03_Studio_components_in_components_view.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight2
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _05_Adjust_the_size_in_the_property
        visible: false
        source: "images/05_Adjust_the_size_in_the_property.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight3
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _05_Adjust_the_size_in_the_property1
        visible: false
        source: "images/05_Adjust_the_size_in_the_property.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight4
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _06_Adjust_settings_on_the_property
        visible: false
        source: "images/06_Adjust_settings_on_the_property.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight5
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _07_Toggle_right_and_bottom_borders_off
        visible: false
        source: "images/07_Toggle_right_and_bottom_borders_off.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight6
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _08_Toggle_the_top_left_bevel
        visible: false
        source: "images/08_Toggle_the_top_left_bevel.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight7
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _09_Apply_mouse_right_click_and_copy_the_border
        visible: false
        source: "images/09_Apply_mouse_right_click_and_copy_the_border.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight8
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _10_Apply_paste_to_have_a_duplicate_border
        visible: false
        source: "images/10_Apply_paste_to_have_a_duplicate_border.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight9
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _11_Now_you_have_two_borders
        visible: false
        source: "images/11_Now_you_have_two_borders.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight10
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _12_Select_the_2nd_border_and_apply_180_degrees_rotation
        visible: false
        source: "images/12_Select_the_2nd_border_and_apply_180_degrees_rotation.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight11
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _13_Drag_an_arc_on_the_2D_view
        visible: false
        source: "images/13_Drag_an_arc_on_the_2D_view.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight12
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _14_Increase_the_size_of_the_arc
        visible: false
        source: "images/14_Increase_the_size_of_the_arc.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight13
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _15_Adjust_start_and_end_angles
        visible: false
        source: "images/15_Adjust_start_and_end_angles.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight14
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _16_Apply_outline_features_on_the_arc
        visible: false
        source: "images/16_Apply_outline_features_on_the_arc.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight15
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _17_Apply_a_semi_transparent_border_color
        visible: false
        source: "images/17_Apply_a_semi_transparent_border_color.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight16
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _18_Apply_fill_color_1
        visible: false
        source: "images/18_Apply_fill_color_1.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight17
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _19_Apply_fill_color_2
        visible: false
        source: "images/19_Apply_fill_color_2.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight18
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _20_Drag_the_arc_into_the_border_space
        visible: false
        source: "images/20_Drag_the_arc_into_the_border_space.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight19
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _21_After_final_placement
        visible: false
        source: "images/21_After_final_placement.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight20
            x: -4
            y: -4
            visible: false
        }
    }

    Image {
        id: _23_AfterGrouping
        visible: false
        source: "images/23_After Grouping.png"
        fillMode: Image.PreserveAspectFit

        StrongHighlight {
            id: strongHighlight21
            x: -4
            y: -4
            visible: false
        }
    }

    states: [
        State {
            name: "State1"

            PropertyChanges {
                target: strongHighlight
                x: -9
                y: -8
                width: 1929
                height: 1094
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Create a new project.")
            }

            PropertyChanges {
                target: _01_Take_a_new_empty_project
                visible: true
            }
        },
        State {
            name: "State2"
            extend: "State1"

            PropertyChanges {
                target: strongHighlight
                x: -9
                y: 599
                width: 415
                height: 118
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Qt Quick Studio Components are not visible in the Components view by default. You can add it from the list of components. Select “+” to open the list.")
            }
        },
        State {
            name: "State3"

            PropertyChanges {
                target: _02_Add_design_studio_components
                visible: true
            }

            PropertyChanges {
                target: strongHighlight1
                x: -4
                y: 600
                width: 406
                height: 79
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Write “Studio” in the Search bar to find the Qt Quick Studio Components.")
            }
        },
        State {
            name: "State4"
            extend: "State3"

            PropertyChanges {
                target: strongHighlight1
                x: 0
                y: 703
                width: 406
                height: 78
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select “QtQuick.Studio.Components”. It would disappear from this list because now it is included in the usable components list in the Components view. Select “<” to go back.")
            }
        },
        State {
            name: "State5"

            PropertyChanges {
                target: _03_Studio_components_in_components_view
                visible: true
            }

            PropertyChanges {
                target: strongHighlight2
                x: -4
                y: 872
                width: 383
                height: 173
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("You shall find the Qt Quick Studio Components here. Scroll down in the Components view to find it. Now drag the “Border” component from here to the “2D view”.")
            }
        },
        State {
            name: "State6"

            PropertyChanges {
                target: _05_Adjust_the_size_in_the_property
                visible: true
            }

            PropertyChanges {
                target: strongHighlight3
                x: 1526
                y: 349
                width: 386
                height: 251
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the Border in 2D view and go to the “GEOMETRY – 2D” section of the Properties view. Here change the Width to 400 and the Height to 300 pixels to make it larger.")
            }
        },
        State {
            name: "State7"

            PropertyChanges {
                target: strongHighlight5
                x: 1524
                y: 124
                width: 396
                height: 616
                visible: true
            }

            PropertyChanges {
                target: _06_Adjust_settings_on_the_property
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Find the properties related to the Border component in the Properties view. You can manipulate different settings here to adjust the border to your need.")
            }
        },
        State {
            name: "State8"

            PropertyChanges {
                target: _07_Toggle_right_and_bottom_borders_off
                visible: true
            }

            PropertyChanges {
                target: strongHighlight6
                x: 1524
                y: 606
                width: 396
                height: 115
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Toggle the bottom and right edges of the Border off from the “DRAW EDGES” section in the Properties view.")
            }
        },
        State {
            name: "State9"

            PropertyChanges {
                target: _08_Toggle_the_top_left_bevel
                visible: true
            }

            PropertyChanges {
                target: strongHighlight7
                x: 1526
                y: 705
                width: 394
                height: 256
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Set the top left corner radius of the Border component to 40 pixels. Then toggle the top left corner bevel on to have a flat cut at the corner.")
            }
        },
        State {
            name: "State10"

            PropertyChanges {
                target: _09_Apply_mouse_right_click_and_copy_the_border
                visible: true
            }

            PropertyChanges {
                target: strongHighlight8
                x: 719
                y: 240
                width: 692
                height: 483
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Apply the mouse right-click on the Border component to open the options menu. Select, Edit > Copy to have a duplicate of the component.")
            }
        },
        State {
            name: "State11"

            PropertyChanges {
                target: _10_Apply_paste_to_have_a_duplicate_border
                visible: true
            }

            PropertyChanges {
                target: strongHighlight9
                x: 716
                y: 240
                width: 654
                height: 608
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Apply the mouse right-click again to open up the options menu. Select, Edit > Paste to get the duplicate on the 2D view.")
            }
        },
        State {
            name: "State12"

            PropertyChanges {
                target: _12_Select_the_2nd_border_and_apply_180_degrees_rotation
                visible: true
            }

            PropertyChanges {
                target: strongHighlight11
                x: 1524
                y: 349
                width: 396
                height: 250
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the new Border component. Update the Rotation angle to 180 degrees in the GEOMETRY – 2D properties. Drag and adjust the new Border to place it symmetrically with the previous Border component.")
            }
        },
        State {
            name: "State13"

            PropertyChanges {
                target: _13_Drag_an_arc_on_the_2D_view
                visible: true
            }

            PropertyChanges {
                target: strongHighlight12
                x: -6
                y: 901
                width: 83
                height: 75
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Drag an Arc component to the 2D view.")
            }
        },
        State {
            name: "State14"

            PropertyChanges {
                target: _14_Increase_the_size_of_the_arc
                visible: true
            }

            PropertyChanges {
                target: strongHighlight13
                x: 1530
                y: 389
                width: 382
                height: 52
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the Arc to access its properties. From the GEOMETRY – 2D, increase the size; width 200px, and height 200px.")
            }
        },
        State {
            name: "State15"

            PropertyChanges {
                target: _15_Adjust_start_and_end_angles
                visible: true
            }

            PropertyChanges {
                target: strongHighlight14
                x: 1527
                y: 414
                width: 253
                height: 90
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Set the Arc start to -150 degrees and the Arc end to 150 degrees angles.")
            }
        },
        State {
            name: "State16"

            PropertyChanges {
                target: _16_Apply_outline_features_on_the_arc
                visible: true
            }

            PropertyChanges {
                target: strongHighlight15
                x: 1526
                y: 490
                width: 394
                height: 388
                visible: true
            }

            PropertyChanges {
                target: slide2
                visible: true
                caption: qsTr("In the STROKE DETAILS section of the Properties view, set the Stroke style “Solid” and the Cap style “FlatCap”. In the OUTLINE section, set Outline width “30”, and toggle Full outline, Round start, and Round end on.")
            }
        },
        State {
            name: "State17"
            extend: "State16"

            PropertyChanges {
                target: strongHighlight15
                x: 1526
                y: 292
                width: 394
                height: 206
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the Stroke color for the Arc component. You can click on the red color in the Arc Item section of the Properties view to bring up the color picker.")
            }
        },

        State {
            name: "State18"

            PropertyChanges {
                target: _17_Apply_a_semi_transparent_border_color
                visible: true
            }

            PropertyChanges {
                target: strongHighlight16
                x: 1568
                y: 232
                width: 261
                height: 731
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the black color by moving the circular color picker on the bottom left corner of the color pallet. Drag the transparency and keep in the middle point to make the border semi-transparent.")
            }
        },
        State {
            name: "State19"

            PropertyChanges {
                target: _18_Apply_fill_color_1
                visible: true
            }

            PropertyChanges {
                target: strongHighlight17
                x: 1566
                y: 383
                width: 261
                height: 589
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Change the Arc’s fill color now. Select Fill color in the ARC ITEM section of the Properties view. You will have this color picker opened. From here, first, select the “Linear” gradient. Then select the leftmost color picker to choose the beginning color of the gradient. Set the color “#5cd778” in the Hex value. Keep the transparency slider in its leftmost position to have solid visibility of the color.")
            }
        },
        State {
            name: "State20"

            PropertyChanges {
                target: _19_Apply_fill_color_2
                visible: true
            }

            PropertyChanges {
                target: strongHighlight18
                x: 1572
                y: 215
                width: 254
                height: 748
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("To set the end color of the gradient, select the rightmost color picker. Set the color “#e63ff8” in the Hex value. Keep the transparency slider in its leftmost position to have solid visibility of the color.")
            }
        },
        State {
            name: "State21"

            PropertyChanges {
                target: _20_Drag_the_arc_into_the_border_space
                visible: true
            }

            PropertyChanges {
                target: strongHighlight19
                x: 492
                y: 301
                width: 252
                height: 271
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the Arc component in 2D view and drag it to the middle of the Border components.")
            }
        },
        State {
            name: "State22"

            PropertyChanges {
                target: _21_After_final_placement
                visible: true
            }

            PropertyChanges {
                target: strongHighlight20
                x: 0
                y: 89
                width: 402
                height: 509
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("Select the Border components and the Arc component in the Navigator view. Apply the mouse right-click on any of them to bring the menu. Select “Group in GroupItem” to make a group with these components. Grouping helps to keep them together.")
            }
        },
        State {
            name: "State23"

            PropertyChanges {
                target: _23_AfterGrouping
                visible: true
            }

            PropertyChanges {
                target: strongHighlight21
                x: -4
                y: 92
                width: 406
                height: 254
                visible: true
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("After grouping them in the Navigator view, the components will remain under a GroupItem.")
            }
        },
        State {
            name: "State24"
            extend: "State23"

            PropertyChanges {
                target: strongHighlight21
                x: 669
                y: 220
                width: 597
                height: 453
            }

            PropertyChanges {
                target: slide2
                caption: qsTr("The robust modification properties of these components allow the creation of a well-customized design. Feel free to manipulate component properties following your need to achieve the desired result.")
            }
        }
    ]
}
