/* @(#)niwrite.c	1.5 04/08/08 Copyright 1986, 2001-2003 J. Schilling */
/*
 *	Non interruptable write
 *
 *	Copyright (c) 1986, 2001-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include "schilyio.h"
#include <errno.h>

EXPORT int
_niwrite(f, buf, count)
	int	f;
	void	*buf;
	int	count;
{
	int	ret;
	int	oerrno = geterrno();

	while ((ret = write(f, buf, count)) < 0 && geterrno() == EINTR) {
		/*
		 * Set back old 'errno' so we don't change the errno visible
		 * to the outside if we did not fail.
		 */
		seterrno(oerrno);
	}
	return (ret);
}
