/***************************************************************************
* $Id: Test.java 190460 2002-11-25 18:13:00Z heiden $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;



class Test  extends QWidget {


Test(QWidget parent, String name)
{
	this(parent, name, 0);
}

Test(QWidget parent, String name, int f)
{
    super(parent, name, f);

}

public void paintEvent(QPaintEvent e)
{
    QPainter p = new QPainter(this);
    p.setClipRect(e.rect());
    int d = 1000; //large number
    int x1 = 0;
    int x2 = width()-1;
    int y1 = 0;
    int y2 = height()-1;

    int x = (x1+x2)/2;
    p.drawLine( x, y1, x+d, y1+d   );
    p.drawLine( x, y1, x-d, y1+d   );
    p.drawLine( x, y2, x+d, y2-d   );
    p.drawLine( x, y2, x-d, y2-d   );

    int y = (y1+y2)/2;
    p.drawLine( x1, y, x1+d, y+d   );
    p.drawLine( x1, y, x1+d, y-d   );
    p.drawLine( x2, y, x2-d, y+d   );
    p.drawLine( x2, y, x2-d, y-d   );
	p.end();
}


public static void main(String[] args)
{
    QApplication a = new QApplication( args );

    QSplitter s1 = new QSplitter( QSplitter.Vertical, null , "main" );

    QSplitter s2 = new QSplitter( QSplitter.Horizontal, s1, "top" );

    Test t1 = new Test( s2, "topLeft" );
    t1.setBackgroundColor( Qt.blue().light( 180 ) );
    t1.setMinimumSize( 50, 0 );

    Test t2 = new Test( s2, "topRight" );
    t2.setBackgroundColor( Qt.green().light( 180 ) );
    s2.setResizeMode( t2, QSplitter.KeepSize );
    s2.moveToFirst( t2 );

    QSplitter s3 = new QSplitter( QSplitter.Horizontal,  s1, "bottom" );

    Test t3 = new Test( s3, "bottomLeft" );
    t3.setBackgroundColor( Qt.red() );
    Test t4 = new Test( s3, "bottomMiddle" );
    t4.setBackgroundColor( Qt.white() );

    Test t5 = new Test( s3, "bottomRight" );
    t5.setMaximumHeight( 250 );
    t5.setMinimumSize( 80, 50 );
    t5.setBackgroundColor( Qt.yellow() );

    // Qt/Embedded XOR drawing not yet implemented.
    s1.setOpaqueResize( true );
    s2.setOpaqueResize( true );
    s3.setOpaqueResize( true );

    a.setMainWidget( s1 );
    s1.setCaption("Qt Example - Splitters");
    s1.show();
    int result = a.exec();
    return;
}
	static {
		qtjava.initialize();
	}
}
