/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsSample_h
#define nsSample_h

/**
 * A sample of XPConnect. This file is the header of an implementation
 * nsSample of the nsISample interface.
 *
 */

#include "nsISample.h"
#include "mozilla/Attributes.h"

/**
 * SampleImpl is an implementation of the nsISample interface.  In XPCOM,
 * there can be more than one implementation of an given interface.  Class
 * IDs (CIDs) uniquely identify a particular implementation of an interface.
 * Interface IDs (IIDs) uniquely identify an interface.
 *
 * The CID is also a unique number that looks just like an IID
 * and uniquely identifies an implementation
 * {7CB5B7A0-07D7-11d3-BDE2-000064657374}
 */

#define NS_SAMPLE_CID \
{ 0x7cb5b7a0, 0x7d7, 0x11d3, { 0xbd, 0xe2, 0x0, 0x0, 0x64, 0x65, 0x73, 0x74 } }

#define NS_SAMPLE_CONTRACTID "@mozilla.org/sample;1"


class nsSampleImpl MOZ_FINAL : public nsISample
{
public:
    nsSampleImpl();

    /**
     * This macro expands into a declaration of the nsISupports interface.
     * Every XPCOM component needs to implement nsISupports, as it acts
     * as the gateway to other interfaces this component implements.  You
     * could manually declare QueryInterface, AddRef, and Release instead
     * of using this macro, but why?
     */
    // nsISupports interface
    NS_DECL_ISUPPORTS

    /**
     * This macro is defined in the nsISample.h file, and is generated
     * automatically by the xpidl compiler.  It expands to
     * declarations of all of the methods required to implement the
     * interface.  xpidl will generate a NS_DECL_[INTERFACENAME] macro
     * for each interface that it processes.
     *
     * The methods of nsISample are discussed individually below, but
     * commented out (because this macro already defines them.)
     */
    NS_DECL_NSISAMPLE

    /**
     * The following is an explanation of how the interface header
     * file expands to for a c++ implementation. NS_DELC_NSISAMPLE
     * takes care of defining the right c++ implementation.
     *
     * The following if provided for more understanding.
     *
     * NS_IMETHOD expands to the standard XPCOM return type.  XPCOM methods
     * should never return any other type.  The return value is used
     * behind the scenes by the XPConnect runtime to figure out if the call
     * failed in any way.
     * These methods were generated by "attribute string Value" in 
     * nsISample.idl.  When reflected into JavaScript, XPCOM will use these
     * calls as Getter/Setter ops, so that they can be called transparently
     * as "sample.Value='foo';" and "var val = sample.Value"
     */
    /* NS_IMETHOD GetValue(char * *aValue); */
    /* NS_IMETHOD SetValue(char * aValue); */

    /**
     * The const came from the "in" specifier in nsISample.idl.  "in"
     * specifies that the value of this parameter is used only for input,
     * this method is not allowed to modify the contents of the buffer.
     */
    /* NS_IMETHOD WriteValue(const char *aPrefix); */

    /**
     * nsISample.idl specifies all of its string types as string, instead
     * of wstring (wide string), the Unicode type.  If the world were a
     * perfect place, all normal strings in XPCOM interfaces would be unicode.
     * If this type had been specified as wstring, it would appear as
     * PRUnichar * in C++, which is the NSPR type for unicode characters.
     */
    /* NS_IMETHOD Poke(const char* aValue); */

private:
    ~nsSampleImpl();

    char* mValue;
};

#endif
