/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.View;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class QtAndroidWebViewController {
    private final Activity m_activity;
    private final long m_id;
    private boolean m_hasLocationPermission;
    private WebView m_webView = null;
    private static final String TAG = "QtAndroidWebViewController";
    private final int INIT_STATE = 0;
    private final int STARTED_STATE = 1;
    private final int LOADING_STATE = 2;
    private final int FINISHED_STATE = 3;
    private volatile int m_loadingState = 0;
    private volatile int m_progress = 0;
    private volatile int m_frameCount = 0;
    private Method m_webViewOnResume = null;
    private Method m_webViewOnPause = null;
    private Method m_webSettingsSetDisplayZoomControls = null;
    private Method m_webViewEvaluateJavascript = null;
    private final long BLOCKING_TIMEOUT = 250L;

    private native void c_onPageFinished(long var1, String var3);

    private native void c_onPageStarted(long var1, String var3, Bitmap var4);

    private native void c_onProgressChanged(long var1, int var3);

    private native void c_onReceivedIcon(long var1, Bitmap var3);

    private native void c_onReceivedTitle(long var1, String var3);

    private native void c_onRunJavaScriptResult(long var1, long var3, String var5);

    private native void c_onReceivedError(long var1, int var3, String var4, String var5);

    private void resetLoadingState(int n) {
        this.m_progress = 0;
        this.m_frameCount = 0;
        this.m_loadingState = n;
    }

    public QtAndroidWebViewController(Activity activity, long l) {
        this.m_activity = activity;
        this.m_id = l;
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView = new WebView((Context)QtAndroidWebViewController.this.m_activity);
                QtAndroidWebViewController.this.m_hasLocationPermission = QtAndroidWebViewController.hasLocationPermission((View)QtAndroidWebViewController.this.m_webView);
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                if (Build.VERSION.SDK_INT > 10) {
                    try {
                        QtAndroidWebViewController.this.m_webViewOnResume = QtAndroidWebViewController.this.m_webView.getClass().getMethod("onResume", new Class[0]);
                        QtAndroidWebViewController.this.m_webViewOnPause = QtAndroidWebViewController.this.m_webView.getClass().getMethod("onPause", new Class[0]);
                        QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls = webSettings.getClass().getMethod("setDisplayZoomControls", Boolean.TYPE);
                        if (Build.VERSION.SDK_INT > 18) {
                            QtAndroidWebViewController.this.m_webViewEvaluateJavascript = QtAndroidWebViewController.this.m_webView.getClass().getMethod("evaluateJavascript", String.class, ValueCallback.class);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                webSettings.setGeolocationEnabled(QtAndroidWebViewController.this.m_hasLocationPermission);
                webSettings.setJavaScriptEnabled(true);
                if (QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls != null) {
                    try {
                        QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls.invoke((Object)webSettings, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                webSettings.setBuiltInZoomControls(true);
                webSettings.setPluginState(WebSettings.PluginState.ON);
                QtAndroidWebViewController.this.m_webView.setWebViewClient((WebViewClient)new QtAndroidWebViewClient());
                QtAndroidWebViewController.this.m_webView.setWebChromeClient((WebChromeClient)new QtAndroidWebChromeClient());
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadUrl(final String string) {
        if (string == null) {
            return;
        }
        this.resetLoadingState(1);
        this.c_onPageStarted(this.m_id, string, null);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadUrl(string);
            }
        });
    }

    public void loadData(final String string, final String string2, final String string3) {
        if (string == null) {
            return;
        }
        this.resetLoadingState(1);
        this.c_onPageStarted(this.m_id, null, null);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadData(string, string2, string3);
            }
        });
    }

    public void loadDataWithBaseURL(final String string, final String string2, final String string3, final String string4, final String string5) {
        if (string2 == null) {
            return;
        }
        this.resetLoadingState(1);
        this.c_onPageStarted(this.m_id, null, null);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadDataWithBaseURL(string, string2, string3, string4, string5);
            }
        });
    }

    public void goBack() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.goBack();
            }
        });
    }

    public boolean canGoBack() {
        final boolean[] blArray = new boolean[]{false};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                blArray[0] = QtAndroidWebViewController.this.m_webView.canGoBack();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    public void goForward() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.goForward();
            }
        });
    }

    public boolean canGoForward() {
        final boolean[] blArray = new boolean[]{false};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                blArray[0] = QtAndroidWebViewController.this.m_webView.canGoForward();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    public void stopLoading() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.stopLoading();
            }
        });
    }

    public void reload() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.reload();
            }
        });
    }

    public String getTitle() {
        final String[] stringArray = new String[]{""};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                stringArray[0] = QtAndroidWebViewController.this.m_webView.getTitle();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray[0];
    }

    public int getProgress() {
        return this.m_progress;
    }

    public boolean isLoading() {
        return this.m_loadingState == 2 || this.m_loadingState == 1 || this.m_progress > 0 && this.m_progress < 100;
    }

    public void runJavaScript(final String string, final long l) {
        if (string == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19 || this.m_webViewEvaluateJavascript == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewEvaluateJavascript.invoke((Object)QtAndroidWebViewController.this.m_webView, string, l == -1L ? null : new ValueCallback<String>(){

                        public void onReceiveValue(String string) {
                            QtAndroidWebViewController.this.c_onRunJavaScriptResult(QtAndroidWebViewController.this.m_id, l, string);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public String getUrl() {
        final String[] stringArray = new String[]{""};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                stringArray[0] = QtAndroidWebViewController.this.m_webView.getUrl();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray[0];
    }

    public WebView getWebView() {
        return this.m_webView;
    }

    public void onPause() {
        if (this.m_webViewOnPause == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewOnPause.invoke((Object)QtAndroidWebViewController.this.m_webView, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void onResume() {
        if (this.m_webViewOnResume == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewOnResume.invoke((Object)QtAndroidWebViewController.this.m_webView, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private static boolean hasLocationPermission(View view) {
        String string = view.getContext().getPackageName();
        PackageManager packageManager = view.getContext().getPackageManager();
        return packageManager.checkPermission("android.permission.ACCESS_FINE_LOCATION", string) == 0;
    }

    public void destroy() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.destroy();
            }
        });
    }

    private class QtAndroidWebChromeClient
    extends WebChromeClient {
        QtAndroidWebChromeClient() {
        }

        public void onProgressChanged(WebView webView, int n) {
            super.onProgressChanged(webView, n);
            QtAndroidWebViewController.this.m_progress = n;
            QtAndroidWebViewController.this.c_onProgressChanged(QtAndroidWebViewController.this.m_id, n);
            if (QtAndroidWebViewController.this.m_loadingState == 3 && QtAndroidWebViewController.this.m_progress == 100) {
                QtAndroidWebViewController.this.m_frameCount = 0;
                QtAndroidWebViewController.this.c_onPageFinished(QtAndroidWebViewController.this.m_id, webView.getUrl());
            }
        }

        public void onReceivedIcon(WebView webView, Bitmap bitmap) {
            super.onReceivedIcon(webView, bitmap);
            QtAndroidWebViewController.this.c_onReceivedIcon(QtAndroidWebViewController.this.m_id, bitmap);
        }

        public void onReceivedTitle(WebView webView, String string) {
            super.onReceivedTitle(webView, string);
            QtAndroidWebViewController.this.c_onReceivedTitle(QtAndroidWebViewController.this.m_id, string);
        }

        public void onGeolocationPermissionsShowPrompt(String string, GeolocationPermissions.Callback callback) {
            callback.invoke(string, QtAndroidWebViewController.this.m_hasLocationPermission, false);
        }
    }

    private class QtAndroidWebViewClient
    extends WebViewClient {
        QtAndroidWebViewClient() {
        }

        public void onLoadResource(WebView webView, String string) {
            super.onLoadResource(webView, string);
        }

        public void onPageFinished(WebView webView, String string) {
            super.onPageFinished(webView, string);
            QtAndroidWebViewController.this.m_loadingState = 3;
            if (QtAndroidWebViewController.this.m_progress != 100) {
                return;
            }
            QtAndroidWebViewController.this.m_frameCount = 0;
            QtAndroidWebViewController.this.c_onPageFinished(QtAndroidWebViewController.this.m_id, string);
        }

        public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
            super.onPageStarted(webView, string, bitmap);
            if (++QtAndroidWebViewController.this.m_frameCount == 1) {
                QtAndroidWebViewController.this.m_loadingState = 2;
                QtAndroidWebViewController.this.c_onPageStarted(QtAndroidWebViewController.this.m_id, string, bitmap);
            }
        }

        public void onReceivedError(WebView webView, int n, String string, String string2) {
            super.onReceivedError(webView, n, string, string2);
            QtAndroidWebViewController.this.resetLoadingState(0);
            QtAndroidWebViewController.this.c_onReceivedError(QtAndroidWebViewController.this.m_id, n, string, string2);
        }
    }
}

