/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.info.MethodOptimizationInfo;

public class SimpleEnumArrayPropagator
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final ValueFactory valueFactory = new ParticularValueFactory();
    private Value array;

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.methodsAccept(new MemberDescriptorFilter("()[I", (MemberVisitor)this));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programClass.fieldsAccept(new MemberDescriptorFilter("[I", (MemberVisitor)this));
        if (this.array != null) {
            ReferenceValue referenceValue = this.valueFactory.createArrayReferenceValue("I", null, this.array.referenceValue().arrayLength(this.valueFactory));
            SimpleEnumArrayPropagator.setMethodReturnValue(programMethod, referenceValue);
            this.array = null;
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.array = StoringInvocationUnit.getFieldValue(programField);
    }

    private static void setMethodReturnValue(Method method, Value value) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setReturnValue(value);
        }
    }
}

