/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class OptimizeCalls
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ImmutableList<CallGraphCompilerPass> passes;
    private final boolean considerExterns;

    private OptimizeCalls(AbstractCompiler compiler, ImmutableList<CallGraphCompilerPass> passes, boolean considerExterns) {
        this.compiler = compiler;
        this.passes = passes;
        this.considerExterns = considerExterns;
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED);
        if (this.passes.isEmpty()) {
            return;
        }
        ReferenceMap references = new ReferenceMap();
        NodeTraversal.traverseRoots(this.compiler, new ReferenceMapBuildingCallback(references), externs, root);
        this.eliminateAccessorsFrom(references);
        for (CallGraphCompilerPass pass : this.passes) {
            pass.process(externs, root, references);
        }
    }

    private void eliminateAccessorsFrom(ReferenceMap references) {
        references.props.keySet().removeAll(this.compiler.getAccessorSummary().getAccessors().keySet());
    }

    private static Set<String> safeSet(@Nullable Set<String> set) {
        return set != null ? ImmutableSet.copyOf(set) : ImmutableSet.of();
    }

    static boolean mayBeOptimizableName(AbstractCompiler compiler, String name) {
        if (compiler.getCodingConvention().isExported(name)) {
            return false;
        }
        return !name.equals("JSCompiler_renameProperty") && !name.equals("inherits") && !name.equals("$jscomp$inherits") && !name.equals("goog$inherits");
    }

    static boolean isAllowedReference(Node n) {
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                return parent.getSecondChild() == n;
            }
            case INSTANCEOF: 
            case TYPEOF: 
            case IN: {
                return true;
            }
            case GETPROP: 
            case GETELEM: {
                Node grandparent = parent.getParent();
                return n != parent.getFirstChild() || grandparent == null || !grandparent.isCall();
            }
        }
        return NodeUtil.isNameDeclaration(parent) && !n.hasChildren();
    }

    private final class ReferenceMapBuildingCallback
    implements NodeTraversal.ScopedCallback {
        final Set<String> externProps;
        final ReferenceMap references;
        private Scope globalScope;

        public ReferenceMapBuildingCallback(ReferenceMap references) {
            this.externProps = OptimizeCalls.safeSet(OptimizeCalls.this.compiler.getExternProperties());
            this.references = references;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node unused) {
            switch (n.getToken()) {
                case NAME: {
                    this.maybeAddNameReference(n);
                    break;
                }
                case GETPROP: {
                    this.maybeAddPropReference(n.getLastChild().getString(), n);
                    break;
                }
                case STRING_KEY: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case MEMBER_FUNCTION_DEF: {
                    if (n.isQuotedString()) break;
                    this.maybeAddPropReference(n.getString(), n);
                    break;
                }
            }
        }

        private void maybeAddNameReference(Node n) {
            String name = n.getString();
            Var var = (Var)this.globalScope.getSlot(name);
            if (var != null && (OptimizeCalls.this.considerExterns || !var.isExtern())) {
                this.references.addNameReference(name, n);
            }
        }

        private void maybeAddPropReference(String name, Node n) {
            if (OptimizeCalls.this.considerExterns || !this.externProps.contains(name)) {
                this.references.addPropReference(name, n);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isFromExterns()) {
                return OptimizeCalls.this.considerExterns && t.inGlobalScope();
            }
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                this.globalScope = t.getScope();
                this.references.globalScope = this.globalScope;
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }

    static class ReferenceMap {
        private Scope globalScope;
        private final LinkedHashMap<String, ArrayList<Node>> names = new LinkedHashMap();
        private final LinkedHashMap<String, ArrayList<Node>> props = new LinkedHashMap();

        ReferenceMap() {
        }

        private void addReference(LinkedHashMap<String, ArrayList<Node>> data, String name, Node n) {
            ArrayList<Node> refs = data.get(name);
            if (refs == null) {
                refs = new ArrayList();
                data.put(name, refs);
            }
            refs.add(n);
        }

        void addNameReference(String name, Node n) {
            this.addReference(this.names, name, n);
        }

        void addPropReference(String name, Node n) {
            this.addReference(this.props, name, n);
        }

        Scope getGlobalScope() {
            return this.globalScope;
        }

        Iterable<Map.Entry<String, ArrayList<Node>>> getNameReferences() {
            return this.names.entrySet();
        }

        Iterable<Map.Entry<String, ArrayList<Node>>> getPropReferences() {
            return this.props.entrySet();
        }

        static ImmutableListMultimap<Node, Node> getFunctionNodes(List<Node> definitionSites) {
            ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
            for (Node def : definitionSites) {
                result.putAll((Object)def, ReferenceMap.definitionFunctionNodesFor(def));
            }
            return result.build();
        }

        private static ImmutableList<Node> definitionFunctionNodesFor(Node definitionSite) {
            if (definitionSite.isGetterDef() || definitionSite.isSetterDef()) {
                return ImmutableList.of();
            }
            Node parent = definitionSite.getParent();
            if (parent == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder<Node> fns = ImmutableList.builder();
            switch (parent.getToken()) {
                case FUNCTION: {
                    fns.add((Object)parent);
                    break;
                }
                case CLASS_MEMBERS: {
                    Preconditions.checkArgument(definitionSite.isMemberFunctionDef(), definitionSite);
                    fns.add((Object)definitionSite.getLastChild());
                    break;
                }
                case OBJECTLIT: {
                    Preconditions.checkArgument(definitionSite.isStringKey() || definitionSite.isMemberFunctionDef(), definitionSite);
                    ReferenceMap.addValueFunctionNodes(fns, definitionSite.getLastChild());
                    break;
                }
                case ASSIGN: {
                    Node target = parent.getFirstChild();
                    Node value = parent.getLastChild();
                    if (definitionSite != target) break;
                    ReferenceMap.addValueFunctionNodes(fns, value);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (!definitionSite.isName() || !definitionSite.hasChildren()) break;
                    ReferenceMap.addValueFunctionNodes(fns, definitionSite.getFirstChild());
                    break;
                }
            }
            return fns.build();
        }

        private static void addValueFunctionNodes(ImmutableList.Builder<Node> fns, Node n) {
            switch (n.getToken()) {
                case FUNCTION: {
                    fns.add((Object)n);
                    break;
                }
                case HOOK: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getSecondChild());
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
                case OR: 
                case AND: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getFirstChild());
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
                case CAST: 
                case COMMA: {
                    ReferenceMap.addValueFunctionNodes(fns, n.getLastChild());
                    break;
                }
            }
        }

        static boolean isCallOrNewTarget(Node n) {
            return ReferenceMap.isCallTarget(n) || ReferenceMap.isNewTarget(n);
        }

        static boolean isCallTarget(Node n) {
            Node parent = n.getParent();
            return parent.getFirstChild() == n && parent.isCall() || parent.isGetProp() && parent.getParent().isCall() && parent.getLastChild().getString().equals("call");
        }

        static boolean isNewTarget(Node n) {
            Node parent = n.getParent();
            return parent.isNew() && parent.getFirstChild() == n;
        }

        static Node getCallOrNewNodeForTarget(Node n) {
            Node maybeCall = n.getParent();
            Preconditions.checkState(n.isFirstChildOf(maybeCall), "%s\n\n%s", (Object)maybeCall, (Object)n);
            if (NodeUtil.isCallOrNew(maybeCall)) {
                return maybeCall;
            }
            Node child = maybeCall;
            maybeCall = child.getParent();
            Preconditions.checkState(child.isGetProp(), child);
            Preconditions.checkState(maybeCall.isCall(), maybeCall);
            Preconditions.checkState(child.isFirstChildOf(maybeCall), "%s\n\n%s", (Object)maybeCall, (Object)child);
            return maybeCall;
        }

        static Node getFirstArgumentForCallOrNewOrDotCall(Node n) {
            return ReferenceMap.getArgumentForCallOrNewOrDotCall(n, 0);
        }

        static Node getArgumentForCallOrNewOrDotCall(Node n, int index) {
            int adjustedIndex = index;
            Node parent = n.getParent();
            if (!parent.isCall() && !parent.isNew() && NodeUtil.isFunctionObjectCall(parent = parent.getParent())) {
                ++adjustedIndex;
            }
            return NodeUtil.getArgumentForCallOrNew(parent, adjustedIndex);
        }

        static boolean isSimpleAssignmentTarget(Node n) {
            Node parent = n.getParent();
            return parent.isAssign() && n == parent.getFirstChild();
        }
    }

    static final class Builder {
        private AbstractCompiler compiler;
        private ImmutableList.Builder<CallGraphCompilerPass> passes = ImmutableList.builder();
        @Nullable
        private Boolean considerExterns;

        public Builder setCompiler(AbstractCompiler compiler) {
            this.compiler = compiler;
            return this;
        }

        public Builder setConsiderExterns(boolean b) {
            this.considerExterns = b;
            return this;
        }

        public Builder addPass(CallGraphCompilerPass pass) {
            this.passes.add((Object)pass);
            return this;
        }

        public OptimizeCalls build() {
            Preconditions.checkNotNull(this.compiler);
            Preconditions.checkNotNull(this.considerExterns);
            return new OptimizeCalls(this.compiler, (ImmutableList)this.passes.build(), this.considerExterns);
        }

        private Builder() {
        }
    }

    static interface CallGraphCompilerPass {
        public void process(Node var1, Node var2, ReferenceMap var3);
    }
}

