/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebTouchAction_h
#define WebTouchAction_h

namespace blink {

// Flags for permitted touch actions, specified in
// http://w3c.github.io/pointerevents/#the-touch-action-css-property.
enum WebTouchAction {
  WebTouchActionNone = 0x0,
  WebTouchActionPanLeft = 0x1,
  WebTouchActionPanRight = 0x2,
  WebTouchActionPanX = WebTouchActionPanLeft | WebTouchActionPanRight,
  WebTouchActionPanUp = 0x4,
  WebTouchActionPanDown = 0x8,
  WebTouchActionPanY = WebTouchActionPanUp | WebTouchActionPanDown,
  WebTouchActionPan = WebTouchActionPanX | WebTouchActionPanY,
  WebTouchActionPinchZoom = 0x10,
  WebTouchActionManipulation = WebTouchActionPan | WebTouchActionPinchZoom,
  WebTouchActionDoubleTapZoom = 0x20,
  WebTouchActionAuto = WebTouchActionManipulation | WebTouchActionDoubleTapZoom
};
inline WebTouchAction operator|(WebTouchAction a, WebTouchAction b) {
  return static_cast<WebTouchAction>(int(a) | int(b));
}
inline WebTouchAction& operator|=(WebTouchAction& a, WebTouchAction b) {
  return a = a | b;
}
inline WebTouchAction operator&(WebTouchAction a, WebTouchAction b) {
  return static_cast<WebTouchAction>(int(a) & int(b));
}
inline WebTouchAction& operator&=(WebTouchAction& a, WebTouchAction b) {
  return a = a & b;
}

}  // namespace blink

#endif
