/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Set;

public class RedundantImportCheck
extends Check {
    public static final String MSG_LANG = "import.lang";
    public static final String MSG_SAME = "import.same";
    public static final String MSG_DUPLICATE = "import.duplicate";
    private String pkgName;
    private final Set<FullIdent> imports = Sets.newHashSet();
    private final Set<FullIdent> staticImports = Sets.newHashSet();

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.staticImports.clear();
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.pkgName = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling()).getText();
        } else if (ast.getType() == 30) {
            FullIdent imp = FullIdent.createFullIdentBelow(ast);
            if (RedundantImportCheck.fromPackage(imp.getText(), "java.lang")) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_LANG, imp.getText());
            } else if (RedundantImportCheck.fromPackage(imp.getText(), this.pkgName)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_SAME, imp.getText());
            }
            for (FullIdent full : this.imports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText());
            }
            this.imports.add(imp);
        } else {
            FullIdent imp = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling());
            for (FullIdent full : this.staticImports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText());
            }
            this.staticImports.add(imp);
        }
    }

    private static boolean fromPackage(String importName, String pkg) {
        boolean retVal = false;
        if (pkg == null) {
            retVal = importName.indexOf(46) == -1;
        } else {
            int index = importName.lastIndexOf(46);
            if (index != -1) {
                String front = importName.substring(0, index);
                retVal = front.equals(pkg);
            }
        }
        return retVal;
    }
}

