include_guard(DIRECTORY)


# Use a function to hide all the temporary variables we use so they don't leak
# out into the consuming scope
function(__qt_internal_add_static_plugins_once)
    set(_module_target "Qt6::3DRender")
    set(_qt_plugins "")

    # Properties can't be set on aliased targets, so make sure to unalias the target. This is needed
    # when Qt examples are built as part of the Qt build itself.
    get_target_property(_aliased_target ${_module_target} ALIASED_TARGET)
    if(_aliased_target)
        set(_module_target ${_aliased_target})
    endif()

    # Include all PluginConfig.cmake files and update the _qt_plugins and QT_PLUGINS property of
    # the module. The underscored version is the one we will use going forward to have compatibility
    # with INTERFACE libraries. QT_PLUGINS is now deprecated and only kept so that we don't break
    # existing projects using it (like CMake itself).
    file(GLOB _qt_plugin_config_files "${CMAKE_CURRENT_LIST_DIR}/Qt6*PluginConfig.cmake")
    foreach(_config_file ${_qt_plugin_config_files})
        string(REGEX REPLACE "^.*/Qt6(.*Plugin)Config.cmake$" "\\1" _qt_plugin "${_config_file}")
        include("${_config_file}")
        if(TARGET "Qt6::${_qt_plugin}")
            list(APPEND _qt_plugins ${_qt_plugin})
        endif()
    endforeach()
    set_property(TARGET ${_module_target} PROPERTY _qt_plugins ${_qt_plugins})

    # TODO: Deprecated. Remove in Qt 7.
    set_property(TARGET ${_module_target} PROPERTY QT_PLUGINS ${_qt_plugins})

    get_target_property(_have_added_plugins_already ${_module_target} __qt_internal_plugins_added)
    if(_have_added_plugins_already)
        return()
    endif()

    foreach(plugin_target ${_qt_plugins})
        __qt_internal_plugin_get_plugin_type("${plugin_target}" __has_plugin_type __plugin_type)
        if(NOT __has_plugin_type)
            continue()
        endif()

        __qt_internal_plugin_has_class_name("${plugin_target}" __has_class_name)
        if(NOT __has_class_name)
            continue()
        endif()

        list(APPEND "QT_ALL_PLUGINS_FOUND_BY_FIND_PACKAGE_${__plugin_type}" "${plugin_target}")

        __qt_internal_add_static_plugin_linkage("${plugin_target}" "${_module_target}")
        __qt_internal_add_static_plugin_import_macro(
            "${plugin_target}" ${_module_target} "3DRender")
    endforeach()

    set("QT_ALL_PLUGINS_FOUND_BY_FIND_PACKAGE_${__plugin_type}"
        "${QT_ALL_PLUGINS_FOUND_BY_FIND_PACKAGE_${__plugin_type}}"
        PARENT_SCOPE
    )

    set_target_properties(${_module_target} PROPERTIES __qt_internal_plugins_added TRUE)
endfunction()

if(NOT OFF AND NOT QT_NO_CREATE_TARGETS)
    __qt_internal_add_static_plugins_once()
endif()
