/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.qtproject.qt5.android.QtNative;

public class QtSurface
extends SurfaceView
implements SurfaceHolder.Callback {
    private GestureDetector m_gestureDetector;
    private Object m_accessibilityDelegate = null;

    public QtSurface(Context context, int n, boolean bl, int n2) {
        super(context);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.setZOrderMediaOverlay(bl);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        if (n2 == 16) {
            this.getHolder().setFormat(4);
        } else {
            this.getHolder().setFormat(1);
        }
        this.setId(n);
        this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                QtNative.longPress(QtSurface.this.getId(), (int)motionEvent.getX(), (int)motionEvent.getY());
            }
        });
        this.m_gestureDetector.setIsLongpressEnabled(true);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (n2 < 1 || n3 < 1) {
            return;
        }
        QtNative.setSurface(this.getId(), surfaceHolder.getSurface(), n2, n3);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        QtNative.setSurface(this.getId(), null, 0, 0);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        QtNative.sendTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        QtNative.sendTrackballEvent(motionEvent, this.getId());
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        QtNative.sendGenericMotionEvent(motionEvent, this.getId());
        return true;
    }
}

