############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: http://www.qt.io/licensing/
##
## This file is part of the provisioning scripts of the Qt Toolkit.
##
## $QT_BEGIN_LICENSE:LGPL21$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see http://www.qt.io/terms-conditions. For further
## information use the contact form at http://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 2.1 or version 3 as published by the Free
## Software Foundation and appearing in the file LICENSE.LGPLv21 and
## LICENSE.LGPLv3 included in the packaging of this file. Please review the
## following information to ensure the GNU Lesser General Public License
## requirements will be met: https://www.gnu.org/licenses/lgpl.html and
## http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
##
## As a special exception, The Qt Company gives you certain additional
## rights. These rights are described in The Qt Company LGPL Exception
## version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
##
## $QT_END_LICENSE$
##
#############################################################################
. "$PSScriptRoot\..\common\helpers.ps1"

# This script will install Visual Studio 2017 Build Tools
# https://www.visualstudio.com/downloads/#build-tools-for-visual-studio-2017

$version = "2017_version_15.0"
$url_cache = "http://ci-files01-hki.intra.qt.io/input/windows/mu_build_tools_for_visual_studio_" + $version + "_x86_x64_10254482.exe"
$sha1 = "a31e099e5114fef80a21654689e6864afc544a16"
$msvcPackage = "C:\Windows\Temp\$version.exe"

Download $url_cache $url_cache $msvcPackage
Verify-Checksum $msvcPackage $sha1
cmd /c "$msvcPackage --all --passive --wait"
echo "Cleaning $msvcPackage.."
Remove-Item -Recurse -Force "$msvcPackage"
echo "Visual Studio Build Tools = $version" >> ~\versions.txt
