/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.chromium.devtools.jsdoc.FileCheckerCallable;
import org.chromium.devtools.jsdoc.ValidatorContext;

public class JsDocValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray) {
        int n = Math.min(stringArray.length, Runtime.getRuntime().availableProcessors());
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        try {
            this.runWithExecutor(stringArray, executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runWithExecutor(String[] stringArray, ExecutorService executorService) {
        void future;
        ArrayList<Future<ValidatorContext>> arrayList = new ArrayList<Future<ValidatorContext>>(stringArray.length);
        Object arrayList2 = stringArray;
        int n = ((String[])arrayList2).length;
        boolean bl = false;
        while (future < n) {
            String n2 = arrayList2[future];
            arrayList.add(executorService.submit(new FileCheckerCallable(n2)));
            ++future;
        }
        arrayList2 = new ArrayList(stringArray.length);
        for (Future object3 : arrayList) {
            try {
                ValidatorContext validatorContext = (ValidatorContext)object3.get();
                if (validatorContext == null) continue;
                arrayList2.add(validatorContext);
            }
            catch (InterruptedException | ExecutionException exception) {
                String string = String.valueOf(exception.getMessage());
                System.err.println(string.length() != 0 ? "ERROR - ".concat(string) : new String("ERROR - "));
            }
        }
        int n2 = 0;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ValidatorContext validatorContext = (ValidatorContext)iterator.next();
            n2 += validatorContext.getValidationResult().size();
        }
        ArrayList<LogEntry> arrayList3 = new ArrayList<LogEntry>(n2);
        Iterator iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            Object object = (ValidatorContext)iterator2.next();
            SortedSet<ValidatorContext.MessageRecord> sortedSet = ((ValidatorContext)object).getValidationResult();
            for (ValidatorContext.MessageRecord messageRecord : sortedSet) {
                arrayList3.add(new LogEntry(((ValidatorContext)object).scriptFileName, messageRecord));
            }
        }
        Collections.sort(arrayList3);
        for (Object object : arrayList3) {
            System.err.println(((LogEntry)object).record.text);
        }
        if (!arrayList3.isEmpty()) {
            int n3 = arrayList3.size();
            System.err.println(new StringBuilder(25).append("Total errors: ").append(n3).toString());
        }
    }

    public static void main(String[] stringArray) {
        new JsDocValidator().run(stringArray);
    }

    private static class LogEntry
    implements Comparable<LogEntry> {
        private final String fileName;
        private final ValidatorContext.MessageRecord record;

        LogEntry(String string, ValidatorContext.MessageRecord messageRecord) {
            this.fileName = string;
            this.record = messageRecord;
        }

        @Override
        public int compareTo(LogEntry logEntry) {
            int n = this.fileName.compareTo(logEntry.fileName);
            if (n != 0) {
                return n;
            }
            return Integer.compare(this.record.position, logEntry.record.position);
        }

        public int hashCode() {
            return 17 + this.fileName.hashCode() * 3 + this.record.hashCode() * 5;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)object;
            if (this.fileName != logEntry.fileName && this.fileName != null && !this.fileName.equals(logEntry.fileName)) {
                return false;
            }
            if (this.record == logEntry.record) {
                return true;
            }
            if (this.record != null) {
                if (logEntry.record == null) {
                    return false;
                }
                return this.record.position == logEntry.record.position;
            }
            return false;
        }
    }
}

