// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by transport_security_state_static_generate.go

#ifndef NET_HTTP_TRANSPORT_SECURITY_STATE_STATIC_H_
#define NET_HTTP_TRANSPORT_SECURITY_STATE_STATIC_H_

// These are SubjectPublicKeyInfo hashes for public key pinning. The
// hashes are SHA1 digests.

static const char kSPKIHash_TestSPKI[] =
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

static const char kSPKIHash_VeriSignClass3[] =
    "\xe2\x7f\x7b\xd8\x77\xd5\xdf\x9e\x0a\x3f"
    "\x9e\xb4\xcb\x0e\x2e\xa9\xef\xdb\x69\x77";

static const char kSPKIHash_VeriSignClass3_G3[] =
    "\x22\xf1\x9e\x2e\xc6\xea\xcc\xfc\x5d\x23"
    "\x46\xf4\xc2\xe8\xf6\xc5\x54\xdd\x5e\x07";

static const char kSPKIHash_GoogleBackup2048[] =
    "\xbe\xae\xce\xca\x34\xa7\xa8\xe7\x28\xf6"
    "\x7c\x8c\x08\x31\x9d\xcb\xbe\xde\x8a\x33";

static const char kSPKIHash_GoogleG2[] =
    "\x43\xda\xd6\x30\xee\x53\xf8\xa9\x80\xca"
    "\x6e\xfd\x85\xf4\x6a\xa3\x79\x90\xe0\xea";

static const char kSPKIHash_GeoTrustGlobal[] =
    "\xc0\x7a\x98\x68\x8d\x89\xfb\xab\x05\x64"
    "\x0c\x11\x7d\xaa\x7d\x65\xb8\xca\xcc\x4e";

static const char kSPKIHash_GeoTrustPrimary[] =
    "\xb0\x19\x89\xe7\xef\xfb\x4a\xaf\xcb\x14"
    "\x8f\x58\x46\x39\x76\x22\x41\x50\xe1\xba";

static const char kSPKIHash_RapidSSL[] =
    "\xa3\x93\x99\xc4\x04\xc3\xb2\x09\xb0\x81"
    "\xc2\x1f\x21\x62\x27\x78\xc2\x74\x8e\x4c";

static const char kSPKIHash_DigiCertEVRoot[] =
    "\x83\x31\x7e\x62\x85\x42\x53\xd6\xd7\x78"
    "\x31\x90\xec\x91\x90\x56\xe9\x91\xb9\xe3";

static const char kSPKIHash_DigiCertAssuredIDRoot[] =
    "\x68\x33\x0e\x61\x35\x85\x21\x59\x29\x83"
    "\xa3\xc8\xd2\xd2\xe1\x40\x6e\x7a\xb3\xc1";

static const char kSPKIHash_DigiCertGlobalRoot[] =
    "\xd5\x2e\x13\xc1\xab\xe3\x49\xda\xe8\xb4"
    "\x95\x94\xef\x7c\x38\x43\x60\x64\x66\xbd";

static const char kSPKIHash_Tor1[] =
    "\x8e\xe3\x71\x49\x3b\xfd\x50\x03\x66\xa4"
    "\x2f\x64\x17\x91\x8a\xa6\x65\x8d\xc7\x76";

static const char kSPKIHash_Tor2[] =
    "\x96\x26\xb8\xde\x53\xe8\x97\x34\x8f\x54"
    "\x8a\xb7\xe0\x3c\x39\xee\xe6\x1c\x2c\x3f";

static const char kSPKIHash_Tor3[] =
    "\xaf\x31\x32\x40\x82\x8e\x87\xbe\xe3\xf3"
    "\xb9\xf9\x6e\x35\x94\x36\x0b\x97\x17\xc6";

static const char kSPKIHash_VeriSignClass1[] =
    "\x23\x43\xd1\x48\xa2\x55\x89\x9b\x94\x7d"
    "\x46\x1a\x79\x7e\xc0\x4c\xfe\xd1\x70\xb7";

static const char kSPKIHash_VeriSignClass3_G4[] =
    "\xed\x66\x31\x35\xd3\x1b\xd4\xec\xa6\x14"
    "\xc4\x29\xe3\x19\x06\x9f\x94\xc1\x26\x50";

static const char kSPKIHash_VeriSignClass4_G3[] =
    "\x3c\x03\x43\x68\x68\x95\x1c\xf3\x69\x2a"
    "\xb8\xb4\x26\xda\xba\x8f\xe9\x22\xe5\xbd";

static const char kSPKIHash_VeriSignClass1_G3[] =
    "\x55\x19\xb2\x78\xac\xb2\x81\xd7\xed\xa7"
    "\xab\xc1\x83\x99\xc3\xbb\x69\x04\x24\xb5";

static const char kSPKIHash_VeriSignClass2_G3[] =
    "\x5a\xbe\xc5\x75\xdc\xae\xf3\xb0\x8e\x27"
    "\x19\x43\xfc\x7f\x25\x0c\x3d\xf6\x61\xe3";

static const char kSPKIHash_VeriSignClass3_G2[] =
    "\x1a\x21\xb4\x95\x2b\x62\x93\xce\x18\xb3"
    "\x65\xec\x9c\x0e\x93\x4c\xb3\x81\xe6\xd4";

static const char kSPKIHash_VeriSignClass2_G2[] =
    "\x12\x37\xba\x45\x17\xee\xad\x29\x26\xfd"
    "\xc1\xcd\xfe\xbe\xed\xf2\xde\xd9\x14\x5c";

static const char kSPKIHash_VeriSignClass3_G5[] =
    "\xb1\x81\x08\x1a\x19\xa4\xc0\x94\x1f\xfa"
    "\xe8\x95\x28\xc1\x24\xc9\x9b\x34\xac\xc7";

static const char kSPKIHash_VeriSignUniversal[] =
    "\xbb\xc2\x3e\x29\x0b\xb3\x28\x77\x1d\xad"
    "\x3e\xa2\x4d\xbd\xf4\x23\xbd\x06\xb0\x3d";

static const char kSPKIHash_Twitter1[] =
    "\x56\xfe\xf3\xc2\x14\x7d\x4e\xd3\x88\x37"
    "\xfd\xbd\x30\x52\x38\x72\x01\xe5\x77\x8d";

static const char kSPKIHash_GeoTrustGlobal2[] =
    "\x71\x38\x36\xf2\x02\x31\x53\x47\x2b\x6e"
    "\xba\x65\x46\xa9\x10\x15\x58\x20\x05\x09";

static const char kSPKIHash_GeoTrustUniversal[] =
    "\x87\xe8\x5b\x63\x53\xc6\x23\xa3\x12\x8c"
    "\xb0\xff\xbb\xf5\x51\xfe\x59\x80\x0e\x22";

static const char kSPKIHash_GeoTrustUniversal2[] =
    "\x5e\x4f\x53\x86\x85\xdd\x4f\x9e\xca\x5f"
    "\xdc\x0d\x45\x6f\x7d\x51\xb1\xdc\x9b\x7b";

static const char kSPKIHash_GeoTrustPrimary_G2[] =
    "\xbd\xbe\xa7\x1b\xab\x71\x57\xf9\xe4\x75"
    "\xd9\x54\xd2\xb7\x27\x80\x1a\x82\x26\x82";

static const char kSPKIHash_GeoTrustPrimary_G3[] =
    "\x9c\xa9\x8d\x00\xaf\x74\x0d\xdd\x81\x80"
    "\xd2\x13\x45\xa5\x8b\x8f\x2e\x94\x38\xd6";

static const char kSPKIHash_Entrust_2048[] =
    "\x55\xe4\x81\xd1\x11\x80\xbe\xd8\x89\xb9"
    "\x08\xa3\x31\xf9\xa1\x24\x09\x16\xb9\x70";

static const char kSPKIHash_Entrust_EV[] =
    "\xba\x42\xb0\x81\x88\x53\x88\x1d\x86\x63"
    "\xbd\x4c\xc0\x5e\x08\xfe\xea\x6e\xbb\x77";

static const char kSPKIHash_Entrust_G2[] =
    "\xab\x30\xd3\xaf\x4b\xd8\xf1\x6b\x58\x69"
    "\xee\x45\x69\x29\xda\x84\xb8\x73\x94\x88";

static const char kSPKIHash_Entrust_SSL[] =
    "\xf0\x17\x62\x13\x55\x3d\xb3\xff\x0a\x00"
    "\x6b\xfb\x50\x84\x97\xf3\xed\x62\xd0\x1a";

static const char kSPKIHash_AAACertificateServices[] =
    "\xc4\x30\x28\xc5\xd3\xe3\x08\x0c\x10\x44"
    "\x8b\x2c\x77\xba\x24\x53\x97\x60\xbb\xf9";

static const char kSPKIHash_AddTrustClass1CARoot[] =
    "\x8b\xdb\xd7\xcc\xa0\x68\x53\x42\x16\xf4"
    "\xc1\x2b\x25\x44\xfc\x02\x9c\xa5\x8b\x47";

static const char kSPKIHash_AddTrustExternalCARoot[] =
    "\x4f\x9c\x7d\x21\x79\x9c\xad\x0e\xd8\xb9"
    "\x0c\x57\x9f\x1a\x02\x99\xe7\x90\xf3\x87";

static const char kSPKIHash_AddTrustPublicCARoot[] =
    "\xa8\x57\x65\xd6\xe8\x32\xc8\xc5\x19\x63"
    "\x73\x5a\x9a\x17\x74\x3a\x81\xdf\xee\x2e";

static const char kSPKIHash_AddTrustQualifiedCARoot[] =
    "\xbc\xe4\xb7\x23\x12\x55\x98\xe5\x63\x41"
    "\x19\x1c\x50\xe4\xb6\x47\xc2\x76\x05\xd7";

static const char kSPKIHash_COMODOCertificationAuthority[] =
    "\x11\xe4\x91\xd1\xc9\xe4\xc0\xeb\x9a\xce"
    "\xcf\x73\x54\x5d\xe1\xf1\xa8\x30\x3e\xc3";

static const char kSPKIHash_SecureCertificateServices[] =
    "\x3c\xb4\x1a\x84\x2e\xf5\x5c\xf2\x1a\x3d"
    "\xa5\x4a\xc8\xd1\xbe\x39\x08\x76\x37\xbc";

static const char kSPKIHash_TrustedCertificateServices[] =
    "\xfe\x72\xc8\xeb\xbf\x0c\x2f\xbb\x0e\x26"
    "\x13\x93\x93\x3c\x2c\xa9\x8d\xdc\x24\x94";

static const char kSPKIHash_UTNDATACorpSGC[] =
    "\x53\x32\xd1\xb3\xcf\x7f\xfa\xe0\xf1\xa0"
    "\x5d\x85\x4e\x92\xd2\x9e\x45\x1d\xb4\x4f";

static const char kSPKIHash_UTNUSERFirstClientAuthenticationandEmail[] =
    "\x89\x82\x67\x7d\xc4\x9d\x26\x70\x00\x4b"
    "\xb4\x50\x48\x7c\xde\x3d\xae\x04\x6e\x7d";

static const char kSPKIHash_UTNUSERFirstHardware[] =
    "\xa1\x72\x5f\x26\x1b\x28\x98\x43\x95\x5d"
    "\x07\x37\xd5\x85\x96\x9d\x4b\xd2\xc3\x45";

static const char kSPKIHash_UTNUSERFirstObject[] =
    "\xda\xed\x64\x74\x14\x9c\x14\x3c\xab\xdd"
    "\x99\xa9\xbd\x5b\x28\x4d\x8b\x3c\xc9\xd8";

static const char kSPKIHash_GTECyberTrustGlobalRoot[] =
    "\x59\x79\x12\xde\x61\x75\xd6\x6f\xc4\x23"
    "\xb7\x77\x13\x74\xc7\x96\xde\x6f\x88\x72";

static const char kSPKIHash_BaltimoreCyberTrustRoot[] =
    "\x30\xa4\xe6\x4f\xde\x76\x8a\xfc\xed\x5a"
    "\x90\x84\x28\x30\x46\x79\x2c\x29\x15\x70";

static const char kSPKIHash_Tor2web[] =
    "\x19\xe5\xb5\x87\x1b\xd4\x83\x2e\xc8\xf5"
    "\x94\x97\xfe\xc6\x5e\xfb\x48\xe3\x33\xb1";

static const char kSPKIHash_AlphaSSL_G2[] =
    "\xe5\x24\xe9\x8e\x31\x7d\xc8\xfc\xad\x90"
    "\x53\x7c\x91\xe7\x0d\xa4\x70\x93\x90\x5f";

static const char kSPKIHash_CryptoCat1[] =
    "\x4c\x87\xce\x85\x2c\xf4\xc0\x4d\x67\xa9"
    "\xe0\xec\x51\x0c\x7f\x3b\x14\xb3\xe9\xc9";

static const char kSPKIHash_Libertylavabitcom[] =
    "\x41\xbb\x3b\x8b\xc7\xcf\x3d\x13\x3f\x17"
    "\xb3\x25\x7e\xe4\x03\xca\x8a\x5c\x6d\x36";

static const char kSPKIHash_GlobalSignRootCA[] =
    "\x87\xdb\xd4\x5f\xb0\x92\x8d\x4e\x1d\xf8"
    "\x15\x67\xe7\xf2\xab\xaf\xd6\x2b\x67\x75";

static const char kSPKIHash_GlobalSignRootCA_R2[] =
    "\xa5\x06\x8a\x78\xcf\x84\xbd\x74\x32\xdd"
    "\x58\xf9\x65\xeb\x3a\x55\xe7\xc7\x80\xdc";

static const char kSPKIHash_GlobalSignRootCA_R3[] =
    "\xf7\x93\x19\xef\xdf\xc1\xf5\x20\xfb\xac"
    "\x85\x55\x2c\xf2\xd2\x8f\x5a\xb9\xca\x0b";

// The following is static data describing the hosts that are hardcoded with
// certificate pins or HSTS information.

// kNoRejectedPublicKeys is a placeholder for when no public keys are rejected.
static const char* const kNoRejectedPublicKeys[] = {
  NULL,
};

static const char* const kTestAcceptableCerts[] = {
  kSPKIHash_TestSPKI,
  NULL,
};
#define kTestPins { \
  kTestAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kGoogleAcceptableCerts[] = {
  kSPKIHash_GoogleBackup2048,
  kSPKIHash_GoogleG2,
  NULL,
};
#define kGooglePins { \
  kGoogleAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTorAcceptableCerts[] = {
  kSPKIHash_RapidSSL,
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_Tor1,
  kSPKIHash_Tor2,
  kSPKIHash_Tor3,
  NULL,
};
#define kTorPins { \
  kTorAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTwitterComAcceptableCerts[] = {
  kSPKIHash_VeriSignClass1,
  kSPKIHash_VeriSignClass3,
  kSPKIHash_VeriSignClass3_G4,
  kSPKIHash_VeriSignClass4_G3,
  kSPKIHash_VeriSignClass3_G3,
  kSPKIHash_VeriSignClass1_G3,
  kSPKIHash_VeriSignClass2_G3,
  kSPKIHash_VeriSignClass3_G2,
  kSPKIHash_VeriSignClass2_G2,
  kSPKIHash_VeriSignClass3_G5,
  kSPKIHash_VeriSignUniversal,
  kSPKIHash_GeoTrustGlobal,
  kSPKIHash_GeoTrustGlobal2,
  kSPKIHash_GeoTrustUniversal,
  kSPKIHash_GeoTrustUniversal2,
  kSPKIHash_GeoTrustPrimary,
  kSPKIHash_GeoTrustPrimary_G2,
  kSPKIHash_GeoTrustPrimary_G3,
  kSPKIHash_DigiCertGlobalRoot,
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_DigiCertAssuredIDRoot,
  kSPKIHash_Twitter1,
  NULL,
};
#define kTwitterComPins { \
  kTwitterComAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTwitterCDNAcceptableCerts[] = {
  kSPKIHash_VeriSignClass1,
  kSPKIHash_VeriSignClass3,
  kSPKIHash_VeriSignClass3_G4,
  kSPKIHash_VeriSignClass4_G3,
  kSPKIHash_VeriSignClass3_G3,
  kSPKIHash_VeriSignClass1_G3,
  kSPKIHash_VeriSignClass2_G3,
  kSPKIHash_VeriSignClass3_G2,
  kSPKIHash_VeriSignClass2_G2,
  kSPKIHash_VeriSignClass3_G5,
  kSPKIHash_VeriSignUniversal,
  kSPKIHash_GeoTrustGlobal,
  kSPKIHash_GeoTrustGlobal2,
  kSPKIHash_GeoTrustUniversal,
  kSPKIHash_GeoTrustUniversal2,
  kSPKIHash_GeoTrustPrimary,
  kSPKIHash_GeoTrustPrimary_G2,
  kSPKIHash_GeoTrustPrimary_G3,
  kSPKIHash_DigiCertGlobalRoot,
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_DigiCertAssuredIDRoot,
  kSPKIHash_Twitter1,
  kSPKIHash_Entrust_2048,
  kSPKIHash_Entrust_EV,
  kSPKIHash_Entrust_G2,
  kSPKIHash_Entrust_SSL,
  kSPKIHash_AAACertificateServices,
  kSPKIHash_AddTrustClass1CARoot,
  kSPKIHash_AddTrustExternalCARoot,
  kSPKIHash_AddTrustPublicCARoot,
  kSPKIHash_AddTrustQualifiedCARoot,
  kSPKIHash_COMODOCertificationAuthority,
  kSPKIHash_SecureCertificateServices,
  kSPKIHash_TrustedCertificateServices,
  kSPKIHash_UTNDATACorpSGC,
  kSPKIHash_UTNUSERFirstClientAuthenticationandEmail,
  kSPKIHash_UTNUSERFirstHardware,
  kSPKIHash_UTNUSERFirstObject,
  kSPKIHash_GTECyberTrustGlobalRoot,
  kSPKIHash_BaltimoreCyberTrustRoot,
  kSPKIHash_GlobalSignRootCA,
  kSPKIHash_GlobalSignRootCA_R2,
  kSPKIHash_GlobalSignRootCA_R3,
  NULL,
};
#define kTwitterCDNPins { \
  kTwitterCDNAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTor2webAcceptableCerts[] = {
  kSPKIHash_AlphaSSL_G2,
  kSPKIHash_Tor2web,
  NULL,
};
#define kTor2webPins { \
  kTor2webAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kCryptoCatAcceptableCerts[] = {
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_CryptoCat1,
  NULL,
};
#define kCryptoCatPins { \
  kCryptoCatAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kLavabitAcceptableCerts[] = {
  kSPKIHash_Libertylavabitcom,
  NULL,
};
#define kLavabitPins { \
  kLavabitAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

#define kNoPins {\
  NULL, NULL, \
}

static const struct HSTSPreload kPreloadedSTS[] = {
  {25, true, "\013pinningtest\007appspot\003com", false, kTestPins, DOMAIN_APPSPOT_COM },
  {12, true, "\006google\003com", false, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006wallet\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010checkout\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006chrome\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004docs\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {18, true, "\005sites\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {25, true, "\014spreadsheets\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {22, true, "\011appengine\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {22, true, "\011encrypted\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010accounts\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010profiles\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004mail\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {23, true, "\012talkgadget\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004talk\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {29, true, "\020hostedtalkgadget\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004plus\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {25, true, "\004plus\007sandbox\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006script\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {20, true, "\007history\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010security\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004goto\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {18, true, "\005cloud\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {18, true, "\005glass\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {18, true, "\005admin\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, false, "\004play\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {20, true, "\006market\007android\003com", true, kGooglePins, DOMAIN_ANDROID_COM },
  {26, true, "\003ssl\020google-analytics\003com", true, kGooglePins, DOMAIN_GOOGLE_ANALYTICS_COM },
  {18, true, "\005drive\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {16, true, "\012googleplex\003com", true, kGooglePins, DOMAIN_GOOGLEPLEX_COM },
  {19, true, "\006groups\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004apis\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {32, true, "\022chromiumcodereview\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {38, true, "\030chrome-devtools-frontend\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {24, true, "\012codereview\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {25, true, "\012codereview\010chromium\003org", true, kGooglePins, DOMAIN_CHROMIUM_ORG },
  {17, true, "\004code\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {16, true, "\012googlecode\003com", false, kGooglePins, DOMAIN_GOOGLECODE_COM },
  {15, true, "\002dl\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {26, true, "\011translate\012googleapis\003com", true, kGooglePins, DOMAIN_GOOGLEAPIS_COM },
  {24, true, "\012webfilings\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {35, true, "\025webfilings-mirror-hrd\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {27, true, "\015webfilings-eu\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {34, true, "\024webfilings-eu-mirror\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {24, true, "\012wf-demo-eu\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {25, true, "\013wf-demo-hrd\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {24, true, "\012wf-pentest\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {26, true, "\014wf-trial-hrd\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {25, true, "\013xbrlsuccess\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {25, true, "\013w-spotlight\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {29, true, "\017wf-training-hrd\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {30, true, "\020wf-bigsky-master\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {27, true, "\015wf-staging-hr\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {32, true, "\022wf-training-master\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {28, true, "\016wf-dogfood-hrd\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {23, true, "\005chart\004apis\006google\003com", false, kGooglePins, DOMAIN_GOOGLE_COM },
  {11, true, "\005ytimg\003com", false, kGooglePins, DOMAIN_YTIMG_COM },
  {23, true, "\021googleusercontent\003com", false, kGooglePins, DOMAIN_GOOGLEUSERCONTENT_COM },
  {13, true, "\007youtube\003com", false, kGooglePins, DOMAIN_YOUTUBE_COM },
  {16, true, "\012googleapis\003com", false, kGooglePins, DOMAIN_GOOGLEAPIS_COM },
  {22, true, "\020googleadservices\003com", false, kGooglePins, DOMAIN_GOOGLEADSERVICES_COM },
  {13, true, "\007appspot\003com", false, kGooglePins, DOMAIN_APPSPOT_COM },
  {23, true, "\021googlesyndication\003com", false, kGooglePins, DOMAIN_GOOGLESYNDICATION_COM },
  {17, true, "\013doubleclick\003net", false, kGooglePins, DOMAIN_DOUBLECLICK_NET },
  {13, true, "\007gstatic\003com", false, kGooglePins, DOMAIN_GSTATIC_COM },
  {10, true, "\005youtu\002be", false, kGooglePins, DOMAIN_YOUTU_BE },
  {13, true, "\007android\003com", false, kGooglePins, DOMAIN_ANDROID_COM },
  {20, true, "\016googlecommerce\003com", false, kGooglePins, DOMAIN_GOOGLECOMMERCE_COM },
  {12, true, "\006urchin\003com", false, kGooglePins, DOMAIN_URCHIN_COM },
  {8, true, "\003goo\002gl", false, kGooglePins, DOMAIN_GOO_GL },
  {6, true, "\001g\002co", false, kGooglePins, DOMAIN_G_CO },
  {22, true, "\020googletagmanager\003com", false, kGooglePins, DOMAIN_GOOGLETAGMANAGER_COM },
  {23, true, "\021googletagservices\003com", false, kGooglePins, DOMAIN_GOOGLETAGSERVICES_COM },
  {11, true, "\006google\002ac", false, kGooglePins, DOMAIN_GOOGLE_AC },
  {11, true, "\006google\002ad", false, kGooglePins, DOMAIN_GOOGLE_AD },
  {11, true, "\006google\002ae", false, kGooglePins, DOMAIN_GOOGLE_AE },
  {11, true, "\006google\002af", false, kGooglePins, DOMAIN_GOOGLE_AF },
  {11, true, "\006google\002ag", false, kGooglePins, DOMAIN_GOOGLE_AG },
  {11, true, "\006google\002am", false, kGooglePins, DOMAIN_GOOGLE_AM },
  {11, true, "\006google\002as", false, kGooglePins, DOMAIN_GOOGLE_AS },
  {11, true, "\006google\002at", false, kGooglePins, DOMAIN_GOOGLE_AT },
  {11, true, "\006google\002az", false, kGooglePins, DOMAIN_GOOGLE_AZ },
  {11, true, "\006google\002ba", false, kGooglePins, DOMAIN_GOOGLE_BA },
  {11, true, "\006google\002be", false, kGooglePins, DOMAIN_GOOGLE_BE },
  {11, true, "\006google\002bf", false, kGooglePins, DOMAIN_GOOGLE_BF },
  {11, true, "\006google\002bg", false, kGooglePins, DOMAIN_GOOGLE_BG },
  {11, true, "\006google\002bi", false, kGooglePins, DOMAIN_GOOGLE_BI },
  {11, true, "\006google\002bj", false, kGooglePins, DOMAIN_GOOGLE_BJ },
  {11, true, "\006google\002bs", false, kGooglePins, DOMAIN_GOOGLE_BS },
  {11, true, "\006google\002by", false, kGooglePins, DOMAIN_GOOGLE_BY },
  {11, true, "\006google\002ca", false, kGooglePins, DOMAIN_GOOGLE_CA },
  {12, true, "\006google\003cat", false, kGooglePins, DOMAIN_GOOGLE_CAT },
  {11, true, "\006google\002cc", false, kGooglePins, DOMAIN_GOOGLE_CC },
  {11, true, "\006google\002cd", false, kGooglePins, DOMAIN_GOOGLE_CD },
  {11, true, "\006google\002cf", false, kGooglePins, DOMAIN_GOOGLE_CF },
  {11, true, "\006google\002cg", false, kGooglePins, DOMAIN_GOOGLE_CG },
  {11, true, "\006google\002ch", false, kGooglePins, DOMAIN_GOOGLE_CH },
  {11, true, "\006google\002ci", false, kGooglePins, DOMAIN_GOOGLE_CI },
  {11, true, "\006google\002cl", false, kGooglePins, DOMAIN_GOOGLE_CL },
  {11, true, "\006google\002cm", false, kGooglePins, DOMAIN_GOOGLE_CM },
  {11, true, "\006google\002cn", false, kGooglePins, DOMAIN_GOOGLE_CN },
  {14, true, "\006google\002co\002ao", false, kGooglePins, DOMAIN_CO_AO },
  {14, true, "\006google\002co\002bw", false, kGooglePins, DOMAIN_CO_BW },
  {14, true, "\006google\002co\002ck", false, kGooglePins, DOMAIN_CO_CK },
  {14, true, "\006google\002co\002cr", false, kGooglePins, DOMAIN_CO_CR },
  {14, true, "\006google\002co\002hu", false, kGooglePins, DOMAIN_CO_HU },
  {14, true, "\006google\002co\002id", false, kGooglePins, DOMAIN_CO_ID },
  {14, true, "\006google\002co\002il", false, kGooglePins, DOMAIN_CO_IL },
  {14, true, "\006google\002co\002im", false, kGooglePins, DOMAIN_CO_IM },
  {14, true, "\006google\002co\002in", false, kGooglePins, DOMAIN_CO_IN },
  {14, true, "\006google\002co\002je", false, kGooglePins, DOMAIN_CO_JE },
  {14, true, "\006google\002co\002jp", false, kGooglePins, DOMAIN_CO_JP },
  {14, true, "\006google\002co\002ke", false, kGooglePins, DOMAIN_CO_KE },
  {14, true, "\006google\002co\002kr", false, kGooglePins, DOMAIN_CO_KR },
  {14, true, "\006google\002co\002ls", false, kGooglePins, DOMAIN_CO_LS },
  {14, true, "\006google\002co\002ma", false, kGooglePins, DOMAIN_CO_MA },
  {14, true, "\006google\002co\002mz", false, kGooglePins, DOMAIN_CO_MZ },
  {14, true, "\006google\002co\002nz", false, kGooglePins, DOMAIN_CO_NZ },
  {14, true, "\006google\002co\002th", false, kGooglePins, DOMAIN_CO_TH },
  {14, true, "\006google\002co\002tz", false, kGooglePins, DOMAIN_CO_TZ },
  {14, true, "\006google\002co\002ug", false, kGooglePins, DOMAIN_CO_UG },
  {14, true, "\006google\002co\002uk", false, kGooglePins, DOMAIN_CO_UK },
  {14, true, "\006google\002co\002uz", false, kGooglePins, DOMAIN_CO_UZ },
  {14, true, "\006google\002co\002ve", false, kGooglePins, DOMAIN_CO_VE },
  {14, true, "\006google\002co\002vi", false, kGooglePins, DOMAIN_CO_VI },
  {14, true, "\006google\002co\002za", false, kGooglePins, DOMAIN_CO_ZA },
  {14, true, "\006google\002co\002zm", false, kGooglePins, DOMAIN_CO_ZM },
  {14, true, "\006google\002co\002zw", false, kGooglePins, DOMAIN_CO_ZW },
  {15, true, "\006google\003com\002af", false, kGooglePins, DOMAIN_COM_AF },
  {15, true, "\006google\003com\002ag", false, kGooglePins, DOMAIN_COM_AG },
  {15, true, "\006google\003com\002ai", false, kGooglePins, DOMAIN_COM_AI },
  {15, true, "\006google\003com\002ar", false, kGooglePins, DOMAIN_COM_AR },
  {15, true, "\006google\003com\002au", false, kGooglePins, DOMAIN_COM_AU },
  {15, true, "\006google\003com\002bd", false, kGooglePins, DOMAIN_COM_BD },
  {15, true, "\006google\003com\002bh", false, kGooglePins, DOMAIN_COM_BH },
  {15, true, "\006google\003com\002bn", false, kGooglePins, DOMAIN_COM_BN },
  {15, true, "\006google\003com\002bo", false, kGooglePins, DOMAIN_COM_BO },
  {15, true, "\006google\003com\002br", false, kGooglePins, DOMAIN_COM_BR },
  {15, true, "\006google\003com\002by", false, kGooglePins, DOMAIN_COM_BY },
  {15, true, "\006google\003com\002bz", false, kGooglePins, DOMAIN_COM_BZ },
  {15, true, "\006google\003com\002cn", false, kGooglePins, DOMAIN_COM_CN },
  {15, true, "\006google\003com\002co", false, kGooglePins, DOMAIN_COM_CO },
  {15, true, "\006google\003com\002cu", false, kGooglePins, DOMAIN_COM_CU },
  {15, true, "\006google\003com\002cy", false, kGooglePins, DOMAIN_COM_CY },
  {15, true, "\006google\003com\002do", false, kGooglePins, DOMAIN_COM_DO },
  {15, true, "\006google\003com\002ec", false, kGooglePins, DOMAIN_COM_EC },
  {15, true, "\006google\003com\002eg", false, kGooglePins, DOMAIN_COM_EG },
  {15, true, "\006google\003com\002et", false, kGooglePins, DOMAIN_COM_ET },
  {15, true, "\006google\003com\002fj", false, kGooglePins, DOMAIN_COM_FJ },
  {15, true, "\006google\003com\002ge", false, kGooglePins, DOMAIN_COM_GE },
  {15, true, "\006google\003com\002gh", false, kGooglePins, DOMAIN_COM_GH },
  {15, true, "\006google\003com\002gi", false, kGooglePins, DOMAIN_COM_GI },
  {15, true, "\006google\003com\002gr", false, kGooglePins, DOMAIN_COM_GR },
  {15, true, "\006google\003com\002gt", false, kGooglePins, DOMAIN_COM_GT },
  {15, true, "\006google\003com\002hk", false, kGooglePins, DOMAIN_COM_HK },
  {15, true, "\006google\003com\002iq", false, kGooglePins, DOMAIN_COM_IQ },
  {15, true, "\006google\003com\002jm", false, kGooglePins, DOMAIN_COM_JM },
  {15, true, "\006google\003com\002jo", false, kGooglePins, DOMAIN_COM_JO },
  {15, true, "\006google\003com\002kh", false, kGooglePins, DOMAIN_COM_KH },
  {15, true, "\006google\003com\002kw", false, kGooglePins, DOMAIN_COM_KW },
  {15, true, "\006google\003com\002lb", false, kGooglePins, DOMAIN_COM_LB },
  {15, true, "\006google\003com\002ly", false, kGooglePins, DOMAIN_COM_LY },
  {15, true, "\006google\003com\002mt", false, kGooglePins, DOMAIN_COM_MT },
  {15, true, "\006google\003com\002mx", false, kGooglePins, DOMAIN_COM_MX },
  {15, true, "\006google\003com\002my", false, kGooglePins, DOMAIN_COM_MY },
  {15, true, "\006google\003com\002na", false, kGooglePins, DOMAIN_COM_NA },
  {15, true, "\006google\003com\002nf", false, kGooglePins, DOMAIN_COM_NF },
  {15, true, "\006google\003com\002ng", false, kGooglePins, DOMAIN_COM_NG },
  {15, true, "\006google\003com\002ni", false, kGooglePins, DOMAIN_COM_NI },
  {15, true, "\006google\003com\002np", false, kGooglePins, DOMAIN_COM_NP },
  {15, true, "\006google\003com\002nr", false, kGooglePins, DOMAIN_COM_NR },
  {15, true, "\006google\003com\002om", false, kGooglePins, DOMAIN_COM_OM },
  {15, true, "\006google\003com\002pa", false, kGooglePins, DOMAIN_COM_PA },
  {15, true, "\006google\003com\002pe", false, kGooglePins, DOMAIN_COM_PE },
  {15, true, "\006google\003com\002ph", false, kGooglePins, DOMAIN_COM_PH },
  {15, true, "\006google\003com\002pk", false, kGooglePins, DOMAIN_COM_PK },
  {15, true, "\006google\003com\002pl", false, kGooglePins, DOMAIN_COM_PL },
  {15, true, "\006google\003com\002pr", false, kGooglePins, DOMAIN_COM_PR },
  {15, true, "\006google\003com\002py", false, kGooglePins, DOMAIN_COM_PY },
  {15, true, "\006google\003com\002qa", false, kGooglePins, DOMAIN_COM_QA },
  {15, true, "\006google\003com\002ru", false, kGooglePins, DOMAIN_COM_RU },
  {15, true, "\006google\003com\002sa", false, kGooglePins, DOMAIN_COM_SA },
  {15, true, "\006google\003com\002sb", false, kGooglePins, DOMAIN_COM_SB },
  {15, true, "\006google\003com\002sg", false, kGooglePins, DOMAIN_COM_SG },
  {15, true, "\006google\003com\002sl", false, kGooglePins, DOMAIN_COM_SL },
  {15, true, "\006google\003com\002sv", false, kGooglePins, DOMAIN_COM_SV },
  {15, true, "\006google\003com\002tj", false, kGooglePins, DOMAIN_COM_TJ },
  {15, true, "\006google\003com\002tn", false, kGooglePins, DOMAIN_COM_TN },
  {15, true, "\006google\003com\002tr", false, kGooglePins, DOMAIN_COM_TR },
  {15, true, "\006google\003com\002tw", false, kGooglePins, DOMAIN_COM_TW },
  {15, true, "\006google\003com\002ua", false, kGooglePins, DOMAIN_COM_UA },
  {15, true, "\006google\003com\002uy", false, kGooglePins, DOMAIN_COM_UY },
  {15, true, "\006google\003com\002vc", false, kGooglePins, DOMAIN_COM_VC },
  {15, true, "\006google\003com\002ve", false, kGooglePins, DOMAIN_COM_VE },
  {15, true, "\006google\003com\002vn", false, kGooglePins, DOMAIN_COM_VN },
  {11, true, "\006google\002cv", false, kGooglePins, DOMAIN_GOOGLE_CV },
  {11, true, "\006google\002cz", false, kGooglePins, DOMAIN_GOOGLE_CZ },
  {11, true, "\006google\002de", false, kGooglePins, DOMAIN_GOOGLE_DE },
  {11, true, "\006google\002dj", false, kGooglePins, DOMAIN_GOOGLE_DJ },
  {11, true, "\006google\002dk", false, kGooglePins, DOMAIN_GOOGLE_DK },
  {11, true, "\006google\002dm", false, kGooglePins, DOMAIN_GOOGLE_DM },
  {11, true, "\006google\002dz", false, kGooglePins, DOMAIN_GOOGLE_DZ },
  {11, true, "\006google\002ee", false, kGooglePins, DOMAIN_GOOGLE_EE },
  {11, true, "\006google\002es", false, kGooglePins, DOMAIN_GOOGLE_ES },
  {11, true, "\006google\002fi", false, kGooglePins, DOMAIN_GOOGLE_FI },
  {11, true, "\006google\002fm", false, kGooglePins, DOMAIN_GOOGLE_FM },
  {11, true, "\006google\002fr", false, kGooglePins, DOMAIN_GOOGLE_FR },
  {11, true, "\006google\002ga", false, kGooglePins, DOMAIN_GOOGLE_GA },
  {11, true, "\006google\002ge", false, kGooglePins, DOMAIN_GOOGLE_GE },
  {11, true, "\006google\002gg", false, kGooglePins, DOMAIN_GOOGLE_GG },
  {11, true, "\006google\002gl", false, kGooglePins, DOMAIN_GOOGLE_GL },
  {11, true, "\006google\002gm", false, kGooglePins, DOMAIN_GOOGLE_GM },
  {11, true, "\006google\002gp", false, kGooglePins, DOMAIN_GOOGLE_GP },
  {11, true, "\006google\002gr", false, kGooglePins, DOMAIN_GOOGLE_GR },
  {11, true, "\006google\002gy", false, kGooglePins, DOMAIN_GOOGLE_GY },
  {11, true, "\006google\002hk", false, kGooglePins, DOMAIN_GOOGLE_HK },
  {11, true, "\006google\002hn", false, kGooglePins, DOMAIN_GOOGLE_HN },
  {11, true, "\006google\002hr", false, kGooglePins, DOMAIN_GOOGLE_HR },
  {11, true, "\006google\002ht", false, kGooglePins, DOMAIN_GOOGLE_HT },
  {11, true, "\006google\002hu", false, kGooglePins, DOMAIN_GOOGLE_HU },
  {11, true, "\006google\002ie", false, kGooglePins, DOMAIN_GOOGLE_IE },
  {11, true, "\006google\002im", false, kGooglePins, DOMAIN_GOOGLE_IM },
  {13, true, "\006google\004info", false, kGooglePins, DOMAIN_GOOGLE_INFO },
  {11, true, "\006google\002iq", false, kGooglePins, DOMAIN_GOOGLE_IQ },
  {11, true, "\006google\002is", false, kGooglePins, DOMAIN_GOOGLE_IS },
  {11, true, "\006google\002it", false, kGooglePins, DOMAIN_GOOGLE_IT },
  {14, true, "\006google\002it\002ao", false, kGooglePins, DOMAIN_IT_AO },
  {11, true, "\006google\002je", false, kGooglePins, DOMAIN_GOOGLE_JE },
  {11, true, "\006google\002jo", false, kGooglePins, DOMAIN_GOOGLE_JO },
  {13, true, "\006google\004jobs", false, kGooglePins, DOMAIN_GOOGLE_JOBS },
  {11, true, "\006google\002jp", false, kGooglePins, DOMAIN_GOOGLE_JP },
  {11, true, "\006google\002kg", false, kGooglePins, DOMAIN_GOOGLE_KG },
  {11, true, "\006google\002ki", false, kGooglePins, DOMAIN_GOOGLE_KI },
  {11, true, "\006google\002kz", false, kGooglePins, DOMAIN_GOOGLE_KZ },
  {11, true, "\006google\002la", false, kGooglePins, DOMAIN_GOOGLE_LA },
  {11, true, "\006google\002li", false, kGooglePins, DOMAIN_GOOGLE_LI },
  {11, true, "\006google\002lk", false, kGooglePins, DOMAIN_GOOGLE_LK },
  {11, true, "\006google\002lt", false, kGooglePins, DOMAIN_GOOGLE_LT },
  {11, true, "\006google\002lu", false, kGooglePins, DOMAIN_GOOGLE_LU },
  {11, true, "\006google\002lv", false, kGooglePins, DOMAIN_GOOGLE_LV },
  {11, true, "\006google\002md", false, kGooglePins, DOMAIN_GOOGLE_MD },
  {11, true, "\006google\002me", false, kGooglePins, DOMAIN_GOOGLE_ME },
  {11, true, "\006google\002mg", false, kGooglePins, DOMAIN_GOOGLE_MG },
  {11, true, "\006google\002mk", false, kGooglePins, DOMAIN_GOOGLE_MK },
  {11, true, "\006google\002ml", false, kGooglePins, DOMAIN_GOOGLE_ML },
  {11, true, "\006google\002mn", false, kGooglePins, DOMAIN_GOOGLE_MN },
  {11, true, "\006google\002ms", false, kGooglePins, DOMAIN_GOOGLE_MS },
  {11, true, "\006google\002mu", false, kGooglePins, DOMAIN_GOOGLE_MU },
  {11, true, "\006google\002mv", false, kGooglePins, DOMAIN_GOOGLE_MV },
  {11, true, "\006google\002mw", false, kGooglePins, DOMAIN_GOOGLE_MW },
  {11, true, "\006google\002ne", false, kGooglePins, DOMAIN_GOOGLE_NE },
  {14, true, "\006google\002ne\002jp", false, kGooglePins, DOMAIN_NE_JP },
  {12, true, "\006google\003net", false, kGooglePins, DOMAIN_GOOGLE_NET },
  {11, true, "\006google\002nl", false, kGooglePins, DOMAIN_GOOGLE_NL },
  {11, true, "\006google\002no", false, kGooglePins, DOMAIN_GOOGLE_NO },
  {11, true, "\006google\002nr", false, kGooglePins, DOMAIN_GOOGLE_NR },
  {11, true, "\006google\002nu", false, kGooglePins, DOMAIN_GOOGLE_NU },
  {15, true, "\006google\003off\002ai", false, kGooglePins, DOMAIN_OFF_AI },
  {11, true, "\006google\002pk", false, kGooglePins, DOMAIN_GOOGLE_PK },
  {11, true, "\006google\002pl", false, kGooglePins, DOMAIN_GOOGLE_PL },
  {11, true, "\006google\002pn", false, kGooglePins, DOMAIN_GOOGLE_PN },
  {11, true, "\006google\002ps", false, kGooglePins, DOMAIN_GOOGLE_PS },
  {11, true, "\006google\002pt", false, kGooglePins, DOMAIN_GOOGLE_PT },
  {11, true, "\006google\002ro", false, kGooglePins, DOMAIN_GOOGLE_RO },
  {11, true, "\006google\002rs", false, kGooglePins, DOMAIN_GOOGLE_RS },
  {11, true, "\006google\002ru", false, kGooglePins, DOMAIN_GOOGLE_RU },
  {11, true, "\006google\002rw", false, kGooglePins, DOMAIN_GOOGLE_RW },
  {11, true, "\006google\002sc", false, kGooglePins, DOMAIN_GOOGLE_SC },
  {11, true, "\006google\002se", false, kGooglePins, DOMAIN_GOOGLE_SE },
  {11, true, "\006google\002sh", false, kGooglePins, DOMAIN_GOOGLE_SH },
  {11, true, "\006google\002si", false, kGooglePins, DOMAIN_GOOGLE_SI },
  {11, true, "\006google\002sk", false, kGooglePins, DOMAIN_GOOGLE_SK },
  {11, true, "\006google\002sm", false, kGooglePins, DOMAIN_GOOGLE_SM },
  {11, true, "\006google\002sn", false, kGooglePins, DOMAIN_GOOGLE_SN },
  {11, true, "\006google\002so", false, kGooglePins, DOMAIN_GOOGLE_SO },
  {11, true, "\006google\002st", false, kGooglePins, DOMAIN_GOOGLE_ST },
  {11, true, "\006google\002td", false, kGooglePins, DOMAIN_GOOGLE_TD },
  {11, true, "\006google\002tg", false, kGooglePins, DOMAIN_GOOGLE_TG },
  {11, true, "\006google\002tk", false, kGooglePins, DOMAIN_GOOGLE_TK },
  {11, true, "\006google\002tl", false, kGooglePins, DOMAIN_GOOGLE_TL },
  {11, true, "\006google\002tm", false, kGooglePins, DOMAIN_GOOGLE_TM },
  {11, true, "\006google\002tn", false, kGooglePins, DOMAIN_GOOGLE_TN },
  {11, true, "\006google\002to", false, kGooglePins, DOMAIN_GOOGLE_TO },
  {11, true, "\006google\002tt", false, kGooglePins, DOMAIN_GOOGLE_TT },
  {11, true, "\006google\002us", false, kGooglePins, DOMAIN_GOOGLE_US },
  {11, true, "\006google\002uz", false, kGooglePins, DOMAIN_GOOGLE_UZ },
  {11, true, "\006google\002vg", false, kGooglePins, DOMAIN_GOOGLE_VG },
  {11, true, "\006google\002vu", false, kGooglePins, DOMAIN_GOOGLE_VU },
  {11, true, "\006google\002ws", false, kGooglePins, DOMAIN_GOOGLE_WS },
  {23, true, "\005learn\013doubleclick\003net", false, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006paypal\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006paypal\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006elanex\003biz", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006jottit\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\015sunshinepress\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\003www\013noisebridge\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, false, "\004neg9\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006riseup\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\006factor\002cc", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007members\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007support\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\002id\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\005lists\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007webmail\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, true, "\011roundcube\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {28, false, "\016aladdinschools\007appspot\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\011ottospora\002nl", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, false, "\003www\017paycheckrecords\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010lastpass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010lastpass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010keyerror\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\010entropia\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\010entropia\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005romab\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012logentries\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003www\012logentries\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006stripe\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, true, "\025cloudsecurityalliance\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\005login\004sapo\002pt", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\015mattmccutchen\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006betnet\002fr", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010uprotect\002it", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010squareup\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006square\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004cert\002se", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006crypto\002is", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\005simon\007butcher\004name", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\004linx\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007dropcam\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007dropcam\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {30, true, "\010ebanking\014indovinabank\003com\002vn", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007epoxate\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {21, true, "\004blog\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {22, true, "\005check\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {20, true, "\003www\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {21, true, "\004dist\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {22, true, "\003www\014moneybookers\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\013ledgerscope\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\003www\013ledgerscope\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003app\007recurly\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003api\007recurly\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007greplin\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007greplin\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, true, "\006luneta\016nearbuysystems\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006ubertt\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004pixi\002me", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010grepular\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003www\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {26, false, "\011developer\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {30, false, "\003www\011developer\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\007sandbox\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {28, false, "\003www\007sandbox\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006crypto\003cat", true, kCryptoCatPins, DOMAIN_CRYPTO_CAT },
  {25, true, "\014bigshinylock\006minazo\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005crate\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007twitter\003com", true, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003www\007twitter\003com", true, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003api\007twitter\003com", false, kTwitterCDNPins, DOMAIN_TWITTER_COM },
  {19, true, "\005oauth\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {20, true, "\006mobile\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003dev\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {22, true, "\010business\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {22, true, "\010platform\007twitter\003com", false, kTwitterCDNPins, DOMAIN_TWITTER_COM },
  {11, true, "\005twimg\003com", false, kTwitterCDNPins, DOMAIN_TWIMG_COM },
  {22, true, "\020braintreegateway\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\021braintreepayments\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, false, "\003www\021braintreepayments\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\022emailprivacytester\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007tor2web\003org", false, kTor2webPins, DOMAIN_TOR2WEB_ORG },
  {25, true, "\010business\007medbank\003com\002mt", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\005arivo\003com\002br", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\003www\013apollo-auto\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\003www\005cueup\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\003www\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010download\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {8, true, "\003sol\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\005alpha\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006passwd\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011browserid\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005login\007persona\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003www\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005shops\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\014piratenlogin\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011howrandom\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003api\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\010fatzebra\003com\002au", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\007csawctf\004poly\003edu", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014makeyourlaws\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, false, "\003www\014makeyourlaws\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\003iop\006intuit\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010surfeasy\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010surfeasy\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011packagist\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011mylookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003www\011mylookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\002dm\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\010business\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\004blog\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003faq\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\010platform\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005email\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003app\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003api\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, true, "\011keymaster\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, true, "\011discovery\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014mobilethreat\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, true, "\023mobilethreatnetwork\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011itriskltd\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\012stocktrade\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\011openshift\006redhat\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\014therapynotes\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, false, "\003www\014therapynotes\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\003wiz\003biz", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\002my\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\007webmail\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\003crm\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\003www\003gov\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014silentcircle\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014silentcircle\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\015serverdensity\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\002my\010alfresco\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\007webmail\010gigahost\002dk", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007paymill\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007paymill\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\012gocardless\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005espra\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005zoo24\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\004mega\002co\002nz", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\003api\004mega\002co\002nz", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007lockify\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\010writeapp\002me", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\010bugzilla\007mozilla\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {30, true, "\007members\020nearlyfreespeech\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003ssl\011panoramio\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007kiwiirc\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003pay\010gigahost\002dk", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, true, "\015controlcenter\010gigahost\002dk", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006simple\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006simple\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\002fj\006simple\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003api\006simple\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\004bank\006simple\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005bassh\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\004sah3\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, false, "\003grc\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\003www\003grc\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\007manager\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\004blog\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\007library\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\005forum\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\001p\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\005paste\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\010pastebin\006linode\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\017inertianetworks\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010carezone\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011conformal\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\012cyphertite\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010logotype\002se", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\004bccx\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011launchkey\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\010carlolly\002co\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\003www\013cyveillance\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\004blog\013cyveillance\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006whonix\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006shodan\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\015rapidresearch\002me", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010surkatty\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\017securityheaders\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005haste\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007mudcrab\002us", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010mediacru\002sh", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010lolicore\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\007cloudns\003com\002au", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005oplop\007appspot\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006bcrook\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\004wiki\006python\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, false, "\004lumi\002do", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\020appseccalifornia\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\013crowdcurity\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\013saturngames\002co\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, true, "\021strongest-privacy\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, true, "\011ecosystem\011atlassian\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\002id\011atlassian\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011bitbucket\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007cupcake\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007cupcake\002is", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004tent\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006cybozu\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\013davidlyness\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006medium\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\007liberty\007lavabit\003com", true, kLavabitPins, DOMAIN_LAVABIT_COM },
  {16, true, "\012getlantern\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011kinsights\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\007simbolo\002co\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003www\007simbolo\002co\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012zenpayroll\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003www\012zenpayroll\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003get\012zenpayroll\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\006errors\012zenpayroll\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\006manage\012zenpayroll\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\016gernert-server\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\010skydrive\004live\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\011lifeguard\005aecom\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\004data\003qld\003gov\002au", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, false, "\014publications\003qld\003gov\002au", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\002go\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\005login\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\002my\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\007payroll\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\002in\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\003api\004xero\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\003eff\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004mail\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010passport\006yandex\002ru", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\010passport\006yandex\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010passport\006yandex\002ua", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010passport\006yandex\002by", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010passport\006yandex\002kz", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\010passport\006yandex\003com\002tr", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006mnsure\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010getcloak\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010getcloak\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, true, "\020matteomarescotti\004name", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\003www\011heliosnet\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007opsmate\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003www\007opsmate\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007f-droid\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010evernote\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003app\010yinxiang\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011neilwynne\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\016calyxinstitute\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\003www\016calyxinstitute\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011blacklane\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\012boxcryptor\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, false, "\004aclu\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\003www\004aclu\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007prodpad\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007mailbox\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006roddis\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006roddis\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005fiken\002no", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010fairbill\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005nexth\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005nexth\002us", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005nexth\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006souyar\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006souyar\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006souyar\002us", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003www\007banking\002co\002at", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003mbp\007banking\002co\002at", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007feedbin\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004heha\002co", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\013passwordbox\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006python\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\004pypi\006python\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\003www\006python\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\004docs\006python\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\013encircleapp\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\010onedrive\004live\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010onedrive\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\016keepersecurity\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011keeperapp\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006donmez\002ws", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\010activiti\010alfresco\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011cloudcert\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010seifried\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\005wepay\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\003www\005wepay\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\006static\005wepay\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\005stage\005wepay\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011vmoagents\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007adsfund\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, false, "\004pult\002co", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014dillonkorman\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006edmodo\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\003www\013eternalgoth\002co\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003app\007manilla\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\012harvestapp\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007anycoin\002me", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010noexpect\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, false, "\006airbnb\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\003www\006airbnb\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, false, "\004usaa\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\003www\004usaa\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\006mobile\004usaa\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\007subrosa\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011detectify\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005crbug\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\016manageprojects\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\017tinfoilsecurity\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, false, "\003www\017tinfoilsecurity\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\006imouto\002my", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010vocaloid\002my", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\006sakaki\005anime\002my", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\007reviews\005anime\002my", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\004miku\007hatsune\002my", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\012webcollect\003org\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\003www\016capitainetrain\003com", true, kNoPins, DOMAIN_NOT_PINNED },
};
static const size_t kNumPreloadedSTS = ARRAYSIZE_UNSAFE(kPreloadedSTS);

static const struct HSTSPreload kPreloadedSNISTS[] = {
  {11, false, "\005gmail\003com", true, kGooglePins, DOMAIN_GMAIL_COM },
  {16, false, "\012googlemail\003com", true, kGooglePins, DOMAIN_GOOGLEMAIL_COM },
  {15, false, "\003www\005gmail\003com", true, kGooglePins, DOMAIN_GMAIL_COM },
  {20, false, "\003www\012googlemail\003com", true, kGooglePins, DOMAIN_GOOGLEMAIL_COM },
  {22, true, "\020google-analytics\003com", false, kGooglePins, DOMAIN_GOOGLE_ANALYTICS_COM },
  {18, true, "\014googlegroups\003com", false, kGooglePins, DOMAIN_GOOGLEGROUPS_COM },
  {13, true, "\007mykolab\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\013semenkovich\003com", true, kNoPins, DOMAIN_NOT_PINNED },
};
static const size_t kNumPreloadedSNISTS = ARRAYSIZE_UNSAFE(kPreloadedSNISTS);

#endif // NET_HTTP_TRANSPORT_SECURITY_STATE_STATIC_H_
