// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_BASE_FILENAME_UTIL_UNSAFE_H_
#define NET_BASE_FILENAME_UTIL_UNSAFE_H_

#include <string>

#include "base/files/file_path.h"
#include "base/strings/string16.h"
#include "net/base/net_export.h"

class GURL;

namespace net {

// Extract extension from FilePath generated by GenerateFileName(), but without
// replacing illegal characters. Does not depend on ICU.
NET_EXPORT base::FilePath::StringType GenerateFileExtensionUnsafe(
    const GURL& url,
    const std::string& content_disposition,
    const std::string& referrer_charset,
    const std::string& suggested_name,
    const std::string& mime_type,
    const std::string& default_name);

}  // namespace net

#endif  // NET_BASE_FILENAME_UTIL_UNSAFE_H_
