/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpCheck
extends AbstractFormatCheck {
    private static final int DEFAULT_DUPLICATE_LIMIT = -1;
    private static final int DEFAULT_ERROR_LIMIT = 100;
    private static final String ERROR_LIMIT_EXCEEDED_MESSAGE = "The error limit has been exceeded, the check is aborting, there may be more unreported errors.";
    private String mMessage = "";
    private boolean mIgnoreComments;
    private boolean mIllegalPattern;
    private int mErrorLimit = 100;
    private int mDuplicateLimit;
    private boolean mCheckForDuplicates;
    private int mMatchCount;
    private int mErrorCount;
    private final List<Integer[]> mCharacters = Lists.newArrayList();
    private Matcher mMatcher;

    public RegexpCheck() {
        super("$^", 8);
    }

    public void setMessage(String aMessage) {
        this.mMessage = aMessage == null ? "" : aMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setIgnoreComments(boolean aIgnoreComments) {
        this.mIgnoreComments = aIgnoreComments;
    }

    public void setIllegalPattern(boolean aIllegalPattern) {
        this.mIllegalPattern = aIllegalPattern;
    }

    public void setErrorLimit(int aErrorLimit) {
        this.mErrorLimit = aErrorLimit;
    }

    public void setDuplicateLimit(int aDuplicateLimit) {
        this.mDuplicateLimit = aDuplicateLimit;
        this.mCheckForDuplicates = this.mDuplicateLimit > -1;
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCharacters.clear();
        Pattern pattern = this.getRegexp();
        String[] lines = this.getLines();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]);
            sb.append('\n');
            for (int j = 0; j < lines[i].length() + 1; ++j) {
                this.mCharacters.add(new Integer[]{i + 1, j});
            }
        }
        this.mMatcher = pattern.matcher(sb.toString());
        this.mMatchCount = 0;
        this.mErrorCount = 0;
        this.findMatch();
    }

    private void findMatch() {
        boolean ignore = false;
        boolean foundMatch = this.mMatcher.find();
        if (!foundMatch && !this.mIllegalPattern && this.mMatchCount == 0) {
            this.logMessage(0);
        } else if (foundMatch) {
            int startLine = this.mCharacters.get(this.mMatcher.start())[0];
            int startColumn = this.mCharacters.get(this.mMatcher.start())[1];
            int endLine = this.mCharacters.get(this.mMatcher.end() - 1)[0];
            int endColumn = this.mCharacters.get(this.mMatcher.end() - 1)[1];
            if (this.mIgnoreComments) {
                FileContents theFileContents = this.getFileContents();
                ignore = theFileContents.hasIntersectionWithComment(startLine, startColumn, endLine, endColumn);
            }
            if (!ignore) {
                ++this.mMatchCount;
                if (this.mIllegalPattern || this.mCheckForDuplicates && this.mMatchCount - 1 > this.mDuplicateLimit) {
                    ++this.mErrorCount;
                    this.logMessage(startLine);
                }
            }
            if (this.mErrorCount < this.mErrorLimit && (ignore || this.mIllegalPattern || this.mCheckForDuplicates)) {
                this.findMatch();
            }
        }
    }

    private void logMessage(int aLineNumber) {
        String message;
        String string = message = "".equals(this.getMessage()) ? this.getFormat() : this.mMessage;
        if (this.mErrorCount >= this.mErrorLimit) {
            message = ERROR_LIMIT_EXCEEDED_MESSAGE + message;
        }
        if (this.mIllegalPattern) {
            this.log(aLineNumber, "illegal.regexp", message);
        } else if (aLineNumber > 0) {
            this.log(aLineNumber, "duplicate.regexp", message);
        } else {
            this.log(aLineNumber, "required.regexp", message);
        }
    }
}

