/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;

public class OverloadMethodsDeclarationOrderCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{6};
    }

    public void visitToken(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        if (parentType == 14 || parentType == 156 || parentType == 15 || parentType == 138) {
            this.checkOverloadMethodsGrouping(aAST);
        }
    }

    private void checkOverloadMethodsGrouping(DetailAST aObjectBlock) {
        boolean allowedDistance = true;
        HashMap<String, Integer> methodIndexMap = new HashMap<String, Integer>();
        HashMap<String, Integer> methodLineNumberMap = new HashMap<String, Integer>();
        int currentIndex = 0;
        for (DetailAST currentToken = aObjectBlock.getFirstChild(); currentToken != null; currentToken = currentToken.getNextSibling()) {
            int priviousIndex;
            if (currentToken.getType() != 9) continue;
            String methodName = currentToken.findFirstToken(59).getText();
            if (methodIndexMap.containsKey(methodName) && ++currentIndex - (priviousIndex = ((Integer)methodIndexMap.get(methodName)).intValue()) > 1) {
                int previousLineWithOverloadMethod = (Integer)methodLineNumberMap.get(methodName);
                this.log(currentToken.getLineNo(), "overload.methods.declaration", previousLineWithOverloadMethod);
            }
            methodIndexMap.put(methodName, currentIndex);
            methodLineNumberMap.put(methodName, currentToken.getLineNo());
        }
    }
}

