/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 * Copyright (C) 2012 Motorola Mobility Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DOMURLUtils_h
#define DOMURLUtils_h

#include "core/CoreExport.h"
#include "core/dom/DOMURLUtilsReadOnly.h"
#include "wtf/Forward.h"

namespace blink {

class KURL;

class CORE_EXPORT DOMURLUtils : public DOMURLUtilsReadOnly {
public:
    virtual void setURL(const KURL&) = 0;
    virtual void setInput(const String&) = 0;
    ~DOMURLUtils() override;

    void setHref(const String&);

    void setProtocol(const String&);
    void setUsername(const String&);
    void setPassword(const String&);
    void setHost(const String&);
    void setHostname(const String&);
    void setPort(const String&);
    void setPathname(const String&);
    void setHash(const String&);
    virtual void setSearch(const String&);

protected:
    void setSearchInternal(const String&);

    bool isInUpdate() const { return m_isInUpdate; }

    bool m_isInUpdate = false;
};

} // namespace blink

#endif // DOMURLUtils_h
