package com.mapbox.mapboxsdk.telemetry;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;

/**
 * Listener for Location updates generated by implementing app.
 */
public class TelemetryLocationReceiver extends BroadcastReceiver {

  public static final String INTENT_STRING = "com.mapbox.mapboxsdk.telemetry.TelemetryLocationReceiver";

  /**
   * Default Constructor
   */
  public TelemetryLocationReceiver() {
    super();
  }

  /**
   * This method is called when the BroadcastReceiver is receiving an Intent
   * broadcast.  During this time you can use the other methods on
   * BroadcastReceiver to view/modify the current result values.  This method
   * is always called within the main thread of its process, unless you
   * explicitly asked for it to be scheduled on a different thread using
   * {@link Context#registerReceiver(BroadcastReceiver,
   * android.content.IntentFilter, String, android.os.Handler)}. When it runs on the main
   * thread you should
   * never perform long-running operations in it (there is a timeout of
   * 10 seconds that the system allows before considering the receiver to
   * be blocked and a candidate to be killed). You cannot launch a popup dialog
   * in your implementation of onReceive().
   * <p>
   * <p><b>If this BroadcastReceiver was launched through a &lt;receiver&gt; tag,
   * then the object is no longer alive after returning from this
   * function.</b>  This means you should not perform any operations that
   * return a result to you asynchronously -- in particular, for interacting
   * with services, you should use
   * {@link Context#startService(Intent)} instead of
   * {@link Context#bindService(Intent, android.content.ServiceConnection, int)}.  If you wish
   * to interact with a service that is already running, you can use
   * {@link #peekService}.
   * <p>
   * <p>The Intent filters used in {@link Context#registerReceiver}
   * and in application manifests are <em>not</em> guaranteed to be exclusive. They
   * are hints to the operating system about how to find suitable recipients. It is
   * possible for senders to force delivery to specific recipients, bypassing filter
   * resolution.  For this reason, {@link #onReceive(Context, Intent) onReceive()}
   * implementations should respond only to known actions, ignoring any unexpected
   * Intents that they may receive.
   *
   * @param context The Context in which the receiver is running.
   * @param intent  The Intent being received.
   */
  @Override
  public void onReceive(Context context, Intent intent) {
    if (intent == null || intent.getExtras() == null) {
      // see https://github.com/mapbox/mapbox-gl-native/issues/6934
      return;
    }

    Location location = (Location) intent.getExtras().get(LocationManager.KEY_LOCATION_CHANGED);
    if (location != null) {
      MapboxEventManager.getMapboxEventManager().addLocationEvent(location);
    }
  }
}
