# Mapbox macOS SDK

[![Bitrise](https://www.bitrise.io/app/155ef7da24b38dcd.svg?token=4KSOw_gd6WxTnvGE2rMttg&branch=master)](https://www.bitrise.io/app/155ef7da24b38dcd)

Put interactive, scalable world maps into your native Cocoa application with the Mapbox macOS SDK.

* Mapbox-curated [map styles](https://www.mapbox.com/maps/) and [vector tiles](https://www.mapbox.com/vector-tiles/) make it easy to get started.
* Customize every aspect of the map’s appearance in code or visually using [Mapbox Studio](https://www.mapbox.com/mapbox-studio/).
* High-performance OpenGL rendering and multitouch gestures keep your users happy.
* A well-designed, fully documented API helps you stay productive.
* Develop across [multiple platforms](../../README.md), including [iOS](../ios/README.md), using the same styles and similar APIs.

![](docs/img/screenshot.jpg)

The Mapbox macOS SDK is compatible with macOS 10.10.0 and above for Cocoa applications developed in Objective-C, Swift, Interface Builder, or AppleScript. For hybrid applications, consider [Mapbox GL JS](https://github.com/mapbox/mapbox-gl-js/).

* [Integrate the Mapbox macOS SDK into your application](INSTALL.md)
* [Contribute to the Mapbox macOS SDK](DEVELOPING.md)
* [Mapbox macOS SDK reference documentation](https://mapbox.github.io/mapbox-gl-native/macos/)
* [See example styles designed in Mapbox Studio](https://www.mapbox.com/gallery/)
* [Hand-authoring a macOS SDK–compatible style](https://www.mapbox.com/mapbox-gl-style-spec/)
* [Mapbox Vector Tile Specification](https://www.mapbox.com/developers/vector-tiles/)

Mapbox does not officially support the Mapbox macOS SDK to the same extent as the Mapbox iOS SDK; however, bug reports and pull requests are certainly welcome.
