; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instcombine < %s | FileCheck %s

define float @test1(float %x) nounwind readnone ssp {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[SQRTF:%.*]] = call float @sqrtf(float [[X:%.*]]) #3
; CHECK-NEXT:    ret float [[SQRTF]]
;
  %conv = fpext float %x to double
  %call = tail call double @sqrt(double %conv) readnone nounwind
  %conv1 = fptrunc double %call to float
  ret float %conv1
}

; PR8096

define float @test2(float %x) nounwind readnone ssp {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[SQRTF:%.*]] = call float @sqrtf(float [[X:%.*]]) #3
; CHECK-NEXT:    ret float [[SQRTF]]
;
  %conv = fpext float %x to double
  %call = tail call double @sqrt(double %conv) nounwind
  %conv1 = fptrunc double %call to float
  ret float %conv1
}

; rdar://9763193
; Can't fold (fptrunc (sqrt (fpext x))) -> (sqrtf x) since there is another
; use of sqrt result.

define float @test3(float* %v) nounwind uwtable ssp {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[CALL34:%.*]] = call double @sqrt(double 0x7FF8000000000000) #3
; CHECK-NEXT:    [[CALL36:%.*]] = call i32 @foo(double [[CALL34]]) #4
; CHECK-NEXT:    [[CONV38:%.*]] = fptrunc double [[CALL34]] to float
; CHECK-NEXT:    ret float [[CONV38]]
;
  %arrayidx13 = getelementptr inbounds float, float* %v, i64 2
  %tmp14 = load float, float* %arrayidx13
  %mul18 = fmul float %tmp14, %tmp14
  %add19 = fadd float undef, %mul18
  %conv = fpext float %add19 to double
  %call34 = call double @sqrt(double %conv) readnone
  %call36 = call i32 (double) @foo(double %call34) nounwind
  %conv38 = fptrunc double %call34 to float
  ret float %conv38
}

declare i32 @foo(double)
declare double @sqrt(double) readnone
