/* import.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2008,2010,2013 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "import.h"
#include "worker_commands.h"
#include "wc_color.hh"
#include "wcdoubleshortkey.hh"
#include "wcpath.hh"
#include "wcfiletype.hh"
#include "wchotkey.hh"
#include "wcbutton.hh"
#include "workerversion.h"
#include "wconfig.h"
#include "simplelist.hh"
#include "datei.h"
#include "worker_locale.h"

void WConfig::setDefaultConfig()
{
  List *np, *nb, *nh, *nf;
  WCPath *p1;
  WCDoubleShortkey *key;
  WCButton *b1;
  WCHotkey *h1;
  List *nc, *keylist;
  FunctionProto *fp,*rfp;
  int i;

  setLang("");
  setRows(6);
  setColumns(7);
  setCacheSize(10);
  List *ncolors=new List();
  ncolors->addElement(new WC_Color(160,160,160));
  ncolors->addElement(new WC_Color(0,0,0));
  ncolors->addElement(new WC_Color(255,255,255));
  ncolors->addElement(new WC_Color(0,85,187));
  ncolors->addElement(new WC_Color(204,34,0));
  ncolors->addElement(new WC_Color(50,180,20));
  ncolors->addElement(new WC_Color(119,0,119));
  ncolors->addElement(new WC_Color(238,170,68));
  setColors(ncolors);
  WC_Color *col=(WC_Color*)ncolors->getFirstElement();
  while(col!=NULL) {
    delete col;
    col=(WC_Color*)ncolors->getNextElement();
  }
  delete ncolors;
  setHBarTop(0,false);
  setHBarTop(1,false);
  setVBarLeft(0,false);
  setVBarLeft(1,true);
  setHBarHeight(0,10);
  setHBarHeight(1,10);
  setVBarWidth(0,10);
  setVBarWidth(1,10);
  clearVisCols( 0 );
  clearVisCols( 1 );
  addListCol( 0, WorkerTypes::LISTCOL_PERM );
  addListCol( 0, WorkerTypes::LISTCOL_SIZE );
  addListCol( 0, WorkerTypes::LISTCOL_NAME );
  addListCol( 0, WorkerTypes::LISTCOL_TYPE );
  addListCol( 1, WorkerTypes::LISTCOL_PERM );
  addListCol( 1, WorkerTypes::LISTCOL_SIZE );
  addListCol( 1, WorkerTypes::LISTCOL_NAME );
  addListCol( 1, WorkerTypes::LISTCOL_TYPE );
  setStatusbar(0,2);
  setStatusbar(1,3);
  setSelLVB(0,2);
  setSelLVB(1,4);
  setUnselLVB(0,1);
  setUnselLVB(1,0);
  setSelDir(0,2);
  setSelDir(1,3);
  setUnselDir(0,3);
  setUnselDir(1,0);
  setSelFile(0,2);
  setSelFile(1,1);
  setUnselFile(0,1);
  setUnselFile(1,0);
  setClockbar(0,2);
  setClockbar(1,6);
  setRequest(0,1);
  setRequest(1,0);
  setLVHeader( 0, 1 );
  setLVHeader( 1, 0 );
  setStartDir(0,"");
  setStartDir(1,"");
#ifdef HAVE_XFT
  setFont( 0, "Sans-10" );
  setFont( 1, "Sans-10" );
  setFont( 2, "Sans-10" );
  setFont( 3, "Sans-10" );
#else
  setFont(0,"fixed");
  setFont(1,"fixed");
  setFont(2,"fixed");
  setFont(3,"fixed");
#endif
  
  // now setup paths
  key=new WCDoubleShortkey();
  keylist = new List();
  keylist->addElement( key );
  np=new List();

  p1=new WCPath();
  p1->setName("/");
  p1->setFG(2);
  p1->setBG(3);
  p1->setPath("/");
  p1->setCheck(true);
  
  key->setMod( 0, 0 );
  key->setKeySym( XK_1, 0 );
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);

  p1=new WCPath();
  p1->setName("$HOME");
  p1->setPath("$HOME");
  p1->setCheck(true);
  
  key->setMod(0, 0);
  key->setKeySym(XK_2,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);

  p1=new WCPath();
  p1->setName("/tmp");
  p1->setPath("/tmp");
  p1->setCheck(true);
  
  key->setMod(0,0);
  key->setKeySym(XK_3,0);
  
  p1->setDoubleKeys( keylist );
  np->addElement(p1);

  p1=new WCPath();
  np->addElement(p1);

  p1=new WCPath();
  np->addElement(p1);

  p1=new WCPath();
  np->addElement(p1);

  setPaths(np);
  
  p1=(WCPath*)np->getFirstElement();
  while(p1!=NULL) {
    delete p1;
    p1=(WCPath*)np->getNextElement();
  }
  delete np;
  
  // setup buttons
  nc=new List();
  nb=new List();
  
  b1=new WCButton();
  b1->setText("All");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Add,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "selectall" );
      fp = tfp;
  }
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("None");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Subtract,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "selectnone" );
      fp = tfp;
  }
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);
  
  b1=new WCButton();
  b1->setText("Invert selection");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Multiply,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "invertall" );
      fp = tfp;
  }
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Patternselect");
  b1->setCheck(true);
  key->setKeySym(XK_KP_Divide,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new FilterSelectOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("PatternUnselect");
  b1->setCheck(true);
  fp=new FilterUnSelectOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Path2otherside");
  b1->setCheck(true);
  fp=new Path2OSideOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Active2Other");
  b1->setCheck(true);
  fp=new EnterDirOp();
  ((EnterDirOp*)fp)->setMode(EnterDirOp::ENTERDIROP_ACTIVE2OTHER);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload");
  b1->setCheck(true);
  key->setKeySym(XK_u,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new ReloadOp();
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_THISSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Reload other");
  b1->setCheck(true);
  fp=new ReloadOp();
  ((ReloadOp*)fp)->setReloadside(ReloadOp::RELOADOP_OTHERSIDE);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<4;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Run");
  b1->setCheck(true);
  key->setMod( ControlMask, 0);
  key->setKeySym(XK_x,0);
  key->setMod( ControlMask, 1);
  key->setKeySym( XK_x, 1 );
  key->setType( WCDoubleShortkey::WCDS_DOUBLE );
  b1->setDoubleKeys( keylist );
  key->setType( WCDoubleShortkey::WCDS_NORMAL );
  fp=new StartProgOp();
  ((StartProgOp*)fp)->setStart(StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY);
  ((StartProgOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<13;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Copy");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setKeySym(XK_F5,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Copy++");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(6);
  key->setMod( ShiftMask, 0);
  key->setKeySym(XK_F5,0);
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Delete");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(4);
  key->setKeySym(XK_F8,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new DeleteOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Rename");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(3);
  key->setKeySym(XK_n,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new RenameOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Move");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setKeySym(XK_F6,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setMove(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Move++");
  b1->setCheck(true);
  b1->setFG(1);
  b1->setBG(7);
  key->setMod( ShiftMask, 0 );
  key->setKeySym(XK_F6,0);
  b1->setDoubleKeys( keylist );
  fp=new CopyOp();
  ((CopyOp*)fp)->setMove(true);
  ((CopyOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  b1=new WCButton();
  b1->setText("Create Symlink");
  b1->setCheck(true);
  key->setMod( ControlMask, 0);
  key->setKeySym(XK_x,0);
  key->setMod( 0, 1);
  key->setKeySym( XK_s, 1 );
  key->setType( WCDoubleShortkey::WCDS_DOUBLE );
  b1->setDoubleKeys( keylist );
  key->setType( WCDoubleShortkey::WCDS_NORMAL );
  fp=new CreateSymlinkOp();
  ((CreateSymlinkOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("new dir");
  b1->setCheck(true);
  fp=new MakeDirOp();
  key->setKeySym(XK_F7,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  nb->addElement(new WCButton());
  
  b1=new WCButton();
  b1->setText("Show");
  b1->setCheck(true);
  fp=new InternalViewOp();
  key->setKeySym(XK_F3,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Edit");
  b1->setCheck(true);
  key->setKeySym(XK_F4,0);
  key->setMod( 0, 0 );
  b1->setDoubleKeys( keylist );
  fp=new OwnOp();
  ((OwnOp*)fp)->setComStr("{scripts}/xeditor {A}");
  nc->addElement(fp);
  rfp=new ReloadOp();
  nc->addElement(rfp);
  b1->setComs(nc);
  delete fp;
  delete rfp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<5;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Change Symlink");
  b1->setCheck(true);
  key->setMod( ControlMask, 0);
  key->setKeySym(XK_x,0);
  key->setMod( ControlMask, 1);
  key->setKeySym( XK_s, 1 );
  key->setType( WCDoubleShortkey::WCDS_DOUBLE );
  b1->setDoubleKeys( keylist );
  key->setType( WCDoubleShortkey::WCDS_NORMAL );
  fp=new ChangeSymlinkOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<3;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("DirSize");
  b1->setCheck(true);
  fp=new DirSizeOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<15;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("ChMod");
  b1->setCheck(true);
  key->setMod( ControlMask, 0);
  key->setKeySym(XK_x,0);
  key->setMod( 0, 1);
  key->setKeySym( XK_c, 1 );
  key->setType( WCDoubleShortkey::WCDS_DOUBLE );
  b1->setDoubleKeys( keylist );
  key->setType( WCDoubleShortkey::WCDS_NORMAL );
  fp=new ChModOp();
  ((ChModOp*)fp)->setRequestFlags(true);
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  for(i=0;i<3;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Volume manager");
  b1->setCheck(true);
  key->setKeySym(XK_v,0);
  key->setMod( Mod1Mask, 0 );
  b1->setDoubleKeys( keylist );
  fp=new VolumeManagerOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Bookmarks");
  b1->setCheck(true);
  key->setKeySym(XK_b,0);
  key->setMod( Mod1Mask, 0 );
  b1->setDoubleKeys( keylist );
  fp=new DirBookmarkOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());

  for(i=0;i<4;i++) nb->addElement(new WCButton());

  b1=new WCButton();
  b1->setText("Quit");
  b1->setCheck(true);
  b1->setFG(2);
  b1->setBG(1);
  fp=new QuitOp();
  nc->addElement(fp);
  b1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nb->addElement(b1);

  nb->addElement(new WCButton());

  // apply list
  setButtons(nb);
  
  b1=(WCButton*)nb->getFirstElement();
  while(b1!=NULL) {
    delete b1;
    b1=(WCButton*)nb->getNextElement();
  }
  delete nb;
  
  // setup hotkeys
  nh=new List();
  
  h1=new WCHotkey();
  h1->setName("Up");
  key->setKeySym(XK_Up,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );

  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "up" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Down");
  key->setKeySym(XK_Down,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "down" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Toggle HiddenFlag");
  key->setKeySym(XK_asciicircum,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ChangeHiddenFlag();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Top");
  key->setKeySym(XK_Home,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "first" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Last");
  key->setKeySym(XK_End,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "last" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageUp");
  key->setKeySym(XK_Prior,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "pageup" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("PageDown");
  key->setKeySym(XK_Next,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "pagedown" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Invert current entry");
  key->setKeySym(XK_Insert,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "selectentry" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Parent");
  key->setKeySym(XK_Left,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "parentdir" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("EnterDir");
  key->setKeySym(XK_Right,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterDirOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (left)");
  key->setMod( Mod1Mask, 0 );
  key->setKeySym(XK_F1,0);
  h1->setDoubleKeys( keylist );
  fp=new ChangeListerSetOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Change lister settings (right)");
  key->setMod( Mod1Mask, 0 );
  key->setKeySym(XK_F2,0);
  h1->setDoubleKeys( keylist );
  fp=new ChangeListerSetOp();
  ((ChangeListerSetOp*)fp)->setMode(ChangeListerSetOp::CLS_RIGHT_LISTER);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Switch side");
  key->setKeySym(XK_Tab,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SwitchListerOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Simulate DoubleClick");
  key->setKeySym(XK_Return,0);
  key->setMod( 0, 0 );
  h1->setDoubleKeys( keylist );
  {
      auto tfp = new ScriptOp();
      tfp->setType( ScriptOp::SCRIPT_EVALCOMMAND );
      tfp->setCommandStr( "simulate_doubleclick" );
      fp = tfp;
  }
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Search Entry");
  key->setKeySym(XK_s,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new SearchEntryOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit path");
  key->setKeySym(XK_Return,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterPathOp();
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Edit other path");
  key->setKeySym(XK_Return,0);
  key->setMod( ControlMask | ShiftMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new EnterPathOp();
  ((EnterPathOp*)fp)->setSide(EnterPathOp::ENTERPATHOP_OTHERSIDE);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll left");
  key->setKeySym(XK_Left,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ScrollListerOp();
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_LEFT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  h1=new WCHotkey();
  h1->setName("Scroll right");
  key->setKeySym(XK_Right,0);
  key->setMod( ControlMask, 0 );
  h1->setDoubleKeys( keylist );
  fp=new ScrollListerOp();
  ((ScrollListerOp*)fp)->setDir(ScrollListerOp::SCROLLLISTEROP_RIGHT);
  nc->addElement(fp);
  h1->setComs(nc);
  delete fp;
  nc->removeAllElements();
  nh->addElement(h1);

  setHotkeys(nh);
  
  h1=(WCHotkey*)nh->getFirstElement();
  while(h1!=NULL) {
    delete h1;
    h1=(WCHotkey*)nh->getNextElement();
  }
  delete nh;

  nf = new List();  
  setFiletypes( nf );
  delete nf;
  initFixTypes();

  delete nc;
  delete key;
  delete keylist;
}
