/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.BaseController;
import esecurity.desktop.Region;
import esecurity.desktop.View;
import esecurity.desktop.jetty.JettyView;
import esecurity.desktop.swt.SWTView;

class ViewFactory {
    ViewFactory() {
    }

    public static View newInstance(BaseController controller, View parent, String title, byte[] image, View.ModalType modalType, Region viewArea, Region dragArea, boolean decorated, boolean resizable, boolean onTop) throws Exception {
        String develop = System.getProperty("esecurity.desktop.develop", "false");
        View view = null;
        Boolean wsServer = false;
        if (develop.equals("true")) {
            try {
                Class<?> wsAdapter = ViewFactory.class.getClassLoader().loadClass("org.eclipse.jetty.websocket.api.WebSocketAdapter");
                Class<?> jetty = ViewFactory.class.getClassLoader().loadClass("org.eclipse.jetty.server.Server");
                wsServer = true;
            }
            catch (Throwable ex) {
                System.out.println("Unable to run on Develop Mode add Jetty jar to Class Path.");
                System.out.println("---------------------------------------------------------------------");
                System.out.println("\n<dependency>\n            <groupId>org.eclipse.jetty</groupId>\n            <artifactId>jetty-server</artifactId>\n            <version>9.4.12.v20180830</version>\n            <scope>provided</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.eclipse.jetty</groupId>\n            <artifactId>jetty-servlet</artifactId>\n            <version>9.4.12.v20180830</version>\n            <scope>provided</scope>\n        </dependency>\n        <dependency>\n            <groupId>org.eclipse.jetty.websocket</groupId>\n            <artifactId>websocket-server</artifactId>\n            <version>9.4.12.v20180830</version>\n            <scope>provided</scope>\n        </dependency>\n        <dependency>\n            <groupId>com.google.code.gson</groupId>\n            <artifactId>gson</artifactId>\n            <version>2.6.2</version>\n            <scope>provided</scope>\n        </dependency>");
                System.out.println("---------------------------------------------------------------------");
                System.out.println("Start on SWT mode... (Release)");
            }
        }
        view = develop.equals("true") && wsServer != false ? new JettyView() : new SWTView();
        view.init(controller, parent, title, image, modalType, viewArea, dragArea, decorated, resizable, onTop);
        return view;
    }
}

