/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardStore;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategy;
import it.arubapec.ca.pkcs11.card.FamilyName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class CardFamily {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String name;
    private transient CardLibrary selected_lib;
    private String defaultPIN;
    private String defaultPUK;
    private CNSStrategy cnsStrategy = CNSStrategy.NONE;
    private DSStrategy dsStrategy = DSStrategy.NONE;
    private FSStrategy fsStrategy = FSStrategy.NONE;
    private transient LinkedList<CardLibrary> libs = null;
    private final List<String> libReferences = new ArrayList<String>();

    public CardFamily(String name, String defPIN, String defPUK, CNSStrategy cnsStrategy, DSStrategy dsStrategy) {
        this(name, defPIN, defPUK, cnsStrategy, dsStrategy, FSStrategy.NONE);
    }

    public CardFamily(String name, String defPIN, String defPUK, CNSStrategy cnsStrategy, DSStrategy dsStrategy, FSStrategy fsStrategy) {
        this.name = name;
        this.defaultPIN = defPIN;
        this.defaultPUK = defPUK;
        this.cnsStrategy = cnsStrategy;
        this.dsStrategy = dsStrategy;
        this.fsStrategy = fsStrategy;
        this.libs = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustomOverride() {
        return this.name.equals((Object)FamilyName.CUSTOM);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultPIN() {
        return this.defaultPIN;
    }

    public void setDefaultPIN(String defaultPIN) {
        this.defaultPIN = defaultPIN;
    }

    public String getDefaultPUK() {
        return this.defaultPUK;
    }

    public void setDefaultPUK(String defaultPUK) {
        this.defaultPUK = defaultPUK;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof CardFamily)) {
            return false;
        }
        CardFamily otherMod = (CardFamily)otherObj;
        return this.name.equals(otherMod.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public LinkedList<CardLibrary> getLib() {
        return this.libs;
    }

    public void addLib(CardLibrary lib) {
        LinkedList<CardLibrary> libs = this.getLib();
        if (!libs.contains(lib)) {
            libs.add(lib);
            this.libReferences.add(lib.getDriveName());
        }
    }

    public String toString() {
        String ret = "";
        if (this.name != null) {
            ret = ret + "name " + this.name + "\n";
        }
        if (this.selected_lib != null) {
            ret = ret + "selected_lib " + this.selected_lib.getDrive() + "\n";
        }
        if (this.defaultPIN != null) {
            ret = ret + "defaultPIN " + this.defaultPIN + "\n";
        }
        if (this.defaultPUK != null) {
            ret = ret + "defaultPUK " + this.defaultPUK + "\n";
        }
        if (this.cnsStrategy != null) {
            ret = ret + "cnsStrategy " + this.cnsStrategy.name() + "\n";
        }
        if (this.dsStrategy != null) {
            ret = ret + "dsStrategy " + this.dsStrategy.name() + "\n";
        }
        if (this.fsStrategy != null) {
            ret = ret + "fsStrategy " + this.fsStrategy.name() + "\n";
        }
        if (this.libReferences != null) {
            for (String ref : this.libReferences) {
                ret = ret + "lib ref " + ref + "\n";
            }
        }
        if (this.libs != null) {
            for (CardLibrary lib : this.libs) {
                ret = ret + "lib " + lib.getDriveName() + "\n";
                if (lib.getWindowsDrive() != null) {
                    ret = ret + "    " + lib.getWindowsDrive() + "\n";
                }
                if (lib.getLinuxDrive() != null) {
                    ret = ret + "    " + lib.getLinuxDrive() + "\n";
                }
                if (lib.getOsxDrive() == null) continue;
                ret = ret + "    " + lib.getOsxDrive() + "\n";
            }
        }
        return ret;
    }

    public CardLibrary getSelected_lib() {
        return this.selected_lib;
    }

    public void setSelected_lib(CardLibrary selected_lib) {
        this.selected_lib = selected_lib;
    }

    void rebuild(CardStore store) throws IOException {
        if (this.libs == null) {
            this.libs = new LinkedList();
        }
        for (String cardLibraryName : this.libReferences) {
            boolean found = false;
            for (CardLibrary cardLibrary : store.getCardLibraries()) {
                if (!cardLibrary.getDriveName().equals(cardLibraryName)) continue;
                this.libs.add(cardLibrary);
                found = true;
                break;
            }
            if (found) continue;
            throw new IOException("No Drive Found --> " + cardLibraryName);
        }
    }

    public NativePKCS11 getPKCS11() {
        return this.getPKCS11(true);
    }

    public NativePKCS11 getPKCS11(boolean doInitialization) {
        if (this.getSelected_lib() != null) {
            logger.info("pkcs11: " + this.getSelected_lib().getDriveName());
            return NativePKCS11.getInstance(this.getSelected_lib().getDrive(), doInitialization);
        }
        for (CardLibrary lib : this.getLib()) {
            logger.info("look for library " + lib.getDriveName());
            try {
                NativePKCS11 nat = NativePKCS11.getInstance(lib.getDrive(), doInitialization);
                this.setSelected_lib(lib);
                logger.info("library selected");
                return nat;
            }
            catch (Throwable tr) {
                logger.debug("library not found");
            }
        }
        throw new UnsatisfiedLinkError("Unable to link any library of family " + this.getName());
    }

    public CNSStrategy getCnsStrategy() {
        return this.cnsStrategy;
    }

    public DSStrategy getDsStrategy() {
        return this.dsStrategy;
    }

    public FSStrategy getFsStrategy() {
        return this.fsStrategy;
    }
}

