/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.pkcs11.nat.Platform;

public class CardLibrary {
    public static final CardLibrary bit4IdUniversal = new CardLibrary("Bit4Id middleware for Incard Oberthur and Athena", "bit4xpki", "libbit4xpki.dylib", "libbit4xpki.so");
    public static final CardLibrary bit4IdUniversalEmbedded = new CardLibrary("Bit4Id middleware for Incard Oberthur and Athena|embedded", "driver/bit4xpki", "driver/libbit4xpki.dylib", "driver/libbit4xpki.so");
    public static final CardLibrary incardBit4id = new CardLibrary("Incard Bit4Id middleware", "bit4ipki", "libbit4ipki.dylib", "libbit4ipki.so");
    public static final CardLibrary oberthurBit4id = new CardLibrary("Oberthur Bit4Id middleware", "bit4opki", "libbit4opki.dylib", "libbit4opki.so");
    public static final CardLibrary incard = new CardLibrary("Incard Pkcs11", "stPKCS11", "libstPKCS11.dylib", "libstpkcs11.so");
    public static final CardLibrary incardold = new CardLibrary("Incard Pkcs11 Old", "inp11lib", "libSafeDiveP11.dylib", "libSafeDiveP11.so");
    public static final CardLibrary eToken = new CardLibrary("eToken Pkcs11", "eTPKCS11", null, null);
    public static final CardLibrary athena = new CardLibrary("Athena Pkcs11", "asepkcs", "libASEP11.dylib", "libASEP11.so");
    public static final CardLibrary eutron = new CardLibrary("Eutron Pkcs11", "cmP11", null, null);
    public static final CardLibrary siemens = new CardLibrary("Siemens Pkcs11", "SI_PKCS11", null, null);
    public static final CardLibrary cardos = new CardLibrary("Siemens Cardos", "cardos11", "libcardos11.dylib", "libcardos11.so");
    public static final CardLibrary cardos64 = new CardLibrary("Siemens Cardos 64bit", "cardos11_64", "libcardos11_64.dylib", "libcardos11_64.so");
    public static final CardLibrary cardosCarige = new CardLibrary("Siemens Cardos Carige", "siecap11", null, null);
    public static final CardLibrary cardosCarige2 = new CardLibrary("Siemens Cardos Carige2", "gclib", null, null);
    public static final CardLibrary gemalto = new CardLibrary("Gemalto Pkcs11", "eToken", null, null);
    public static final CardLibrary cie = new CardLibrary("Italian Electronic Identity Card Pkcs11", "CIEPKI", "libcie-pkcs11.dylib", null);
    private String driveName;
    private String windowsDrive = null;
    private String osxDrive = null;
    private String linuxDrive = null;

    private CardLibrary(String driveName, String windowsDrive, String osxDrive, String linuxDrive) {
        this.driveName = driveName;
        this.windowsDrive = windowsDrive;
        this.linuxDrive = linuxDrive;
        this.osxDrive = osxDrive;
    }

    public String getDrive() {
        if (Platform.isWindows()) {
            return this.windowsDrive;
        }
        if (Platform.isMac()) {
            return this.osxDrive;
        }
        if (Platform.isLinux()) {
            return this.linuxDrive;
        }
        return null;
    }

    public String getDriveName() {
        return this.driveName;
    }

    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    public String getWindowsDrive() {
        return this.windowsDrive;
    }

    public void setWindowsDrive(String windowsDrive) {
        this.windowsDrive = windowsDrive;
    }

    public String getOsxDrive() {
        return this.osxDrive;
    }

    public void setOsxDrive(String osxDrive) {
        this.osxDrive = osxDrive;
    }

    public String getLinuxDrive() {
        return this.linuxDrive;
    }

    public void setLinuxDrive(String linuxDrive) {
        this.linuxDrive = linuxDrive;
    }

    public String toString() {
        String ret = "";
        if (this.driveName != null) {
            ret = ret + "driveName " + this.driveName + "\n";
        }
        if (this.windowsDrive != null) {
            ret = ret + "windowsDrive " + this.windowsDrive + "\n";
        }
        if (this.linuxDrive != null) {
            ret = ret + "linuxDrive " + this.linuxDrive + "\n";
        }
        if (this.osxDrive != null) {
            ret = ret + "osxDrive " + this.osxDrive + "\n";
        }
        return ret;
    }

    public boolean equals(CardLibrary lib) {
        if (!lib.getDriveName().equals(this.driveName)) {
            return false;
        }
        if (lib.getWindowsDrive() != null && this.windowsDrive == null || lib.getWindowsDrive() == null && this.windowsDrive != null) {
            return false;
        }
        if (this.windowsDrive != null && !lib.getWindowsDrive().equals(this.windowsDrive)) {
            return false;
        }
        if (lib.getOsxDrive() != null && this.osxDrive == null || lib.getOsxDrive() == null && this.osxDrive != null) {
            return false;
        }
        if (this.osxDrive != null && !lib.getOsxDrive().equals(this.osxDrive)) {
            return false;
        }
        if (lib.getLinuxDrive() != null && this.linuxDrive == null || lib.getLinuxDrive() == null && this.linuxDrive != null) {
            return false;
        }
        return this.linuxDrive == null || lib.getLinuxDrive().equals(this.linuxDrive);
    }

    public static class CustomCardLibrary
    extends CardLibrary {
        public CustomCardLibrary(String libraryName) {
            super("Custom Library -> " + libraryName, libraryName, libraryName, libraryName);
        }
    }
}

