/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.SignedData;

public class PadesStepSignatureCMSSignedDataCheck
extends SingleValidationSubStepImpl {
    public PadesStepSignatureCMSSignedDataCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null && param.getSignature() != null && param.getSignature().getPadesSpecific() != null) {
            SignatureInformation signInfo = param.getSignature();
            PadesSpecific padesSpec = signInfo.getPadesSpecific();
            Date validationDate = param.getCalculatedValidationDate().getDate();
            if (validationDate.after(Constants.DPCM_AGID_121_2019)) {
                if (padesSpec.isMultipleSigners()) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0013_FORMAT_PADES_NOTVALID_CMSMULTISIGNERS, new Object[0]);
                }
                if (signInfo.getPadesSpecific().getSubFilter().equalsIgnoreCase("ETSI.CAdES.detached")) {
                    ASN1Set uAttrs = signInfo.getSignerInfoData().getSignerInfo().getUnauthenticatedAttributes();
                    ASN1Set sAttrs = signInfo.getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
                    if (uAttrs != null && sAttrs == null) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0015_FORMAT_PADES_NOTVALID_MISSINGSIGNEDATTRS, new Object[0]);
                    }
                    if (sAttrs != null) {
                        boolean haveMessageDigest = false;
                        boolean haveContentType = false;
                        boolean haveSigningCertificate = false;
                        boolean haveSigningCertificateV2 = false;
                        boolean haveSigningTime = false;
                        boolean haveCounterSignature = false;
                        boolean haveContentReference = false;
                        boolean haveContentIdentifier = false;
                        boolean haveContentHint = false;
                        boolean haveCommitmentType = false;
                        boolean haveSignerLocation = false;
                        for (int i = 0; i < sAttrs.size(); ++i) {
                            String id = "";
                            id = sAttrs.getObjectAt(i) instanceof DERSequence ? ((DERSequence)sAttrs.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)sAttrs.getObjectAt(i)).getObjectAt(0).toString();
                            if (id.equals(CMSAttributes.messageDigest.getId())) {
                                haveMessageDigest = true;
                                continue;
                            }
                            if (id.equals(CMSAttributes.contentType.getId())) {
                                haveContentType = true;
                                continue;
                            }
                            if (id.equals(CMSAttributes.signingTime.getId())) {
                                haveSigningTime = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_signingCertificate.getId())) {
                                haveSigningCertificate = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_signingCertificateV2.getId())) {
                                haveSigningCertificateV2 = true;
                                continue;
                            }
                            if (id.equals(SignedData.pkcs_9_at_counterSignature.getId())) {
                                haveCounterSignature = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_contentReference.getId())) {
                                haveContentReference = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_contentIdentifier.getId())) {
                                haveContentIdentifier = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_contentHint.getId())) {
                                haveContentHint = true;
                                continue;
                            }
                            if (id.equals(SignedData.id_aa_ets_commitmentType.getId())) {
                                haveCommitmentType = true;
                                continue;
                            }
                            if (!id.equals(SignedData.id_aa_ets_signerLocation.getId())) continue;
                            haveSignerLocation = true;
                        }
                        if (!haveContentType || !haveMessageDigest || !haveSigningCertificate && !haveSigningCertificateV2) {
                            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0015_FORMAT_PADES_NOTVALID_MISSINGSIGNEDATTRS, new Object[0]);
                        }
                        if (haveCounterSignature || haveContentReference || haveContentIdentifier || haveContentHint || param.getSignature().getPadesSpecific().getReason() != null && haveCommitmentType || haveSignerLocation) {
                            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0016_FORMAT_PADES_NOTVALID_UNESPECTEDSIGNEDATTRS, new Object[0]);
                        }
                    }
                }
            }
        }
        return null;
    }
}

