/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDtsTimeStampOptions;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;

public class PadesDtsGenerator
extends BaseGenerator<PadesDtsTimeStampOptions> {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    SignatureOptions sig_options;

    public void validateOptions(PadesDtsTimeStampOptions opts) throws CapiException {
        if (opts == null) {
            throw new CapiException("Invalid Signature Options", 1001);
        }
        if (opts.getInput() == null) {
            throw new CapiException("Invalid Input NULL", 1001);
        }
        if (opts.getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (opts.getTSAClient() == null) {
            throw new CapiException("Invalid TSA Client", 1001);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGenerate() throws CapiException {
        ScratchFile SCRATCH_FILE_TEMP = null;
        PDDocument document = null;
        OutputStream os = null;
        InputStream is = null;
        Closeable reopenhandler = null;
        Closeable temp_handler = null;
        File tempf = null;
        try {
            SCRATCH_FILE_TEMP = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
            is = ((PadesDtsTimeStampOptions)((Object)this.options)).getInput().getInputAsNewStream();
            Long document_size = ((PadesDtsTimeStampOptions)((Object)this.options)).getInput().getTotalSize();
            os = ((PadesDtsTimeStampOptions)((Object)this.options)).getOutput().getAsOutputStream();
            RandomAccess pdfFileBuffer = SCRATCH_FILE_TEMP.createBuffer(is);
            if (!this.checkPdf((RandomAccessRead)pdfFileBuffer)) throw new IOException("Il file che stato sottoposto alla firma non \u00e8 di tipo PDF");
            document = this.loadDoc((PadesDtsTimeStampOptions)((Object)this.options), SCRATCH_FILE_TEMP, (RandomAccessRead)pdfFileBuffer);
            LinkedList<PDSignatureField> emptySignatureFields = new LinkedList<PDSignatureField>();
            if (document.getDocumentCatalog().getAcroForm() != null) {
                if (PadesUtils.isBlockedPdf(document)) {
                    if (!logger.isDebugEnabled()) throw new CapiException("Document is certified and no changes are allowed.", 50026);
                    logger.debug("Document certified and no changes allowed");
                    throw new CapiException("Document is certified and no changes are allowed.", 50026);
                }
                for (PDField filed : document.getDocumentCatalog().getAcroForm().getFields()) {
                    emptySignatureFields.addAll(PadesUtils.parseEmptyField(filed));
                }
            }
            this.prepareDts(document, (PadesDtsTimeStampOptions)((Object)this.options), document_size, emptySignatureFields);
            document.saveIncremental(os);
            os.flush();
        }
        catch (InvalidPasswordException ex) {
            try {
                throw new CapiException(ex.getMessage(), 50004, (Throwable)ex);
                catch (IOException ex2) {
                    if (ex2.getCause() != null && ex2.getCause() instanceof TSAException) {
                        throw (TSAException)ex2.getCause();
                    }
                    if (ex2.getCause() == null) throw new CapiException("Pades generation IOException: " + ex2.getMessage(), 50040);
                    if (!(ex2.getCause() instanceof CapiException)) throw new CapiException("Pades generation IOException: " + ex2.getMessage(), 50040);
                    throw (CapiException)ex2.getCause();
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(SCRATCH_FILE_TEMP);
                Util.closeQuietly(document);
                Util.closeQuietly(reopenhandler);
                Util.closeQuietly(temp_handler);
                if (tempf != null && tempf.exists()) {
                    tempf.delete();
                }
                IOUtils.closeQuietly((Closeable)this.sig_options);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)SCRATCH_FILE_TEMP);
        Util.closeQuietly((Closeable)document);
        Util.closeQuietly(reopenhandler);
        Util.closeQuietly(temp_handler);
        if (tempf != null && tempf.exists()) {
            tempf.delete();
        }
        IOUtils.closeQuietly((Closeable)this.sig_options);
    }

    private void prepareDts(PDDocument document, PadesDtsTimeStampOptions options, Long document_size, List<PDSignatureField> emptySignatureFields) throws CapiException, IOException {
        LinkedList<PadesSignatureInformation> signatures = PadesUtils.retrieveNotEmptySignatures(document);
        if (signatures != null && signatures.size() == 0 && document.getDocumentCatalog().getAcroForm() != null && document.getDocumentCatalog().getAcroForm().getNeedAppearances()) {
            document.getDocumentCatalog().getAcroForm().getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
        this.sig_options = new SignatureOptions();
        document.addSignature(signature, (SignatureInterface)new SignatureInterfaceImpl(options), this.sig_options);
    }

    private PDDocument loadDoc(PadesDtsTimeStampOptions option, ScratchFile SCRATCH_FILE_TEMP, RandomAccessRead pdfFileBuffer) throws IOException, CapiException {
        String decryptPassword = null;
        PDFParser parser = null;
        if (option.getOwnerPassword() == null) {
            logger.debug("[initialize] decrypting password is null...");
        } else {
            logger.debug("[initialize] decrypting password is not null...");
            decryptPassword = option.getOwnerPassword();
        }
        parser = decryptPassword != null ? new PDFParser(pdfFileBuffer, decryptPassword, null, null, SCRATCH_FILE_TEMP) : new PDFParser(pdfFileBuffer, SCRATCH_FILE_TEMP);
        PDDocument document = parser.parse();
        if (document.getCurrentAccessPermission() != null && !document.getCurrentAccessPermission().canModify() && !document.getCurrentAccessPermission().canModifyAnnotations()) {
            throw new CapiException("Cannot decrypt PDF, the password is incorrect", 50004);
        }
        return document;
    }

    private boolean checkPdf(RandomAccessRead rar) throws IOException {
        boolean bRet = false;
        byte[] data = new byte[5];
        int nRead = rar.read(data, 0, data.length);
        if (nRead != -1) {
            String str = new String(data);
            bRet = str.startsWith("%FDF-") || str.startsWith("%PDF-");
        }
        rar.seek(0L);
        return bRet;
    }

    private class SignatureInterfaceImpl
    implements SignatureInterface {
        TimeStampOptions option;

        public SignatureInterfaceImpl(PadesDtsTimeStampOptions dts_option) {
            this.option = dts_option;
        }

        public byte[] sign(InputStream content) throws IOException {
            byte[] tsr = null;
            try {
                tsr = this.option.getTSAClient().stampEx(content, this.option);
            }
            catch (TSAException ex) {
                logger.debug("Unable save envelope! Got an exception " + ex.getMessage());
                throw new IOException("Unable save envelope! Got an exception " + ex.getMessage(), ex);
            }
            return tsr;
        }
    }
}

