/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.validator.parser.utils.OcspUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.CompareByteRangeSignature;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.StringWrap;
import it.actalis.ellips.capi.pdf.TextContainer;
import it.actalis.vol.utils.Constants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class PadesUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String FONT_REGULAR_RESOURCE = "/font/Lato-Regular.ttf";
    public static final String FONT_BOLD_RESOURCE = "/font/Lato-Bold.ttf";
    public static final String FONT_NAME = "lato";
    private static int pageRotation;
    private static boolean isFontRegistered;

    public static boolean isBlockedPdf(PDDocument document) {
        PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
        LinkedList<PadesSignatureInformation> list = new LinkedList<PadesSignatureInformation>();
        COSDictionary trailer = document.getDocument().getTrailer();
        if (trailer == null) {
            logger.error("[initialize] trailer is null.");
            return false;
        }
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        if (root == null) {
            logger.error("[initialize] root is null");
            return false;
        }
        COSDictionary dicDSS = (COSDictionary)root.getDictionaryObject("DSS");
        List fields = acroForm.getFields();
        if (fields == null || fields.size() <= 0) {
            logger.debug("[findSignature] no fields");
            return false;
        }
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo(document);
        for (PDField pdField : fields) {
            PadesUtils.parseField(pdField, list, padesDssInfo);
        }
        for (PadesSignatureInformation info : list) {
            if (info.getCertificationLevel() != 1) continue;
            return true;
        }
        return false;
    }

    private static void parseField(PDField pdField, LinkedList<PadesSignatureInformation> list, PadesDssInfo padesDssInfo) {
        if (pdField instanceof PDSignatureField) {
            PDSignatureField signature_field = (PDSignatureField)pdField;
            String sigName = signature_field.getFullyQualifiedName();
            logger.debug("[findSignature] Found Signature Name: " + sigName);
            if (signature_field.getValue() == null) {
                logger.debug("[findSignature] Empty SignatureField ignored.");
            }
            if (PadesUtils.isSignatureField(signature_field.getCOSObject()) && !PadesUtils.contains(sigName, list)) {
                list.add(new PadesSignatureInformation(signature_field, padesDssInfo));
                logger.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pdField instanceof PDNonTerminalField) {
            for (PDField pdFieldInt : ((PDNonTerminalField)pdField).getChildren()) {
                PadesUtils.parseField(pdFieldInt, list, padesDssInfo);
            }
        }
    }

    public static List<PDSignatureField> parseEmptyField(PDField pdField) {
        LinkedList<PDSignatureField> emptySignatureFields = new LinkedList<PDSignatureField>();
        if (pdField instanceof PDSignatureField) {
            PDSignatureField signature_field = (PDSignatureField)pdField;
            String sigName = signature_field.getFullyQualifiedName();
            logger.debug("[findSignature] Found Signature Name: " + sigName);
            if (signature_field.getValue() == null) {
                emptySignatureFields.add(signature_field);
                logger.debug("[findSignature] Empty SignatureField added.");
            }
        }
        if (pdField instanceof PDNonTerminalField) {
            for (PDField pdFieldInt : ((PDNonTerminalField)pdField).getChildren()) {
                emptySignatureFields.addAll(PadesUtils.parseEmptyField(pdFieldInt));
            }
        }
        return emptySignatureFields;
    }

    private static boolean isSignatureField(COSDictionary field) {
        COSString sigName = (COSString)field.getDictionaryObject(COSName.T);
        if (sigName != null) {
            logger.debug("[initialize][isSignatureField] Signature: " + sigName.getString());
        } else {
            logger.debug("[initialize][isSignatureField] Signature: warning sigName is null");
        }
        COSDictionary valueField = (COSDictionary)field.getDictionaryObject(COSName.V);
        if (valueField != null) {
            COSName subFilter = (COSName)valueField.getDictionaryObject(COSName.getPDFName((String)"SubFilter"));
            if (subFilter != null) {
                if (subFilter.getName().equals("adbe.x509.rsa_sha1")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.x509.rsa_sha1");
                    return true;
                }
                if (subFilter.getName().equals("adbe.pkcs7.sha1")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.sha1");
                    return true;
                }
                if (subFilter.getName().equals("adbe.pkcs7.detached")) {
                    logger.debug("[initialize][isSignatureField] subfilter: adbe.pkcs7.detached");
                    return true;
                }
                if (subFilter.getName().equals("ETSI.CAdES.detached")) {
                    logger.debug("[initialize][isSignatureField] subfilter: ETSI.CAdES.detached");
                    return true;
                }
                if (subFilter.getName().equals("ETSI.RFC3161")) {
                    logger.debug("[initialize][isSignatureField] subfilter: ETSI.RFC3161");
                    return true;
                }
                logger.error("[initialize][isSignatureField] unknown subfilter:" + subFilter);
                return true;
            }
            logger.debug("[initialize][isSignatureField] Missing subfilter");
        } else {
            logger.debug("[initialize][isSignatureField] is empty");
        }
        return false;
    }

    private static boolean contains(String sigName, LinkedList<PadesSignatureInformation> list) {
        if (sigName == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            String currSigName = list.get(i).getName();
            if (currSigName == null || !currSigName.equals(sigName)) continue;
            return true;
        }
        return false;
    }

    private static PDRectangle createSignatureRectangle(PDPage page, Rectangle2D humanRect) {
        float x = (float)humanRect.getX();
        float y = (float)humanRect.getY();
        float width = (float)humanRect.getWidth();
        float height = (float)humanRect.getHeight();
        PDRectangle pageRect = page.getCropBox();
        PDRectangle rect = new PDRectangle();
        switch (pageRotation) {
            case 90: {
                rect.setLowerLeftY(x);
                rect.setUpperRightY(x + width);
                rect.setLowerLeftX(y);
                rect.setUpperRightX(y + height);
                break;
            }
            case 180: {
                rect.setUpperRightX(pageRect.getWidth() - x);
                rect.setLowerLeftX(pageRect.getWidth() - x - width);
                rect.setLowerLeftY(y);
                rect.setUpperRightY(y + height);
                break;
            }
            case 270: {
                rect.setLowerLeftY(pageRect.getHeight() - x - width);
                rect.setUpperRightY(pageRect.getHeight() - x);
                rect.setLowerLeftX(pageRect.getWidth() - y - height);
                rect.setUpperRightX(pageRect.getWidth() - y);
                break;
            }
            default: {
                rect.setLowerLeftX(x);
                rect.setUpperRightX(x + width);
                rect.setLowerLeftY(pageRect.getHeight() - y - height);
                rect.setUpperRightY(pageRect.getHeight() - y);
            }
        }
        return rect;
    }

    public static String createVisualSignatureImage(CapiPDFApparence apparence) throws IOException {
        Rect textRect;
        String printedText = PadesUtils.retrieveText(apparence);
        float appearenceWidth = apparence.getWidth();
        float appearenceHeight = apparence.getHeight();
        float xTextPosition = 0.0f;
        float yTextPosition = 0.0f;
        int fontSize = apparence.getFontSize();
        boolean scaleFont = apparence.isScaleFont();
        BufferedImage image = apparence.getImage();
        StringWrap stringWrap = new StringWrap();
        BufferedImage bufferedImage = new BufferedImage((int)appearenceWidth, (int)appearenceHeight, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        if (image != null) {
            float imageWidth = image.getWidth();
            float imageHeight = image.getHeight();
            float resizedHeight = appearenceHeight;
            float resizedWidth = appearenceWidth;
            String appOrientation = "H";
            if (!apparence.isOnly_image()) {
                float wimg = imageWidth;
                float wval = wimg / appearenceWidth;
                float himg = imageHeight;
                float hval = himg / appearenceHeight;
                if (wval > hval) {
                    resizedHeight = appearenceHeight / 2.0f;
                    appOrientation = "V";
                } else {
                    resizedWidth = appearenceWidth / 2.0f;
                    appOrientation = "H";
                }
            }
            Rectangle2D imageRect = PadesUtils.resizeAndCenterImageFlipped(imageWidth, imageHeight, resizedWidth, resizedHeight, apparence.getResizeMode(), appOrientation);
            if (apparence.isPDFASignature()) {
                image = apparence.isGray() ? PadesUtils.convertToGray(image) : PadesUtils.convertToRgb(image);
            }
            graphics.drawImage(image.getScaledInstance((int)imageRect.getWidth(), (int)imageRect.getHeight(), 4), (int)imageRect.getX(), (int)imageRect.getY(), null);
            if (!apparence.isOnly_image()) {
                textRect = appOrientation.equals("H") ? new Rect((float)(imageRect.getX() + imageRect.getWidth()), 0.0, imageRect.getX() + imageRect.getWidth(), appearenceHeight) : new Rect(0.0, imageRect.getY() + imageRect.getHeight(), appearenceWidth, (double)appearenceHeight - (imageRect.getY() + imageRect.getHeight()));
                PDType0Font font = PDType0Font.load((PDDocument)apparence.getPdDocument(), (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
                List<String> wrappedText = PadesUtils.checkNewLine(printedText);
                wrappedText = stringWrap.performWrap(wrappedText, (float)((RectangularShape)textRect).getWidth(), (PDFont)font, fontSize);
                try {
                    if (scaleFont) {
                        while (!PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)((RectangularShape)textRect).getWidth(), (float)((RectangularShape)textRect).getHeight()) && fontSize < 100) {
                            wrappedText = PadesUtils.checkNewLine(printedText);
                            wrappedText = stringWrap.performWrap(wrappedText, (float)((RectangularShape)textRect).getWidth(), (PDFont)font, ++fontSize);
                        }
                    }
                    while (PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)((RectangularShape)textRect).getWidth(), (float)((RectangularShape)textRect).getHeight()) && fontSize > 1) {
                        wrappedText = PadesUtils.checkNewLine(printedText);
                        wrappedText = stringWrap.performWrap(wrappedText, (float)((RectangularShape)textRect).getWidth(), (PDFont)font, --fontSize);
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                PadesUtils.registerFont();
                graphics.setFont(new Font(FONT_NAME, 0, fontSize));
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.setColor(Color.BLACK);
                int pos = (int)((RectangularShape)textRect).getY();
                for (String line : wrappedText) {
                    graphics.drawString(line, (int)((RectangularShape)textRect).getX(), pos += fontSize);
                }
            }
        } else {
            textRect = new Rect(xTextPosition, yTextPosition, appearenceWidth, appearenceHeight);
            PDType0Font font = PDType0Font.load((PDDocument)apparence.getPdDocument(), (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
            List<String> wrappedText = PadesUtils.checkNewLine(printedText);
            wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, fontSize);
            try {
                if (scaleFont) {
                    while (!PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)textRect.getWidth(), (float)textRect.getHeight()) && fontSize < 100) {
                        wrappedText = PadesUtils.checkNewLine(printedText);
                        wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, ++fontSize);
                    }
                }
                while (PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)textRect.getWidth(), (float)textRect.getHeight()) && fontSize > 1) {
                    wrappedText = PadesUtils.checkNewLine(printedText);
                    wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, --fontSize);
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            graphics.setFont(new Font(FONT_NAME, 0, fontSize));
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setColor(Color.BLACK);
            int pos = (int)yTextPosition;
            for (String line : wrappedText) {
                graphics.drawString(line, (int)textRect.getX(), pos += fontSize);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        return new String(Base64.encode((byte[])baos.toByteArray()));
    }

    private static void registerFont() throws IOException {
        if (isFontRegistered) {
            return;
        }
        try {
            Font latoFont = Font.createFont(0, PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(latoFont);
            isFontRegistered = true;
        }
        catch (FontFormatException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createVisualSignature(CapiPDFApparence apparence) throws IOException {
        PDDocument signedDoc = new PDDocument();
        PDPage pageToSign = apparence.getPdDocument().getPage(apparence.getPage() - 1);
        pageRotation = pageToSign.getRotation();
        try {
            PDPage signedPage = new PDPage(pageToSign.getMediaBox());
            signedDoc.addPage(signedPage);
            PDAcroForm acroForm = new PDAcroForm(signedDoc);
            signedDoc.getDocumentCatalog().setAcroForm(acroForm);
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
            List acroFormFields = acroForm.getFields();
            acroForm.setSignaturesExist(true);
            acroForm.setAppendOnly(true);
            acroForm.getCOSObject().setDirect(true);
            acroFormFields.add(signatureField);
            Rect rect = pageRotation == 90 || pageRotation == 270 ? new Rect(apparence.getPosX(), signedPage.getCropBox().getWidth() - apparence.getPosY(), apparence.getWidth(), apparence.getHeight()) : new Rect(apparence.getPosX(), signedPage.getCropBox().getHeight() - apparence.getPosY(), apparence.getWidth(), apparence.getHeight());
            PDRectangle rectangle = PadesUtils.createSignatureRectangle(pageToSign, rect);
            widget.setRectangle(rectangle);
            PDStream stream = new PDStream(signedDoc);
            PDFormXObject form = new PDFormXObject(stream);
            PDResources res = new PDResources();
            form.setResources(res);
            form.setFormType(1);
            PDRectangle bbox = new PDRectangle(rectangle.getWidth(), rectangle.getHeight());
            Matrix initialScale = null;
            switch (pageRotation) {
                case 90: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    break;
                }
                case 180: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                    break;
                }
                case 270: {
                    form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                    initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                    break;
                }
            }
            form.setBBox(bbox);
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            appearance.getCOSObject().setDirect(true);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
            appearance.setNormalAppearance(appearanceStream);
            widget.setAppearance(appearance);
            PadesUtils.printToPage(new PDPageContentStream(signedDoc, appearanceStream), initialScale, apparence, signedDoc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            signedDoc.save((OutputStream)baos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            signedDoc.close();
        }
        return null;
    }

    private static void printToPage(PDPageContentStream pageStream, Matrix initialScale, CapiPDFApparence apparence, PDDocument doc) throws IOException {
        if (initialScale != null) {
            pageStream.transform(initialScale);
        }
        pageStream.saveGraphicsState();
        String printedText = PadesUtils.retrieveText(apparence);
        float appearenceWidth = apparence.getWidth();
        float appearenceHeight = apparence.getHeight();
        float xTextPosition = 0.0f;
        float yTextPosition = appearenceHeight;
        BufferedImage image = apparence.getImage();
        if (image != null) {
            float imageWidth = image.getWidth();
            float imageHeight = image.getHeight();
            float resizedHeight = appearenceHeight;
            float resizedWidth = appearenceWidth;
            String appOrientation = "H";
            if (!apparence.isOnly_image()) {
                float wimg = imageWidth;
                float wval = wimg / appearenceWidth;
                float himg = imageHeight;
                float hval = himg / appearenceHeight;
                if (wval > hval) {
                    resizedHeight = appearenceHeight / 2.0f;
                    appOrientation = "V";
                } else {
                    resizedWidth = appearenceWidth / 2.0f;
                    appOrientation = "H";
                }
            }
            Rectangle2D imageRect = PadesUtils.resize_and_center_image(imageWidth, imageHeight, resizedWidth, resizedHeight, apparence.getResizeMode(), appOrientation);
            PDImageXObject img = PadesUtils.retrieveImage(image, doc, apparence);
            pageStream.drawImage(img, (float)imageRect.getX(), (float)imageRect.getY(), (float)imageRect.getWidth(), (float)imageRect.getHeight());
            pageStream.restoreGraphicsState();
            if (!apparence.isOnly_image()) {
                Rect textRect = appOrientation.equals("H") ? new Rect((float)(imageRect.getX() + imageRect.getWidth()), appearenceHeight, (double)appearenceWidth - (imageRect.getX() + imageRect.getWidth()), appearenceHeight) : new Rect(0.0, imageRect.getY(), appearenceWidth, imageRect.getY());
                PadesUtils.printText(printedText, apparence.getFontSize(), apparence.isScaleFont(), textRect, pageStream, doc);
            }
        } else {
            PadesUtils.printText(printedText, apparence.getFontSize(), apparence.isScaleFont(), new Rect(xTextPosition, yTextPosition, appearenceWidth, appearenceHeight), pageStream, doc);
        }
        pageStream.close();
    }

    private static PDImageXObject retrieveImage(BufferedImage image, PDDocument doc, CapiPDFApparence apparence) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (apparence.isPDFASignature()) {
            image = apparence.isGray() ? PadesUtils.convertToGray(image) : PadesUtils.convertToRgb(image);
        }
        ImageIO.write((RenderedImage)image, "png", baos);
        return PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])baos.toByteArray(), (String)"png");
    }

    private static int calculateFont(String text, int fontSize, boolean scaleFont, Rectangle2D textRect, PDFont font) {
        float charHeight = (float)fontSize * 1.5f;
        float charWidth = (float)fontSize * font.getAverageFontWidth() / 1000.0f;
        int lineNumber = (int)(textRect.getHeight() / (double)charHeight);
        float textLenght = (float)text.length() * charWidth;
        if (((double)lineNumber * textRect.getWidth() - (double)textLenght > (double)lineNumber * textRect.getWidth() / 10.0 || (double)lineNumber * textRect.getWidth() - (double)textLenght < (double)(-lineNumber) * textRect.getWidth() / 10.0) && !scaleFont) {
            return fontSize;
        }
        for (int maxLoop = 0; (double)lineNumber * textRect.getWidth() - (double)textLenght > (double)lineNumber * textRect.getWidth() / 10.0 || (double)lineNumber * textRect.getWidth() - (double)textLenght < (double)(-lineNumber) * textRect.getWidth() / 10.0 && maxLoop < 30; ++maxLoop) {
            fontSize = (double)textLenght < (double)lineNumber * textRect.getWidth() ? ++fontSize : --fontSize;
            charHeight = (float)fontSize * 1.5f;
            charWidth = (float)fontSize * font.getAverageFontWidth() / 1000.0f;
            lineNumber = (int)(textRect.getHeight() / (double)charHeight);
            textLenght = (float)text.length() * charWidth;
        }
        return fontSize > 0 ? fontSize : 1;
    }

    private static void printText(String printedText, int fontSize, boolean scaleFont, Rectangle2D textRect, PDPageContentStream pageStream, PDDocument document) throws IOException {
        PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)PadesUtils.class.getResourceAsStream(FONT_REGULAR_RESOURCE));
        pageStream.beginText();
        pageStream.setNonStrokingColor(Color.black);
        StringWrap stringWrap = new StringWrap();
        pageStream.setFont((PDFont)font, (float)fontSize);
        List<String> wrappedText = PadesUtils.checkNewLine(printedText);
        wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, fontSize);
        try {
            if (scaleFont) {
                while (!PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)textRect.getWidth(), (float)textRect.getHeight()) && fontSize < 100) {
                    wrappedText = PadesUtils.checkNewLine(printedText);
                    wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, ++fontSize);
                }
            }
            while (PadesUtils.checkTextSize(wrappedText, (PDFont)font, fontSize, (float)textRect.getWidth(), (float)textRect.getHeight()) && fontSize > 1) {
                wrappedText = PadesUtils.checkNewLine(printedText);
                wrappedText = stringWrap.performWrap(wrappedText, (float)textRect.getWidth(), (PDFont)font, --fontSize);
            }
            pageStream.setFont((PDFont)font, (float)fontSize);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        pageStream.setLeading((float)fontSize * 1.15f);
        pageStream.newLineAtOffset((float)textRect.getX(), (float)textRect.getY() - (float)fontSize);
        for (String line : wrappedText) {
            pageStream.showText(line);
            pageStream.newLine();
        }
        pageStream.endText();
    }

    private static List<String> checkNewLine(String wrappedText) {
        ArrayList<String> newText = new ArrayList<String>();
        String[] str = wrappedText.split("\\r?\\n");
        if (str.length > 1) {
            newText.addAll(Arrays.asList(str));
        } else {
            newText.add(wrappedText);
        }
        return newText;
    }

    private static boolean checkTextSize(List<String> wrappedText, PDFont font, int fontSize, float rectWidth, float rectHeight) throws IOException {
        if ((float)fontSize * 1.15f * (float)wrappedText.size() > rectHeight) {
            return true;
        }
        for (String s : wrappedText) {
            if (!(font.getStringWidth(s) / 1000.0f * (float)fontSize > rectWidth)) continue;
            return true;
        }
        return false;
    }

    private static String retrieveText(CapiPDFApparence apparence) {
        String printedText = "";
        if (apparence.getVisibleLabel() != null) {
            printedText = apparence.getVisibleLabel();
        } else {
            String name = apparence.getName();
            if (!Util.isNullOrEmpty((String)name)) {
                printedText = printedText + name;
            }
            if (!apparence.isShowNameOnly()) {
                String title;
                String organization = apparence.getOrganization();
                if (organization != null && !organization.trim().toLowerCase().contains("non presente") && organization.trim().compareToIgnoreCase("null") != 0) {
                    if (!printedText.isEmpty()) {
                        printedText = printedText + "\n";
                    }
                    printedText = printedText + organization;
                }
                if ((title = apparence.getTitle()) != null && !title.trim().toLowerCase().contains("non presente") && title.trim().compareToIgnoreCase("null") != 0) {
                    if (!printedText.isEmpty()) {
                        printedText = printedText + "\n";
                    }
                    printedText = printedText + title;
                }
            }
        }
        if (apparence.isShowDateTime() && !apparence.isShowNameOnly()) {
            if (!printedText.isEmpty()) {
                printedText = printedText + "\n";
            }
            Date printedDate = new Date();
            if (apparence.getSigningTimeCal() != null) {
                printedDate = apparence.getSigningTimeCal().getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            String timeZone = apparence.getTimeZone() == null ? "UTC" : apparence.getTimeZone();
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
            String formattedDate = df.format(printedDate);
            printedText = printedText + formattedDate;
        }
        return printedText.trim().replace("\t", "    ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static PDVisibleSigProperties getPDVisibleSigProperties(CapiPDFApparence apparence) throws CapiException {
        if (apparence == null) {
            return null;
        }
        BufferedImage signatureImage = apparence.getImage();
        String visibleLabel = apparence.getVisibleLabel();
        int fontSize = apparence.getFontSize();
        float posX = apparence.getPosX();
        float posY = apparence.getPosY();
        float width = apparence.getWidth();
        float height = apparence.getHeight();
        String name = apparence.getName();
        String organization = apparence.getOrganization();
        String title = apparence.getTitle();
        String fieldName = apparence.getFieldName();
        boolean bShowDate = apparence.isShowDateTime();
        int page = apparence.getPage();
        boolean only_image = apparence.isOnly_image();
        int resizeMode = apparence.getResizeMode();
        boolean bScaleFont = apparence.isScaleFont();
        Calendar signDate = apparence.getSigningTimeCal();
        boolean bPDFA = apparence.isPDFASignature();
        boolean bGray = apparence.isGray();
        String location = apparence.getLocation();
        String reason = apparence.getReason();
        PDDocument pdDoc = apparence.getPdDocument();
        int anchorCorner = apparence.getAnchorCorner();
        boolean bShowNameOnly = apparence.isShowNameOnly();
        if ((double)posX < 0.0 || (double)posY < 0.0) {
            logger.error("wrong signature position");
            return null;
        }
        if ((double)width <= 0.0 || (double)height <= 0.0) {
            logger.error("wrong signature size");
            return null;
        }
        PDVisibleSigProperties signatureProperties = null;
        Graphics2D graphics = null;
        int appWidth = (int)width * 4;
        int appHeight = (int)height * 4;
        int resizedWidth = appWidth;
        int resizedHeight = appHeight;
        int xTextPosition = 0;
        int yTextPosition = 0;
        int optimalFontSize = fontSize * 4;
        if (signatureImage != null) {
            String appOrientation = "H";
            if (!only_image) {
                float hval;
                float happ = height;
                float wapp = width;
                float himg = signatureImage.getHeight();
                float wimg = signatureImage.getWidth();
                float wval = wimg / wapp;
                if (wval > (hval = himg / happ)) {
                    yTextPosition = resizedHeight = (int)height * 2;
                    appOrientation = "V";
                } else {
                    xTextPosition = resizedWidth = (int)width * 2;
                    appOrientation = "H";
                }
            }
            signatureImage = PadesUtils.resize_and_center(signatureImage, resizedWidth, resizedHeight, resizeMode, 0, appOrientation);
        }
        Date printedDate = new Date();
        if (signDate != null) {
            printedDate = signDate.getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
        String tz = apparence.getTimeZone() == null ? "UTC" : apparence.getTimeZone();
        df.setTimeZone(TimeZone.getTimeZone(tz));
        String formattedDate = df.format(printedDate);
        String printedText = "";
        if (visibleLabel != null) {
            printedText = visibleLabel;
        } else {
            if (!Util.isNullOrEmpty((String)name)) {
                printedText = printedText + name;
            }
            if (!bShowNameOnly) {
                if (organization != null && !organization.trim().toLowerCase().contains("non presente") && organization.trim().compareToIgnoreCase("null") != 0) {
                    if (!printedText.isEmpty()) {
                        printedText = printedText + "\n";
                    }
                    printedText = printedText + organization;
                }
                if (title != null && !title.trim().toLowerCase().contains("non presente") && title.trim().compareToIgnoreCase("null") != 0) {
                    if (!printedText.isEmpty()) {
                        printedText = printedText + "\n";
                    }
                    printedText = printedText + title;
                }
            }
        }
        if (bShowDate && !bShowNameOnly) {
            if (!printedText.isEmpty()) {
                printedText = printedText + "\n";
            }
            printedText = printedText + formattedDate;
        }
        BufferedImage image1 = new BufferedImage(appWidth, appHeight, 2);
        graphics = image1.createGraphics();
        graphics.clearRect(0, 0, appWidth, appHeight);
        graphics.drawRect(0, 0, appWidth - 1, appHeight - 1);
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, appWidth, appHeight);
        graphics.setComposite(AlphaComposite.Src);
        if (!only_image) {
            TextContainer container = new TextContainer(printedText, resizedWidth, resizedHeight, "Arial", 0, optimalFontSize, anchorCorner);
            BufferedImage textImage = new BufferedImage(resizedWidth, resizedHeight, 2);
            Graphics2D textGraphics = textImage.createGraphics();
            textGraphics.drawRect(0, 0, resizedWidth - 1, resizedHeight - 1);
            textGraphics.setComposite(AlphaComposite.Clear);
            textGraphics.fillRect(0, 0, resizedWidth, resizedHeight);
            textGraphics.setComposite(AlphaComposite.Src);
            container.paint(textGraphics, bScaleFont);
            graphics.drawImage((Image)textImage, xTextPosition, yTextPosition, null);
        }
        if (signatureImage != null) {
            graphics.drawImage((Image)signatureImage, 0, 0, null);
        }
        if (bPDFA) {
            image1 = bGray ? PadesUtils.convertToGray(image1) : PadesUtils.convertToRgb(image1);
        }
        try {
            logger.debug("[addSigner] page: " + page);
            PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(pdDoc, image1, page);
            visibleSig.height(height);
            visibleSig.width(width);
            float pageHeight = visibleSig.getPageHeight();
            visibleSig.xAxis(posX).yAxis(pageHeight - posY).signatureFieldName(fieldName);
            signatureProperties = new PDVisibleSigProperties();
            signatureProperties.signerName(name);
            signatureProperties.signerLocation(location);
            signatureProperties.signatureReason(reason);
            signatureProperties.preferredSize(0);
            signatureProperties.page(page);
            signatureProperties.visualSignEnabled(true);
            signatureProperties.setPdVisibleSignature(visibleSig);
            signatureProperties.buildSignature();
            logger.debug("getPDVisibleSigProperties done");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return signatureProperties;
    }

    private static BufferedImage resize_and_center(BufferedImage origImg, float newWidth, float newHeight, int mode, String orientation) {
        return PadesUtils.resize_and_center(origImg, newWidth, newHeight, mode, 0, orientation);
    }

    private static Rectangle2D resize_and_center_image(float imgWidth, float imgHeight, float appWidth, float appHeight, int mode, String orientation) {
        float posX = 0.0f;
        float posY = 0.0f;
        float finalHeight = 0.0f;
        float finalWidth = 0.0f;
        if (appWidth < appHeight) {
            finalHeight = imgHeight * appWidth / imgWidth;
            finalWidth = appWidth;
            if (finalHeight > appHeight) {
                finalWidth = finalWidth * appHeight / finalHeight;
                finalHeight = appHeight;
            }
        } else {
            finalWidth = imgWidth * appHeight / imgHeight;
            finalHeight = appHeight;
            if (finalWidth > appWidth) {
                finalHeight = finalHeight * appWidth / finalWidth;
                finalWidth = appWidth;
            }
        }
        switch (mode) {
            case 1: {
                finalWidth = appWidth;
                finalHeight = appHeight;
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = 0.0f;
                    posY = 0.0f;
                    break;
                }
                posX = 0.0f;
                posY = appHeight;
                break;
            }
            case 2: {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = (appWidth - finalWidth) / 2.0f;
                    posY = (appHeight - finalHeight) / 2.0f;
                    break;
                }
                posX = (appWidth - finalWidth) / 2.0f;
                posY = appHeight + (appHeight - finalHeight) / 2.0f;
                break;
            }
            case 3: {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = appWidth - finalWidth;
                    posY = (appHeight - finalHeight) / 2.0f;
                    break;
                }
                posX = (appWidth - finalWidth) / 2.0f;
                posY = appHeight;
                break;
            }
            case 4: {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = 0.0f;
                    posY = (appHeight - finalHeight) / 2.0f;
                    break;
                }
                posX = (appWidth - finalWidth) / 2.0f;
                posY = 2.0f * appHeight - finalHeight;
            }
        }
        return new Rect(posX, posY, finalWidth, finalHeight);
    }

    private static Rectangle2D resizeAndCenterImageFlipped(float imgWidth, float imgHeight, float appWidth, float appHeight, int mode, String orientation) {
        float posX = 0.0f;
        float posY = 0.0f;
        float finalHeight = 0.0f;
        float finalWidth = 0.0f;
        if (appWidth < appHeight) {
            finalHeight = imgHeight * appWidth / imgWidth;
            finalWidth = appWidth;
            if (finalHeight > appHeight) {
                finalWidth = finalWidth * appHeight / finalHeight;
                finalHeight = appHeight;
            }
        } else {
            finalWidth = imgWidth * appHeight / imgHeight;
            finalHeight = appHeight;
            if (finalWidth > appWidth) {
                finalHeight = finalHeight * appWidth / finalWidth;
                finalWidth = appWidth;
            }
        }
        switch (mode) {
            case 1: {
                finalWidth = appWidth;
                finalHeight = appHeight;
                posX = 0.0f;
                posY = 0.0f;
                break;
            }
            case 2: {
                posX = (appWidth - finalWidth) / 2.0f;
                posY = (appHeight - finalHeight) / 2.0f;
                break;
            }
            case 3: {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = appWidth - finalWidth;
                    posY = (appHeight - finalHeight) / 2.0f;
                    break;
                }
                posX = (appWidth - finalWidth) / 2.0f;
                posY = 0.0f;
                break;
            }
            case 4: {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = 0.0f;
                    posY = (appHeight - finalHeight) / 2.0f;
                    break;
                }
                posX = (appWidth - finalWidth) / 2.0f;
                posY = 2.0f * appHeight - finalHeight;
            }
        }
        return new Rect(posX, posY, finalWidth, finalHeight);
    }

    @Deprecated
    private static BufferedImage resize_and_center(BufferedImage origImg, float newWidth, float newHeight, int mode, int textSpace, String orientation) {
        if (origImg == null || newWidth <= 0.0f || newHeight <= 0.0f) {
            return null;
        }
        int origWidth = origImg.getWidth();
        int origHeight = origImg.getHeight();
        int destWidth = Math.round(newWidth);
        int destHeight = Math.round(newHeight);
        BufferedImage resImg = null;
        resImg = !origImg.getColorModel().hasAlpha() ? new BufferedImage(destWidth, destHeight, origImg.getType()) : new BufferedImage(destWidth, destHeight, 2);
        Graphics2D g = resImg.createGraphics();
        if (!origImg.getColorModel().hasAlpha()) {
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, destWidth, destHeight);
        }
        if (mode == 1) {
            g.drawImage(origImg, 0, 0, destWidth, destHeight, 0, 0, origWidth, origHeight, null);
            g.dispose();
            return resImg;
        }
        if (mode == 5) {
            return origImg;
        }
        if (mode > 1) {
            int fittedHeight = 0;
            int fittedWidth = 0;
            if (destWidth < destHeight) {
                fittedHeight = origHeight * destWidth / origWidth;
                fittedWidth = destWidth;
                if (fittedHeight > destHeight) {
                    fittedWidth = fittedWidth * destHeight / fittedHeight;
                    fittedHeight = destHeight;
                }
            } else {
                fittedWidth = origWidth * destHeight / origHeight;
                fittedHeight = destHeight;
                if (fittedWidth > destWidth) {
                    fittedHeight = fittedHeight * destWidth / fittedWidth;
                    fittedWidth = destWidth;
                }
            }
            int posX = 0;
            int posY = 0;
            if (mode == 2) {
                posX = (destWidth - fittedWidth) / 2;
                posY = (destHeight - fittedHeight) / 2;
            } else if (mode == 3) {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posX = destWidth - fittedWidth;
                    posY = (destHeight - fittedHeight) / 2;
                } else {
                    posX = (destWidth - fittedWidth) / 2;
                    posY = destHeight - fittedHeight;
                }
            } else if (mode == 4) {
                if (orientation != null && orientation.equalsIgnoreCase("H")) {
                    posY = (destHeight - fittedHeight) / 2;
                } else {
                    posX = (destWidth - fittedWidth) / 2;
                }
            }
            g.drawImage(origImg, posX, posY, fittedWidth + posX, fittedHeight + posY, 0, 0, origWidth, origHeight, null);
            g.dispose();
            return resImg;
        }
        return origImg;
    }

    private void drawString(Graphics2D g, String text, int x, int y) {
        if (g == null || x < 0 || y < 0 || text == null) {
            return;
        }
        for (String line : text.split("\n")) {
            g.drawString(line, x, y += g.getFontMetrics().getHeight());
        }
    }

    private static void drawStringCentered(Graphics2D g, String text, int totWidth) {
        if (g == null || text == null) {
            return;
        }
        int y = 0;
        for (String line : text.split("\n")) {
            int lineWidth = g.getFontMetrics().stringWidth(line);
            g.drawString(line, Math.max(totWidth / 2 - lineWidth / 2, 0), y += g.getFontMetrics().getHeight());
        }
    }

    private static void drawStringMultiLine(Graphics2D g, String text, int lineWidth, int x, int y) {
        FontMetrics m = g.getFontMetrics();
        if (m.stringWidth(text) < lineWidth) {
            g.drawString(text, x, y);
        } else {
            String[] words = text.split(" ");
            String currentLine = words[0];
            for (int i = 1; i < words.length; ++i) {
                if (m.stringWidth(currentLine + words[i]) < lineWidth) {
                    currentLine = currentLine + " " + words[i];
                    continue;
                }
                g.drawString(currentLine, x, y);
                y += m.getHeight();
                currentLine = words[i];
            }
            if (currentLine.trim().length() > 0) {
                g.drawString(currentLine, x, y);
            }
        }
    }

    private static BufferedImage convertToGray(BufferedImage image) {
        if (image.getType() == 10) {
            return image;
        }
        BufferedImage gray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        image = PadesUtils.convertToRgb(image);
        ColorConvertOp op = new ColorConvertOp(image.getColorModel().getColorSpace(), gray.getColorModel().getColorSpace(), null);
        op.filter(image, gray);
        return gray;
    }

    private static BufferedImage convertToRgb(BufferedImage image) {
        if (image == null) {
            return null;
        }
        if (image.getType() == 1) {
            return image;
        }
        BufferedImage rgb = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = rgb.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, rgb.getWidth(), rgb.getHeight());
        g.dispose();
        ColorConvertOp op = new ColorConvertOp(image.getColorModel().getColorSpace(), rgb.getColorModel().getColorSpace(), null);
        op.filter(image, rgb);
        return rgb;
    }

    public static COSArray parseArray(COSDictionary dic, String name) {
        COSArray arrReturn = null;
        COSBase objArraysObj = dic.getItem(name);
        if (objArraysObj != null) {
            if (objArraysObj instanceof COSArray) {
                arrReturn = (COSArray)objArraysObj;
            } else if (((COSObject)objArraysObj).getObject() instanceof COSArray) {
                arrReturn = (COSArray)((COSObject)objArraysObj).getObject();
            }
        }
        return arrReturn;
    }

    public static PadesDssInfo retrieveDssInfo(PDDocument document) {
        PadesDssInfo padesDssInfo = null;
        try {
            COSDictionary trailer = document.getDocument().getTrailer();
            if (trailer == null) {
                logger.error("[initialize] trailer is null.");
                return null;
            }
            COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            if (root == null) {
                logger.error("[initialize] root is null");
                return null;
            }
            COSDictionary dicDSS = (COSDictionary)root.getDictionaryObject("DSS");
            if (dicDSS != null) {
                COSArray arrCrl;
                COSArray arrOcsp;
                padesDssInfo = new PadesDssInfo(document, dicDSS);
                COSArray arrCert = PadesUtils.parseArray(dicDSS, "Certs");
                if (arrCert != null) {
                    for (int i = 0; i < arrCert.size(); ++i) {
                        COSStream stream = (COSStream)arrCert.getObject(i);
                        byte[] c = Util.getBytesFromInputStream((InputStream)stream.createInputStream());
                        Certificate intCert = new Certificate(c);
                        padesDssInfo.getCerts().add(intCert.getInternalCert());
                    }
                }
                if ((arrOcsp = PadesUtils.parseArray(dicDSS, "OCSPs")) != null) {
                    for (int i = 0; i < arrOcsp.size(); ++i) {
                        COSStream stream = (COSStream)arrOcsp.getObject(i);
                        byte[] ocsp = Util.getBytesFromInputStream((InputStream)stream.createInputStream());
                        BasicOCSPResp resp = OcspUtils.getInstaceByBytes((byte[])ocsp);
                        if (resp == null) continue;
                        padesDssInfo.getOcsps().add(resp);
                    }
                }
                if ((arrCrl = PadesUtils.parseArray(dicDSS, "CRLs")) != null) {
                    for (int i = 0; i < arrCrl.size(); ++i) {
                        COSStream stream = (COSStream)arrCrl.getObject(i);
                        CRL crl = new CRL((InputStream)stream.createInputStream());
                        padesDssInfo.getCrls().add(crl);
                    }
                }
            }
        }
        catch (CapiException ex) {
            logger.error("Impossibile Parsare DSS Pdf", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Impossibile Parsare DSS Pdf", (Throwable)ex);
        }
        return padesDssInfo;
    }

    public static LinkedList<PadesSignatureInformation> retrieveSignatures(PDDocument doc) {
        LinkedList<PadesSignatureInformation> lstSignatures = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo(doc);
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm == null) {
            return lstSignatures;
        }
        List fields = acroForm.getFields();
        if (fields == null || fields.size() <= 0) {
            logger.debug("[findSignature] no fields");
            return lstSignatures;
        }
        for (PDField pdField : fields) {
            LinkedList<PadesSignatureInformation> lstRet = PadesUtils.parseField(pdField, padesDssInfo, 0);
            lstSignatures.addAll(lstRet);
        }
        return lstSignatures;
    }

    public static LinkedList<PadesSignatureInformation> retrieveNotEmptySignatures(PDDocument doc) {
        LinkedList<PadesSignatureInformation> lstSignatures = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo(doc);
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm == null) {
            return lstSignatures;
        }
        List fields = acroForm.getFields();
        if (fields == null || fields.size() <= 0) {
            logger.debug("[findSignature] no fields");
            return lstSignatures;
        }
        for (PDField pdField : fields) {
            LinkedList<PadesSignatureInformation> lstRet = PadesUtils.parseField(pdField, padesDssInfo, 1);
            lstSignatures.addAll(lstRet);
        }
        CompareByteRangeSignature comparator = new CompareByteRangeSignature();
        Collections.sort(lstSignatures, comparator);
        return lstSignatures;
    }

    public static LinkedList<PadesSignatureInformation> retrieveEmptySignatures(PDDocument doc) {
        LinkedList<PadesSignatureInformation> lstSignatures = new LinkedList<PadesSignatureInformation>();
        PadesDssInfo padesDssInfo = PadesUtils.retrieveDssInfo(doc);
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm == null) {
            return lstSignatures;
        }
        List fields = acroForm.getFields();
        if (fields == null || fields.size() <= 0) {
            logger.debug("[findSignature] no fields");
            return lstSignatures;
        }
        for (PDField pdField : fields) {
            LinkedList<PadesSignatureInformation> lstRet = PadesUtils.parseField(pdField, padesDssInfo, 2);
            lstSignatures.addAll(lstRet);
        }
        return lstSignatures;
    }

    private static LinkedList<PadesSignatureInformation> parseField(PDField pdField, PadesDssInfo padesDssInfo, int filter) {
        LinkedList<PadesSignatureInformation> signatures = new LinkedList<PadesSignatureInformation>();
        if (pdField instanceof PDSignatureField) {
            PDSignatureField signature_field = (PDSignatureField)pdField;
            String sigName = signature_field.getFullyQualifiedName();
            logger.debug("[findSignature] Found Signature Name: " + sigName);
            if (filter == 0) {
                if ((PadesUtils.isSignatureField(signature_field.getCOSObject()) || signature_field.getValue() == null) && !PadesUtils.contains(sigName, signatures)) {
                    signatures.add(new PadesSignatureInformation(signature_field, padesDssInfo));
                    logger.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (filter == 1) {
                if (PadesUtils.isSignatureField(signature_field.getCOSObject()) && !PadesUtils.contains(sigName, signatures)) {
                    signatures.add(new PadesSignatureInformation(signature_field, padesDssInfo));
                    logger.debug("[findSignature] Filled SignatureField added.");
                }
            } else if (filter == 1 && signature_field.getValue() == null && !PadesUtils.contains(sigName, signatures)) {
                signatures.add(new PadesSignatureInformation(signature_field, padesDssInfo));
                logger.debug("[findSignature] Filled SignatureField added.");
            }
        }
        if (pdField instanceof PDNonTerminalField) {
            for (PDField pdFieldInt : ((PDNonTerminalField)pdField).getChildren()) {
                signatures.addAll(PadesUtils.parseField(pdFieldInt, padesDssInfo, filter));
            }
        }
        return signatures;
    }

    static {
        isFontRegistered = false;
    }

    private static class Rect
    extends Rectangle2D {
        public double x;
        public double y;
        public double w;
        public double h;

        public Rect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public int outcode(double x, double y) {
            return 0;
        }

        @Override
        public Rectangle2D createIntersection(Rectangle2D r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Rectangle2D createUnion(Rectangle2D r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.w;
        }

        @Override
        public double getHeight() {
            return this.h;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

