/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.pdf.AdditionalDictionaryInfo;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;

public class FeaInfo
implements AdditionalDictionaryInfo {
    private byte[] FEA_blob;
    long[] byte_range = null;

    public FeaInfo(byte[] FEA_blob) throws CapiException {
        this.FEA_blob = FEA_blob;
        if (FEA_blob == null) {
            throw new CapiException("Null G_blob", 1001);
        }
    }

    @Override
    public COSDictionary getDictionary(long[] arr_byte_range) {
        COSDictionary objReturn = new COSDictionary();
        objReturn.setItem(COSName.getPDFName((String)"version"), (COSBase)new COSString("2.0.0"));
        String s_g_blob = new String(Util.base64Encode((byte[])this.FEA_blob));
        String[] arr_g_blob = s_g_blob.split("(?<=\\G.{32766})");
        COSArray g_blob = new COSArray();
        for (int i = 0; i < arr_g_blob.length; ++i) {
            g_blob.add((COSBase)new COSString(arr_g_blob[i]));
        }
        objReturn.setItem("fea_blob", (COSBase)g_blob);
        if (arr_byte_range.length == 2) {
            COSArray byte_range = new COSArray();
            byte_range.add((COSBase)COSInteger.get((long)arr_byte_range[0]));
            byte_range.add((COSBase)COSInteger.get((long)arr_byte_range[1]));
            objReturn.setItem("byte_range", (COSBase)byte_range);
        }
        return objReturn;
    }

    @Override
    public COSDictionary getDictionary() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] getByte_range() {
        return this.byte_range;
    }

    void setByte_range(long[] byte_range) {
        this.byte_range = byte_range;
    }

    public byte[] getFEA_blob() {
        return this.FEA_blob;
    }
}

