/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pades.PadesDssInfo;
import it.actalis.ellips.capi.pades.PadesUtils;
import it.actalis.ellips.capi.pdf.AutenticaBinding;
import it.actalis.ellips.capi.pdf.FeaInfo;
import it.actalis.ellips.capi.pdf.GraphometricInfo;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pdf.SignedPDF;
import it.actalis.ellips.capi.pkcs7.SignedEnvelope;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class PadesSignatureInformation {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private COSDictionary fieldDictionary;
    private COSDictionary signatureDictionary;
    private PDSignature pdSig = null;
    private String subFilter = null;
    private String detectedReason;
    private String detectedLocation;
    private String detectedSigName;
    private Calendar detectedSigDate;
    private boolean isValidSignature = false;
    private String certificateInSigDictionary = null;
    private List<Certificate> certificatesArray;
    private SignedEnvelope se = null;
    private StreamSignedEnvelope sse = null;
    private TimeStampToken tst = null;
    private GraphometricInfo graph_info = null;
    private AutenticaBinding autentica_info = null;
    private byte[] p7Detached = null;
    private Certificate signerCertificate = null;
    private int detectedCertificationLevel = 0;
    private RevisionInformation revision = null;
    private boolean signature_cover_all_revision;
    private boolean empty = true;
    private PadesDssInfo padesDssInfo = null;
    private byte[] vri_sha1;
    private PDSignatureField signature_field;
    private boolean hasRFC5652_SignedAttrDER = true;
    private FeaInfo fea_info = null;

    public PadesSignatureInformation(PDSignatureField signature_field, PadesDssInfo padesDssInfo) {
        if (signature_field.getValue() != null) {
            COSBase fea_info_d;
            COSBase autentica_d;
            long[] arr_byte_range;
            COSArray byte_range;
            this.empty = false;
            this.signature_field = signature_field;
            this.fieldDictionary = signature_field.getCOSObject();
            this.subFilter = null;
            this.detectedReason = null;
            this.detectedLocation = null;
            this.detectedSigDate = null;
            this.isValidSignature = false;
            this.p7Detached = null;
            this.detectedSigName = null;
            this.certificateInSigDictionary = null;
            this.detectedCertificationLevel = 0;
            this.padesDssInfo = padesDssInfo;
            this.hasRFC5652_SignedAttrDER = true;
            this.sse = null;
            this.certificatesArray = null;
            this.signerCertificate = null;
            this.se = null;
            COSString sigName = (COSString)this.fieldDictionary.getDictionaryObject(COSName.T);
            logger.debug("[initialize][PadesSignatureInformation] Signatue Field Name: " + sigName.getString());
            this.detectedSigName = sigName.getString();
            this.signatureDictionary = (COSDictionary)this.fieldDictionary.getDictionaryObject(COSName.V);
            COSBase bd = this.signatureDictionary.getItem("biometric_data");
            if (bd != null) {
                try {
                    COSDictionary biometric_data = (COSDictionary)((COSObject)bd).getObject();
                    if (biometric_data.getString("version").equals("2.0.0")) {
                        COSArray g_blob = (COSArray)biometric_data.getItem("g_blob");
                        StringBuilder sb = new StringBuilder("");
                        String s_blob = "";
                        for (int i = 0; i < g_blob.size(); ++i) {
                            sb.append(g_blob.getString(i));
                        }
                        s_blob = sb.toString();
                        String[] personal_data = null;
                        COSArray a_personal_data = (COSArray)biometric_data.getItem("personal_data");
                        personal_data = new String[a_personal_data.size()];
                        for (int i = 0; i < a_personal_data.size(); ++i) {
                            personal_data[i] = a_personal_data.getString(i);
                        }
                        this.graph_info = new GraphometricInfo(Base64.decode((String)s_blob), Base64.decode((String)biometric_data.getString("Impronta_1")), Base64.decode((String)biometric_data.getString("Impronta_2")), Base64.decode((String)biometric_data.getString("Impr_signed")), biometric_data.getString("user_notice"), personal_data);
                        byte_range = (COSArray)biometric_data.getItem("byte_range");
                        arr_byte_range = new long[]{((COSInteger)byte_range.get(0)).longValue(), ((COSInteger)byte_range.get(1)).longValue()};
                        this.graph_info.setByte_range(arr_byte_range);
                    }
                }
                catch (CapiException ex) {
                    logger.error("biometric_data non parsabile");
                }
            }
            if ((autentica_d = this.signatureDictionary.getItem("binding_dictionary")) != null) {
                try {
                    COSDictionary autentica_data = (COSDictionary)((COSObject)autentica_d).getObject();
                    if (autentica_data.getString("version").equals("1.0.0")) {
                        String SP_signed = autentica_data.getString("SP_signed");
                        String Imprt_SP = autentica_data.getString("Imprt_SP");
                        COSArray byte_range2 = (COSArray)autentica_data.getItem("byte_range");
                        long[] arr_byte_range2 = new long[]{((COSInteger)byte_range2.get(0)).longValue(), ((COSInteger)byte_range2.get(1)).longValue()};
                        this.autentica_info = new AutenticaBinding(SP_signed, Base64.decode((String)Imprt_SP), "1.0.0", arr_byte_range2);
                        this.autentica_info.setByte_range(arr_byte_range2);
                    }
                }
                catch (Throwable ex) {
                    logger.error("autentica_d non parsabile");
                }
            }
            if ((fea_info_d = this.signatureDictionary.getItem("fea_dictionary")) != null) {
                try {
                    COSDictionary fea_info_data = (COSDictionary)((COSObject)fea_info_d).getObject();
                    if (fea_info_data.getString("version").equals("2.0.0")) {
                        COSArray fea_blob = (COSArray)fea_info_data.getItem("fea_blob");
                        StringBuilder sb = new StringBuilder("");
                        String s_blob = "";
                        for (int i = 0; i < fea_blob.size(); ++i) {
                            sb.append(fea_blob.getString(i));
                        }
                        s_blob = sb.toString();
                        byte_range = (COSArray)fea_info_data.getItem("byte_range");
                        arr_byte_range = new long[]{((COSInteger)byte_range.get(0)).longValue(), ((COSInteger)byte_range.get(1)).longValue()};
                        this.fea_info = new FeaInfo(Base64.decode((String)s_blob));
                        this.fea_info.setByte_range(arr_byte_range);
                    }
                }
                catch (Throwable ex) {
                    logger.error("autentica_d non parsabile");
                }
            }
            COSString contents = (COSString)this.signatureDictionary.getDictionaryObject(COSName.CONTENTS);
            COSBase cerDict = this.signatureDictionary.getDictionaryObject(COSName.getPDFName((String)"Cert"));
            if (cerDict != null) {
                if (cerDict instanceof COSString) {
                    this.certificateInSigDictionary = ((COSString)cerDict).getString();
                }
                if (cerDict instanceof COSName) {
                    this.certificateInSigDictionary = ((COSName)cerDict).getName();
                }
            }
            this.p7Detached = contents.getBytes();
            try {
                ASN1StreamParser in = new ASN1StreamParser(this.p7Detached);
                byte[] vribytes = in.readObject().toASN1Primitive().getEncoded();
                this.vri_sha1 = Util.digestStreams((String)Constants.SHA1, (InputStream[])new InputStream[]{new ByteArrayInputStream(this.p7Detached)});
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.pdSig = new PDSignature(this.signatureDictionary);
            this.detectedReason = this.pdSig.getReason();
            this.detectedLocation = this.pdSig.getLocation();
            this.detectedSigDate = this.pdSig.getSignDate();
            this.subFilter = this.pdSig.getSubFilter();
            logger.debug("[initialize][PadesSignatureInformation] Location: {}", (Object)this.detectedLocation);
            logger.debug("[initialize][PadesSignatureInformation] Reason: {}", (Object)this.detectedReason);
            logger.debug("[initialize][PadesSignatureInformation] SubFilter: {}", (Object)this.subFilter);
            COSBase refArr = this.pdSig.getCOSObject().getItem(COSName.getPDFName((String)"Reference"));
            this.detectedCertificationLevel = this.getCertificationLevel(refArr);
            if (logger.isDebugEnabled()) {
                logger.debug("[initialize][PadesSignatureInformation] byteRangeArray: ");
                if (this.getByteRangeArray() != null) {
                    for (int h = 0; h < this.getByteRangeArray().length; ++h) {
                        logger.debug(" " + this.getByteRangeArray()[h]);
                    }
                }
            }
            if (padesDssInfo != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean verify(InputHandler origPdf) {
        if (!this.empty) {
            try {
                block69: {
                    signed_content_is = null;
                    contents = null;
                    try {
                        signed_content_is = new COSFilterInputStream(origPdf.getInputAsNewStream(), this.getByteRangeArray());
                        byteRange = this.getByteRangeArray();
                        begin = byteRange[0] + byteRange[1] + 1;
                        len = byteRange[2] - begin;
                        contents = this.getContents(new COSFilterInputStream(origPdf.getInputAsNewStream(), new int[]{begin, len}));
                    }
                    catch (Exception e) {
                        PadesSignatureInformation.logger.debug("Exception getting signed content: " + e.getMessage());
                        e.printStackTrace();
                    }
                    digest = null;
                    mdbytes = null;
                    if (signed_content_is != null) {
                        if (this.pdSig.getSubFilter().compareTo("adbe.x509.rsa_sha1") == 0) {
                            certs = null;
                            try {
                                PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] subfilter adbe.x509.rsa_sha1, getting certificate...");
                                certificateString = (COSString)this.signatureDictionary.getDictionaryObject(COSName.getPDFName((String)"Cert"));
                                certData = certificateString.getBytes();
                                factory = CertificateFactory.getInstance("X.509");
                                certStream = new ByteArrayInputStream(certData);
                                certs = factory.generateCertificates(certStream);
                            }
                            catch (Exception ex) {
                                this.isValidSignature = false;
                                PadesSignatureInformation.logger.debug("no certificate found: " + ex.getMessage());
                            }
                            if (certs == null || certs.isEmpty()) {
                                PadesSignatureInformation.logger.debug("No certificate found");
                            } else {
                                PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] subfilter adbe.x509.rsa_sha1, digesting signed data ...");
                                try {
                                    md = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                                    dataBytes = new byte[4096];
                                    nread = 0;
                                    while ((nread = signed_content_is.read(dataBytes, 0, dataBytes.length)) != -1) {
                                        md.update(dataBytes, 0, nread);
                                    }
                                    messagedigest = md.digest();
                                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] digest done");
                                    cd = new String(Hex.encode((byte[])messagedigest), "US-ASCII").toUpperCase(Locale.ENGLISH);
                                    PadesSignatureInformation.logger.debug("hash calcolato: " + cd);
                                    i = certs.iterator();
                                    signer = null;
                                    pk = null;
                                    if (i.hasNext()) {
                                        signer = (X509Certificate)i.next();
                                        pk = signer.getPublicKey();
                                        this.signerCertificate = capiCert = new Certificate(signer.getEncoded());
                                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] signerCertificate: " + capiCert.getName());
                                    } else {
                                        PadesSignatureInformation.logger.debug("No certificate found");
                                    }
                                    this.certificatesArray = new LinkedList<Certificate>();
                                    while (i.hasNext()) {
                                        crt = (X509Certificate)i.next();
                                        this.certificatesArray.add(new Certificate(crt));
                                    }
                                    in = new ASN1StreamParser(this.p7Detached);
                                    oct = ASN1OctetString.getInstance((Object)in.readObject());
                                    pkcs1signature = oct.getOctets();
                                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] decrypting signature and getting hash ... ");
                                    cipher = Cipher.getInstance("RSA/ECB/NoPadding");
                                    cipher.init(1, pk);
                                    cipherData = cipher.doFinal(pkcs1signature);
                                    dec = new String(Hex.encode((byte[])cipherData), "US-ASCII").toUpperCase(Locale.ENGLISH);
                                    PadesSignatureInformation.logger.debug("hash from decryption: " + dec);
                                    PadesSignatureInformation.logger.debug("hash of pdf: " + cd);
                                    if (dec.endsWith(cd)) {
                                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] adbe.x509.rsa_sha1 successfully verified");
                                        this.isValidSignature = true;
                                    }
                                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] adbe.x509.rsa_sha1 not verified");
                                    this.isValidSignature = false;
                                }
                                finally {
                                    IOUtils.closeQuietly((Closeable)signed_content_is);
                                }
                            }
                        } else if (this.pdSig.getSubFilter().compareTo("adbe.pkcs7.sha1") == 0) {
                            PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] subfilter adbe.pkcs7.sha1, digesting signed data ...");
                            try {
                                md = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
                                dataBytes = new byte[4096];
                                nread = 0;
                                while ((nread = signed_content_is.read(dataBytes, 0, dataBytes.length)) != -1) {
                                    md.update(dataBytes, 0, nread);
                                }
                                mdbytes = md.digest();
                                PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] digest done");
                                this.se = new SignedEnvelope(this.p7Detached, true);
                                digest = this.se.getData();
                                this.certificatesArray = this.se.listCertificates();
                                this.signerCertificate = this.se.getSignerCertificate(0);
                                d = this.se.getSigningTime(0, "yyyyMMddHHmmss");
                                PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] signing time: " + d);
                                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                                if (d != null) {
                                    date = sdf.parse(d);
                                    this.detectedSigDate = Calendar.getInstance();
                                    this.detectedSigDate.setTime(date);
                                }
                                try {
                                    this.se.verify(0);
                                    this.isValidSignature = true;
                                    PadesSignatureInformation.logger.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException e) {
                                    if (e.getErrorCode() == 3010) {
                                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.isValidSignature = false;
                                    }
                                    throw e;
                                }
                                if (mdbytes != null) {
                                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] comparing digest ...");
                                    if (Arrays.equals(mdbytes, digest)) ** GOTO lbl185
                                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] digest do not match");
                                    this.isValidSignature = false;
                                }
                                PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] digest is null");
                                this.isValidSignature = false;
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)signed_content_is);
                            }
                        } else if (this.pdSig.getSubFilter().compareTo("ETSI.RFC3161") == 0) {
                            try {
                                this.tst = new TimeStampToken(this.p7Detached);
                                this.certificatesArray = this.tst.listCertificates();
                                this.signerCertificate = this.tst.getTSACert();
                                if (this.tst.getDate() != null) {
                                    this.detectedSigDate = Calendar.getInstance();
                                    this.detectedSigDate.setTime(this.tst.getDate());
                                }
                                try {
                                    verifica = this.tst.verifySignature();
                                    verifica_contenuto = this.tst.compare((InputStream)signed_content_is);
                                    if (!verifica || !verifica_contenuto) ** GOTO lbl185
                                    this.isValidSignature = true;
                                    PadesSignatureInformation.logger.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException e) {
                                    if (e.getErrorCode() == 3010) {
                                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.isValidSignature = false;
                                    }
                                    throw e;
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)signed_content_is);
                            }
                        } else {
                            try {
                                this.sse = new StreamSignedEnvelope((InputStream)new ByteArrayInputStream(this.p7Detached), (InputStream)signed_content_is);
                                this.certificatesArray = this.sse.listCertificates();
                                this.signerCertificate = this.sse.getSignerCertificate(0);
                                d = this.sse.getSigningTime(0, "yyyyMMddHHmmss");
                                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                                if (d != null) {
                                    date = sdf.parse(d);
                                    this.detectedSigDate = Calendar.getInstance();
                                    this.detectedSigDate.setTime(date);
                                }
                                try {
                                    this.sse.verify(0);
                                    this.isValidSignature = true;
                                    PadesSignatureInformation.logger.debug("[PadesSignatureInformation] valid signature");
                                }
                                catch (CapiException e) {
                                    if (e.getErrorCode() == 3010) {
                                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation]  invalid signature");
                                        this.isValidSignature = false;
                                        if (e.getDetailReason() == VerifyInfo.FailureReason.MISSING_SIGNER_CERT.value()) {
                                            PadesSignatureInformation.logger.debug("reason: MISSING_SIGNER_CERT");
                                        } else if (e.getDetailReason() == VerifyInfo.FailureReason.WRONG_SIGNATURE.value()) {
                                            PadesSignatureInformation.logger.debug("reason: WRONG_SIGNATURE");
                                        } else if (e.getDetailReason() == VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE.value()) {
                                            PadesSignatureInformation.logger.debug("reason: INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE");
                                        }
                                        break block69;
                                    }
                                    throw e;
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)signed_content_is);
                            }
                        }
                    }
                }
                if (!this.isValidSignature) {
                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] signature is invalid. Skip byterange check.");
                } else if (this.getByteRangeArray() != null) {
                    calculatedSignatureSize = this.getByteRangeArray()[2] - this.getByteRangeArray()[1] - 2;
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] calculatedSignatureSize: " + calculatedSignatureSize);
                    }
                    realSignatureSize = this.p7Detached.length * 2;
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] realSignatureSize: " + realSignatureSize);
                    }
                    calculatedSize = this.getByteRangeArray()[2] + this.getByteRangeArray()[3];
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.logger.debug("[PadesSignatureInformation] calculatedRevisionSize: " + calculatedSize);
                    }
                    if (SignedPDF.bDebug) {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] First ByteRange Offset: " + this.getByteRangeArray()[0]);
                    }
                    if (this.getByteRangeArray()[0] != 0) {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] invalid byteRange: first byte is not 0");
                        this.isValidSignature = false;
                    } else if (calculatedSignatureSize != realSignatureSize) {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] invalid byteRange: SignatureSize does not match");
                        this.isValidSignature = false;
                    } else {
                        PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] valid byteRange");
                    }
                } else {
                    PadesSignatureInformation.logger.debug("[initialize][PadesSignatureInformation] invalid byteRange");
                    this.isValidSignature = false;
                }
            }
            catch (ParseException ex) {
                PadesSignatureInformation.logger.error("Exception parsing signature: ", (Throwable)ex);
            }
            catch (GeneralSecurityException ex) {
                PadesSignatureInformation.logger.error("Exception parsing signature: ", (Throwable)ex);
            }
            catch (UnsupportedEncodingException ex) {
                PadesSignatureInformation.logger.error("Exception parsing signature: ", (Throwable)ex);
            }
            catch (IOException ex) {
                PadesSignatureInformation.logger.error("Exception parsing signature: ", (Throwable)ex);
            }
            catch (CapiException ex) {
                PadesSignatureInformation.logger.error("Exception parsing signature: ", (Throwable)ex);
            }
        }
        if (this.isValidSignature && !this.isSignature_cover_all_revision()) {
            this.isValidSignature = false;
        }
        return this.isValidSignature;
    }

    private byte[] getContents(COSFilterInputStream fis) throws IOException {
        int c;
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((c = fis.read(buffer)) != -1) {
            if (buffer[0] == 60 || buffer[0] == 40) {
                byteOS.write(buffer, 1, c);
                continue;
            }
            if (buffer[c - 1] == 62 || buffer[c - 1] == 41) {
                byteOS.write(buffer, 0, c - 1);
                continue;
            }
            byteOS.write(buffer, 0, c);
        }
        fis.close();
        return COSString.parseHex((String)byteOS.toString("ISO-8859-1")).getBytes();
    }

    public COSDictionary getSignatureDictionary() {
        return this.signatureDictionary;
    }

    public String getName() {
        return this.detectedSigName;
    }

    private int getCertificationLevel(COSBase refArr) {
        if (refArr != null && refArr instanceof COSArray) {
            if (SignedPDF.bDebug) {
                logger.debug("[getCertificatioLevel] Found Reference");
            }
            for (int j = 0; j < ((COSArray)refArr).size(); ++j) {
                COSBase p;
                COSBase t;
                COSBase transformParams;
                COSBase ctr;
                COSBase ctype;
                COSBase item = ((COSArray)refArr).get(j);
                if (item == null || !(item instanceof COSDictionary)) continue;
                if (SignedPDF.bDebug) {
                    logger.debug("[getCertificatioLevel] Found item");
                }
                if ((ctype = ((COSDictionary)item).getItem(COSName.getPDFName((String)"Type"))) == null || !(ctype instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    logger.debug("[getCertificatioLevel] Type " + ((COSName)ctype).getName());
                }
                if (((COSName)ctype).getName().compareToIgnoreCase("SigRef") != 0 || (ctr = ((COSDictionary)item).getItem(COSName.getPDFName((String)"TransformMethod"))) == null || !(ctr instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    logger.debug("[getCertificatioLevel] TransformMethod " + ((COSName)ctr).getName());
                }
                if (((COSName)ctr).getName().compareToIgnoreCase("DocMDP") != 0 && ((COSName)ctr).getName().compareToIgnoreCase("FieldMDP") != 0 || (transformParams = ((COSDictionary)item).getDictionaryObject(COSName.getPDFName((String)"TransformParams"))) == null || !(transformParams instanceof COSDictionary) || (t = ((COSDictionary)transformParams).getItem(COSName.getPDFName((String)"Type"))) == null || !(t instanceof COSName)) continue;
                if (SignedPDF.bDebug) {
                    logger.debug("[getCertificatioLevel] Type " + ((COSName)t).getName());
                }
                if (((COSName)t).getName().compareToIgnoreCase("TransformParams") != 0 || (p = ((COSDictionary)transformParams).getItem(COSName.getPDFName((String)"P"))) == null || !(p instanceof COSInteger)) continue;
                if (SignedPDF.bDebug) {
                    logger.debug("[getCertificatioLevel] P " + ((COSInteger)p).intValue());
                }
                return ((COSInteger)p).intValue();
            }
        }
        return 0;
    }

    public int getCertificationLevel() {
        return this.detectedCertificationLevel;
    }

    public List<Certificate> getCertificatesArray() {
        return this.certificatesArray;
    }

    public String getReason() {
        return this.detectedReason;
    }

    public String getLocation() {
        return this.detectedLocation;
    }

    public String getSignName() {
        return this.detectedSigName;
    }

    public Calendar getSignDate() {
        return this.detectedSigDate;
    }

    public String getSubFilter() {
        return this.subFilter;
    }

    public static Logger getLogger() {
        return logger;
    }

    public COSDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }

    public boolean isValidSignature() {
        return this.isValidSignature;
    }

    public String getCertificateInSigDictionary() {
        return this.certificateInSigDictionary;
    }

    public int[] getByteRangeArray() {
        COSArray byteRange = (COSArray)this.signatureDictionary.getDictionaryObject(COSName.BYTERANGE);
        if (byteRange != null) {
            int[] ary = new int[byteRange.size()];
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = byteRange.getInt(i);
            }
            return ary;
        }
        return null;
    }

    public GraphometricInfo getGraphometricInfo() {
        return this.graph_info;
    }

    public AutenticaBinding getAutentica_info() {
        return this.autentica_info;
    }

    public FeaInfo getFeaInfo() {
        return this.fea_info;
    }

    public byte[] getP7Detached() {
        return Util.copyOf((byte[])this.p7Detached, (int)this.p7Detached.length);
    }

    public RevisionInformation getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionInformation revision) {
        this.revision = revision;
    }

    public boolean isSignature_cover_all_revision() {
        return this.signature_cover_all_revision;
    }

    public void setSignature_cover_all_revision(boolean signature_cover_all_revision) {
        this.signature_cover_all_revision = signature_cover_all_revision;
    }

    public byte[] getSignatureTimeStampToken() throws CapiException {
        if (this.sse != null) {
            return this.sse.getSignatureTimeStampToken(0);
        }
        if (this.se != null) {
            return this.se.getSignatureTimeStampToken(0);
        }
        return null;
    }

    public boolean hasSigningCertificateV2() throws CapiException {
        if (this.sse != null) {
            return this.sse.hasSigningCertificateV2(0);
        }
        if (this.se != null) {
            return this.se.hasSigningCertificateV2(0);
        }
        if (this.tst != null) {
            return this.tst.hasSigningCertificateV2();
        }
        return false;
    }

    public String getSigningCertificateV2HashAlg() throws CapiException {
        if (this.sse != null) {
            return this.sse.getSigningCertificateV2HashAlg(0);
        }
        if (this.se != null) {
            return this.se.getSigningCertificateV2HashAlg(0);
        }
        if (this.tst != null) {
            return this.tst.getSigningCertificateV2HashAlg();
        }
        return null;
    }

    public boolean hasSigningCertificate() throws CapiException {
        if (this.sse != null) {
            return this.sse.hasSigningCertificate(0);
        }
        if (this.se != null) {
            return this.se.hasSigningCertificate(0);
        }
        if (this.tst != null) {
            return this.tst.hasSigningCertificate();
        }
        return false;
    }

    public String getSignerDigestAlg() throws CapiException {
        if (this.sse != null) {
            return this.sse.getSignerDigestAlg(0);
        }
        if (this.se != null) {
            return this.se.getSignerDigestAlg(0);
        }
        if (this.tst != null) {
            return this.tst.getSignerDigestAlg();
        }
        return Constants.SHA1;
    }

    public Certificate getSignerCertificate() throws CapiException {
        return this.signerCertificate;
    }

    public byte[] getSignature() throws CapiException {
        if (this.sse != null) {
            return this.sse.getSignature(0);
        }
        if (this.se != null) {
            return this.se.getSignature(0);
        }
        return this.p7Detached;
    }

    public String getSignerEncryptionAlg() throws CapiException {
        if (this.sse != null) {
            return this.sse.getSignerEncryptionAlg(0);
        }
        if (this.se != null) {
            return this.se.getSignerEncryptionAlg(0);
        }
        if (this.tst != null) {
            this.tst.getSignerEncryptionAlg();
        }
        return "RSA";
    }

    public boolean nextRevisionsUpdateObject() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation rev = this.getRevision().getNextRevision(); rev != null; rev = rev.getNextRevision()) {
                if (!rev.isUpdatePreviousObject()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionsSigned() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation rev = this.getRevision().getNextRevision(); rev != null; rev = rev.getNextRevision()) {
                if (!rev.isSignedRevision()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionUpdateField() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation rev = this.getRevision().getNextRevision(); rev != null; rev = rev.getNextRevision()) {
                if (!rev.isUpdatePreviousField()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nextRevisionUpdateAnnotation() {
        if (this.getRevision() != null && this.getRevision().getNextRevision() != null) {
            for (RevisionInformation rev = this.getRevision().getNextRevision(); rev != null; rev = rev.getNextRevision()) {
                if (!rev.isUpdatePreviousAnnotation()) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] getMessageDigest() throws CapiException {
        if (this.sse != null) {
            return this.sse.getMessageDigest(0);
        }
        if (this.se != null) {
            return this.se.getMessageDigest(0);
        }
        if (this.tst != null) {
            return this.tst.getHashedMessage();
        }
        return null;
    }

    public byte[] getRawSignature() throws CapiException {
        Object proxy = null;
        if (this.sse != null) {
            return this.sse.getSignedDataProxy().getRawSignature(0);
        }
        if (this.se != null) {
            return this.se.getSignedDataProxy().getRawSignature(0);
        }
        if (this.tst != null) {
            try {
                return this.tst.toByteArray(false, true);
            }
            catch (IOException ex) {
                throw new CapiException(ex.getMessage(), 50040);
            }
        }
        return null;
    }

    public LinkedList<X509Certificate> getCerts() {
        COSDictionary dicVRI;
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        if (this.padesDssInfo != null && (dicVRI = (COSDictionary)this.padesDssInfo.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                COSArray arrCert;
                String vri_id = new String(Hex.encode((byte[])this.vri_sha1)).toUpperCase();
                logger.debug("VRI id:{}", (Object)vri_id);
                COSDictionary currentVRI = (COSDictionary)dicVRI.getDictionaryObject(vri_id);
                if (currentVRI != null && (arrCert = PadesUtils.parseArray(currentVRI, "Cert")) != null) {
                    for (int i = 0; i < arrCert.size(); ++i) {
                        COSStream stream = (COSStream)arrCert.getObject(i);
                        byte[] c = Util.getBytesFromInputStream((InputStream)stream.createRawInputStream());
                        Certificate intCert = new Certificate(c);
                        certs.add(intCert.getInternalCert());
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return certs;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        COSDictionary dicVRI;
        LinkedList<BasicOCSPResp> ocsps = new LinkedList<BasicOCSPResp>();
        if (this.padesDssInfo != null && (dicVRI = (COSDictionary)this.padesDssInfo.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                COSArray arrOcsp;
                String vri_id = new String(Hex.encode((byte[])this.vri_sha1)).toUpperCase();
                logger.debug("VRI id:{}", (Object)vri_id);
                COSDictionary currentVRI = (COSDictionary)dicVRI.getDictionaryObject(vri_id);
                if (currentVRI != null && (arrOcsp = PadesUtils.parseArray(currentVRI, "OCSP")) != null) {
                    for (int i = 0; i < arrOcsp.size(); ++i) {
                        COSStream stream = (COSStream)arrOcsp.getObject(i);
                        byte[] ocsp = Util.getBytesFromInputStream((InputStream)stream.createRawInputStream());
                        BasicOCSPResp resp = (BasicOCSPResp)new OCSPResp(ocsp).getResponseObject();
                        ocsps.add(resp);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return ocsps;
    }

    public LinkedList<CRL> getCrls() {
        COSDictionary dicVRI;
        LinkedList<CRL> crls = new LinkedList<CRL>();
        if (this.padesDssInfo != null && (dicVRI = (COSDictionary)this.padesDssInfo.getDicDSS().getDictionaryObject("VRI")) != null) {
            try {
                COSArray arrCrl;
                String vri_id = new String(Hex.encode((byte[])this.vri_sha1)).toUpperCase();
                logger.debug("VRI id:{}", (Object)vri_id);
                COSDictionary currentVRI = (COSDictionary)dicVRI.getDictionaryObject(vri_id);
                if (currentVRI != null && (arrCrl = PadesUtils.parseArray(currentVRI, "CRL")) != null) {
                    for (int i = 0; i < arrCrl.size(); ++i) {
                        COSStream stream = (COSStream)arrCrl.getObject(i);
                        CRL crl = new CRL(stream.createRawInputStream());
                        crls.add(crl);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return crls;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    PDSignatureField getSignature_field() {
        return this.signature_field;
    }

    public PadesDssInfo getPadesDssInfo() {
        return this.padesDssInfo;
    }

    public String getVri() {
        String vri_id = new String(Hex.encode((byte[])this.vri_sha1)).toUpperCase();
        return vri_id;
    }

    public boolean hasMultipleSigners() {
        boolean hasMultipleSigners = false;
        if (this.sse != null) {
            boolean bl = hasMultipleSigners = this.sse.getSignedDataProxy().getNumberOfSigners() > 1;
        }
        if (this.se != null) {
            hasMultipleSigners = this.se.getSignedDataProxy().getNumberOfSigners() > 1;
        }
        return hasMultipleSigners;
    }

    public boolean hasRFC5652_SignedAttrDER() {
        return this.hasRFC5652_SignedAttrDER;
    }

    public void setRFC5652_SignedAttrDER(boolean value) {
        this.hasRFC5652_SignedAttrDER = value;
    }
}

