/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.slf4j.Logger;

public class ThreadComparePage
implements Runnable {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private HashMap<Integer, byte[]> pages_hash;
    private LinkedHashMap<Integer, List<PDAnnotation>> pages_annot;
    private int thread_id;
    private int thread_number;
    private PDDocument document;
    private PDDocument previus_document;
    private int current_index;
    boolean equalPage = true;
    boolean equalAnnotation = true;

    public ThreadComparePage(HashMap<Integer, byte[]> pages_hash, int thread_id, int thread_number, PDDocument previus_document, PDDocument current_revision_doc, LinkedHashMap<Integer, List<PDAnnotation>> pages_annot) {
        this.pages_hash = pages_hash;
        this.pages_annot = pages_annot;
        this.thread_id = thread_id;
        this.thread_number = thread_number;
        this.current_index = thread_id;
        this.document = current_revision_doc;
        this.previus_document = previus_document;
    }

    @Override
    public void run() {
        while (this.current_index < this.document.getPages().getCount()) {
            PDPage new_page = this.document.getPages().get(this.current_index);
            try {
                if (!this.compare_page(this.current_index, new_page)) {
                    this.equalPage = false;
                }
                if (this.annotationListUpdated(new_page.getAnnotations(), this.pages_annot.get(this.current_index))) {
                    this.equalAnnotation = false;
                }
                this.pages_annot.put(this.current_index, new_page.getAnnotations());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.current_index += this.thread_number;
        }
    }

    public boolean isEqualPage() {
        return this.equalPage;
    }

    private boolean compare_page(int page_index, PDPage new_page) throws IOException {
        boolean blnReturn = false;
        if (this.pages_hash.get(page_index) != null) {
            byte[] oldhash = this.pages_hash.get(page_index);
            this.update_page_hash(page_index, new_page);
            byte[] newhash = this.pages_hash.get(page_index);
            if (Arrays.equals(oldhash, newhash)) {
                blnReturn = true;
            }
        } else {
            this.update_page_hash(page_index, new_page);
        }
        return blnReturn;
    }

    private void update_page_hash(int page_index, PDPage page) throws IOException {
        int letti;
        InputStream is = page.getContents();
        MD5Digest digest = new MD5Digest();
        byte[] buffer = new byte[4096];
        while ((letti = is.read(buffer)) != -1) {
            digest.update(buffer, 0, letti);
        }
        is.close();
        int size = digest.getDigestSize();
        byte[] arrReturn = new byte[size];
        digest.doFinal(arrReturn, 0);
        this.pages_hash.put(page_index, arrReturn);
    }

    private boolean annotationListUpdated(List<PDAnnotation> annotatios, List<PDAnnotation> annotatios_prev) {
        boolean annotation_field = false;
        if (annotatios_prev == null) {
            return false;
        }
        LinkedList<PDAnnotation> annotation_non_presenti = new LinkedList<PDAnnotation>();
        for (int h = 0; h < annotatios.size(); ++h) {
            PDAnnotation new_annot = annotatios.get(h);
            String new_id = this.document.getDocument().getKey((COSBase)new_annot.getCOSObject()).toString();
            if (new_annot.getCOSObject().getItem(COSName.FT) != null) continue;
            PDAnnotation trovato = null;
            for (int d = 0; d < annotatios_prev.size(); ++d) {
                PDAnnotation prev_annot = annotatios_prev.get(d);
                String old_id = this.previus_document.getDocument().getKey((COSBase)prev_annot.getCOSObject()).toString();
                if (!new_id.equals(old_id)) continue;
                trovato = prev_annot;
                break;
            }
            if (trovato == null) {
                annotation_non_presenti.add(new_annot);
                continue;
            }
            boolean content = true;
            for (Map.Entry entry : new_annot.getCOSObject().entrySet()) {
                if (entry.getKey().equals(COSName.P)) continue;
                String trovata = trovato.getCOSObject().getItem((COSName)entry.getKey()).toString();
                if (entry.getValue().toString().equals(trovata)) continue;
                content = false;
                break;
            }
            if (content) continue;
            annotation_field = true;
            break;
        }
        if (!annotation_field && annotation_non_presenti.size() > 0) {
            annotation_field = true;
        }
        return annotation_field;
    }

    private String safeNullString(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean isEqualAnnotation() {
        return this.equalAnnotation;
    }
}

