/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils;

import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAutenticator
extends Authenticator {
    private HashMap<String, PasswordAuthentication> oldcredential = new HashMap();
    private HashMap<String, NetworkConfig> config_forproxy = new HashMap();
    private static final Logger logger2 = LoggerFactory.getLogger(NetworkConfig.class);
    private Logger logger = logger2;

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        NetworkConfig conf = this.config_forproxy.get(this.getRequestingHost());
        if (conf == null && this.getRequestingSite() != null) {
            this.logger.debug("Config non trovata per l'host " + this.getRequestingHost());
            this.logger.debug("Tentativo di recupero della config con l'ip " + this.getRequestingSite().getHostAddress());
            conf = this.config_forproxy.get(this.getRequestingSite().getHostAddress());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Protocol:" + this.getRequestingProtocol());
            this.logger.debug("Prompt:" + this.getRequestingPrompt());
            this.logger.debug("Scheme:" + this.getRequestingScheme());
            this.logger.debug("Type:" + this.getRequestorType().toString());
            this.logger.debug("URL:" + this.getRequestingURL().toString());
            if (this.getRequestingSite() != null) {
                this.logger.debug("SITE Hostname:" + this.getRequestingSite().getHostName());
                this.logger.debug("SITE IP:" + this.getRequestingSite().getHostAddress());
            }
            this.logger.debug("HOST:" + this.getRequestingHost());
            this.logger.debug("PORT:" + this.getRequestingPort());
            this.logger.debug("Ricerca Configurazione Thread {}", (Object)Thread.currentThread().getId());
            this.logger.debug("Thread Name {}", (Object)Thread.currentThread().getName());
            if (conf != null) {
                this.logger.debug("Proxy Host configured {}", (Object)conf.getProxy());
                this.logger.debug("Proxy Port configured {}", (Object)conf.getProxyPort());
            } else {
                this.logger.debug("No config found");
            }
        }
        PasswordAuthentication objReturn = null;
        if (conf != null) {
            if (conf.getProxy() != null && !conf.getProxy().isEmpty() && (conf.getProxy().equals(this.getRequestingHost()) || this.getRequestingSite() != null && conf.getProxy().equals(this.getRequestingSite().getHostAddress())) && conf.getProxyPort().equals(String.valueOf(this.getRequestingPort()))) {
                this.logger.debug("Richiesta Credenziali Per Proxy http");
                if (conf.getUserProxy() != null && !conf.getUserProxy().equals("")) {
                    objReturn = new PasswordAuthentication(conf.getUserProxy(), conf.getPasswordProxy().toCharArray());
                    URL url = this.getRequestingURL();
                    PasswordAuthentication oldpa = null;
                    if (url != null) {
                        String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                        oldpa = this.oldcredential.get(urlpath);
                        this.oldcredential.put(urlpath, objReturn);
                    }
                    if (oldpa != null && oldpa.getUserName().equals(objReturn.getUserName()) && new String(oldpa.getPassword()).equals(new String(objReturn.getPassword())) && conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), objReturn.getUserName(), new String(objReturn.getPassword()), "http");
                        conf.setUserProxy(objReturn.getUserName());
                        conf.setPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                } else if (objReturn == null) {
                    if (conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), null, null, "http");
                        conf.setUserProxy(objReturn.getUserName());
                        conf.setPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                } else {
                    URL url = this.getRequestingURL();
                    String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                    PasswordAuthentication oldpa = this.oldcredential.get(urlpath);
                    this.oldcredential.put(urlpath, objReturn);
                    if (oldpa != null && oldpa.getUserName().equals(objReturn.getUserName()) && new String(oldpa.getPassword()).equals(new String(objReturn.getPassword())) && conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), objReturn.getUserName(), new String(objReturn.getPassword()), "http");
                        conf.setUserProxy(objReturn.getUserName());
                        conf.setPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                }
            } else if (conf.getLdapProxy() != null && !conf.getLdapProxy().isEmpty() && (conf.getLdapProxy().equals(this.getRequestingHost()) || this.getRequestingSite() != null && conf.getLdapProxy().equals(this.getRequestingSite().getHostAddress())) && conf.getLdapProxyPort().equals(String.valueOf(this.getRequestingPort()))) {
                this.logger.debug("Richiesta Credenziali Per Proxy ldap");
                if (conf.getLdapUserProxy() != null && !conf.getLdapUserProxy().equals("")) {
                    objReturn = new PasswordAuthentication(conf.getLdapUserProxy(), conf.getLdapPasswordProxy().toCharArray());
                    URL url = this.getRequestingURL();
                    PasswordAuthentication oldpa = null;
                    if (url != null) {
                        String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                        oldpa = this.oldcredential.get(urlpath);
                        this.oldcredential.put(urlpath, objReturn);
                    }
                    if (oldpa != null && oldpa.getUserName().equals(objReturn.getUserName()) && new String(oldpa.getPassword()).equals(new String(objReturn.getPassword())) && conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), objReturn.getUserName(), new String(objReturn.getPassword()), "ldap");
                        conf.setLdapUserProxy(objReturn.getUserName());
                        conf.setLdapPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                } else if (objReturn == null) {
                    if (conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), null, null, "ldap");
                        conf.setLdapUserProxy(objReturn.getUserName());
                        conf.setLdapPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                } else {
                    URL url = this.getRequestingURL();
                    PasswordAuthentication oldpa = null;
                    if (url != null) {
                        String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                        oldpa = this.oldcredential.get(urlpath);
                        this.oldcredential.put(urlpath, objReturn);
                    }
                    if (oldpa != null && oldpa.getUserName().equals(objReturn.getUserName()) && new String(oldpa.getPassword()).equals(new String(objReturn.getPassword())) && conf.getProxyauthenticator() != null) {
                        objReturn = conf.getProxyauthenticator().getAuth(this.getRequestingPrompt(), objReturn.getUserName(), new String(objReturn.getPassword()), "ldap");
                        conf.setLdapUserProxy(objReturn.getUserName());
                        conf.setLdapPasswordProxy(new String(objReturn.getPassword()));
                        conf.setChanged(true);
                    }
                }
            }
        }
        return objReturn;
    }

    public HashMap<String, PasswordAuthentication> getOldCredential() {
        return this.oldcredential;
    }

    public void setProxyConfig(String proxyHost, NetworkConfig config) {
        if (!this.config_forproxy.containsKey(proxyHost)) {
            this.config_forproxy.put(proxyHost, config);
        } else if (this.config_forproxy.get(proxyHost).getUserProxy() != null && !this.config_forproxy.get(proxyHost).getUserProxy().equals(config.getUserProxy()) || this.config_forproxy.get(proxyHost).getPasswordProxy() != null && !this.config_forproxy.get(proxyHost).getPasswordProxy().equals(config.getPasswordProxy()) || this.config_forproxy.get(proxyHost).getLdapUserProxy() != null && !this.config_forproxy.get(proxyHost).getLdapUserProxy().equals(config.getLdapUserProxy()) || this.config_forproxy.get(proxyHost).getLdapPasswordProxy() != null && !this.config_forproxy.get(proxyHost).getLdapPasswordProxy().equals(config.getLdapPasswordProxy())) {
            this.config_forproxy.put(proxyHost, config);
        }
    }

    public void removeProxyConfig(String proxyHost) {
        this.config_forproxy.remove(proxyHost);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

